/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.jdbc.JDBCPieDataset;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsJDBCCategoryDataset2;
import org.opengion.hayabusa.io.TypeRenderer;

public class ChartFactory {
    private static final String PLOT_SUB = "org.opengion.hayabusa.io.ChartPlot_";
    private static volatile ChartPlot plot_cat = null;
    private static volatile ChartPlot plot_xy = null;
    private static volatile ChartPlot plot_pie = null;
    private static final Object lock = new Object();
    private static final Map<String, TypeRenderer> TYPE_RENDERER_MAP = new HashMap<String, TypeRenderer>();

    private ChartFactory() {
    }

    public static final Dataset newDataset(Connection connection, String string, String string2) throws SQLException {
        HybsJDBCCategoryDataset2 hybsJDBCCategoryDataset2;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string2);
        String string3 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string3) || "PieCategory".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new HybsJDBCCategoryDataset2(connection, string);
        } else if ("XY".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new JDBCXYDataset(connection, string);
        } else if ("Pie".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new JDBCPieDataset(connection, string);
        } else if ("Value".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new DefaultValueDataset();
        } else {
            String string4 = "Category,Pie,XY,Value \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string3 + "]";
            throw new HybsSystemException(string4);
        }
        return hybsJDBCCategoryDataset2;
    }

    public static final Dataset newDataset(DBTableModel dBTableModel, String string) {
        DefaultCategoryDataset defaultCategoryDataset;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string);
        int n = dBTableModel.getColumnCount();
        int n2 = dBTableModel.getRowCount();
        String string2 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string2) || "PieCategory".equalsIgnoreCase(string2)) {
            DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
            String[] stringArray = dBTableModel.getNames();
            for (int i = 0; i < n2; ++i) {
                String string3 = (String)dBTableModel.getValue(i, 0);
                String[] stringArray2 = (String[])dBTableModel.getValues(i);
                for (int j = 1; j < n; ++j) {
                    String string4 = stringArray2[j];
                    double d = string4 == null || string4.length() == 0 ? 0.0 : Double.parseDouble(string4);
                    defaultCategoryDataset2.addValue(d, (Comparable)((Object)stringArray[j]), (Comparable)((Object)string3));
                }
            }
            defaultCategoryDataset = defaultCategoryDataset2;
        } else if ("XY".equalsIgnoreCase(string2)) {
            CategoryTableXYDataset categoryTableXYDataset = new CategoryTableXYDataset();
            String[] stringArray = dBTableModel.getNames();
            for (int i = 0; i < n2; ++i) {
                String string5 = (String)dBTableModel.getValue(i, 0);
                String[] stringArray3 = (String[])dBTableModel.getValues(i);
                double d = stringArray3[0] == null || stringArray3[0].length() == 0 ? 0.0 : Double.parseDouble(stringArray3[0]);
                for (int j = 1; j < n; ++j) {
                    String string6 = stringArray3[j];
                    double d2 = string6 == null || string6.length() == 0 ? 0.0 : Double.parseDouble(string6);
                    categoryTableXYDataset.add(d, d2, stringArray[j]);
                }
            }
            defaultCategoryDataset = categoryTableXYDataset;
        } else if ("Pie".equalsIgnoreCase(string2)) {
            DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray = (String[])dBTableModel.getValues(i);
                String string7 = stringArray[0];
                String string8 = stringArray[1];
                double d = string8 == null || string8.length() == 0 ? 0.0 : Double.parseDouble(string8);
                defaultKeyedValues.addValue((Comparable)((Object)string7), d);
            }
            defaultCategoryDataset = new DefaultPieDataset((KeyedValues)defaultKeyedValues);
        } else if ("Value".equalsIgnoreCase(string2)) {
            defaultCategoryDataset = new DefaultValueDataset();
        } else {
            String string9 = "Category,Pie,XY,Value \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string2 + "]";
            throw new HybsSystemException(string9);
        }
        return defaultCategoryDataset;
    }

    public static final TypeRenderer getTypeRenderer(String string) {
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        if (typeRenderer == null) {
            String string2 = "\u6307\u5b9a\u306e\u30bf\u30a4\u30d7\u306b\u8a72\u5f53\u3059\u308b Renderer \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string + "]" + HybsSystem.CR + "Key=" + Arrays.toString(TYPE_RENDERER_MAP.keySet().toArray(new String[TYPE_RENDERER_MAP.size()]));
            throw new HybsSystemException(string2);
        }
        return typeRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ChartPlot newChartPlot(String string) {
        ChartPlot chartPlot;
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        String string2 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_cat == null) {
                    plot_cat = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_cat;
        } else if ("XY".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_xy == null) {
                    plot_xy = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_xy;
        } else {
            if ("PieCategory".equalsIgnoreCase(string2)) {
                string2 = "Pie";
            }
            Object object = lock;
            synchronized (object) {
                if (plot_pie == null) {
                    plot_pie = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_pie;
        }
        return chartPlot;
    }

    static {
        String[][] stringArrayArray = new String[][]{{"HybsLine", "HybsLineRenderer", "Category"}, {"HybsBar", "HybsBarRenderer", "Category"}, {"HybsStackedBar", "HybsStackedBarRenderer", "Category"}, {"Area", "category.AreaRenderer", "Category"}, {"Bar", "category.BarRenderer", "Category"}, {"Bar3D", "category.BarRenderer3D", "Category"}, {"BoxAndWhisker", "category.BoxAndWhiskerRenderer", "Category"}, {"CategoryStep", "category.CategoryStepRenderer", "Category"}, {"Gantt", "category.GanttRenderer", "Category"}, {"GroupedStackedBar", "category.GroupedStackedBarRenderer", "Category"}, {"IntervalBar", "category.IntervalBarRenderer", "Category"}, {"LayeredBar", "category.LayeredBarRenderer", "Category"}, {"Level", "category.LevelRenderer", "Category"}, {"LineAndShape", "category.LineAndShapeRenderer", "Category"}, {"Line3D", "category.LineRenderer3D", "Category"}, {"MinMax", "category.MinMaxCategoryRenderer", "Category"}, {"StackedArea", "category.StackedAreaRenderer", "Category"}, {"StackedBar", "category.StackedBarRenderer", "Category"}, {"StackedBar3D", "category.StackedBarRenderer3D", "Category"}, {"WaterfallBar", "category.WaterfallBarRenderer", "Category"}, {"CyclicXYItem", "xy.CyclicXYItemRenderer", "XY"}, {"HighLow", "xy.HighLowRenderer", "XY"}, {"StackedXYArea", "xy.StackedXYAreaRenderer", "XY"}, {"StackedXYArea2", "xy.StackedXYAreaRenderer2", "XY"}, {"StandardXYItem", "xy.StandardXYItemRenderer", "XY"}, {"XYArea", "xy.XYAreaRenderer", "XY"}, {"XYArea2", "xy.XYAreaRenderer2", "XY"}, {"XYBlock", "xy.XYBlockRenderer", "XY"}, {"XYBubble", "xy.XYBubbleRenderer", "XY"}, {"XYDifference", "xy.XYDifferenceRenderer", "XY"}, {"XYDot", "xy.XYDotRenderer", "XY"}, {"XYError", "xy.XYErrorRenderer", "XY"}, {"XYLine3D", "xy.XYLine3DRenderer", "XY"}, {"XYLineAndShape", "xy.XYLineAndShapeRenderer", "XY"}, {"XYStepArea", "xy.XYStepAreaRenderer", "XY"}, {"XYStep", "xy.XYStepRenderer", "XY"}, {"Meter", null, "Value"}, {"MultiplePie", null, "PieCategory"}, {"Pie", null, "Pie"}, {"Pie3D", null, "Pie"}, {"Ring", null, "Pie"}, {"SpiderWeb", null, "PieCategory"}, {"Thermometer", null, "Value"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            TYPE_RENDERER_MAP.put(stringArrayArray[i][0], new TypeRenderer(stringArrayArray[i][0], stringArrayArray[i][1], stringArrayArray[i][2]));
        }
    }
}

