/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import java.util.Locale;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * 各種共通メソッドを集めたユーティリティクラスです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class Utils extends BizLogic_ENTRY {

	/**
	 * 最大桁数を返します。
	 * 
	 * @param bunrui
	 * @param length
	 * @return 最大桁数
	 */
	public static int getLength( final String bunrui, final int length ) {
		if( "TEXTAREA".equals( bunrui ) )		{ return 4000; }
		else if( "YMD".equals( bunrui ) )		{ return 8; }
		else if( "YM".equals( bunrui ) )		{ return 6; }
		else if( "CHBOX".equals( bunrui ) )		{ return 20; }
		else if( "RADIO".equals( bunrui ) )		{ return 20; }
		else if( "MENU".equals( bunrui ) )		{ return 20; }
		else									{ return length; }
	}

	/**
	 * DBクラスを返します。
	 * 
	 * @param bunrui
	 * @return DBクラス
	 */
	public static String getDbcls( final String bunrui ) {
		return "VARCHAR2";
	}

	/**
	 * レンデラーを返します。
	 * 
	 * @param bunrui
	 * @return レンデラー
	 */
	public static String getRenderer( final String bunrui ) {
		if( "TEXT".equals( bunrui ) )			{ return "LABEL"; }
		else if( "XTEXT".equals( bunrui ) )		{ return "LABEL"; }
		else if( "TEXTAREA".equals( bunrui ) )	{ return "TEXTAREA"; }
		else if( "YMD".equals( bunrui ) )		{ return "YMD"; }
		else if( "YM".equals( bunrui ) )		{ return "YM"; }
		else if( "CHBOX".equals( bunrui ) )		{ return "LABEL"; }
		else if( "RADIO".equals( bunrui ) )		{ return "LABEL"; }
		else if( "MENU".equals( bunrui ) )		{ return "LABEL"; }
		else									{ return "LABEL"; }
	}

	/**
	 * エディターを返します。
	 * 
	 * @param bunrui
	 * @return エディター
	 */
	public static String getEditor( final String bunrui ) {
		if( "TEXT".equals( bunrui ) )			{ return "TEXT"; }
		else if( "XTEXT".equals( bunrui ) )		{ return "TEXT"; }
		else if( "TEXTAREA".equals( bunrui ) )	{ return "TEXTAREA"; }
		else if( "YMD".equals( bunrui ) )		{ return "YMD"; }
		else if( "YM".equals( bunrui ) )		{ return "YM"; }
		else if( "CHBOX".equals( bunrui ) )		{ return "CHBOX2"; }
		else if( "RADIO".equals( bunrui ) )		{ return "RADIO2"; }
		else if( "MENU".equals( bunrui ) )		{ return "TEXT"; }
		else									{ return "TEXT"; }
	}

	/**
	 * DBタイプを返します。
	 * 
	 * @param bunrui
	 * @return DBタイプ
	 */
	public static String getDbtype( final String bunrui ) {
		if( "TEXT".equals( bunrui ) )			{ return "KX"; }
		else if( "XTEXT".equals( bunrui ) )		{ return "X"; }
		else if( "TEXTAREA".equals( bunrui ) )	{ return "KX"; }
		else if( "YMD".equals( bunrui ) )		{ return "YMD"; }
		else if( "YM".equals( bunrui ) )		{ return "YM"; }
		else if( "CHBOX".equals( bunrui ) )		{ return "XK"; }
		else if( "RADIO".equals( bunrui ) )		{ return "XK"; }
		else if( "MENU".equals( bunrui ) )		{ return "XK"; }
		else									{ return "X"; }
	}

	/**
	 * カラムリソースのパラメーターを返します。
	 * 
	 * @param bunrui
	 * @return カラムリソースのパラメーター
	 */
	public static String getParam( final String bunrui ) {
		if( "TEXTAREA".equals( bunrui ) )		{ return "4,60"; }
		else									{ return ""; }
	}

	/**
	 * ファイル名から拡張子(小文字)を求めます。
	 * 
	 * @param fileName
	 * @return 拡張子(小文字)
	 */
	public static boolean checkImageName( final String fileName ) {
		if( fileName == null || fileName.length() == 0 ) { return false; }

		String suffix = getSuffix( fileName );
		if( !suffix.equalsIgnoreCase( "jpg" ) && !suffix.equalsIgnoreCase( "jpeg" )
			&& !suffix.equalsIgnoreCase( "bmp" ) && !suffix.equalsIgnoreCase( "gif" )
			&& !suffix.equalsIgnoreCase( "png" ) ) {
			return false;
		}

		return true;
	}

	/**
	 * ファイル名から拡張子(小文字)を求めます。
	 * 
	 * @param fileName
	 * @return 拡張子(小文字)
	 */
	public static String getSuffix( final String fileName ) {
		String suffix = null;
		if( fileName != null ) {
			int sufIdx = fileName.lastIndexOf( '.' );
			if( sufIdx >= 0 ) {
				suffix = fileName.substring( sufIdx + 1 ).toLowerCase( Locale.JAPAN );
			}
		}
		return suffix;
	}
}
