/**************************************************************************/
/* AN04 ( 主催者マスタ )                                                  */
/*                                                                        */
/* Created : 2010/10/08 09:29:32                                          */
/**************************************************************************/
CREATE TABLE AN04 (
   USERID   VARCHAR2(10)                  NOT NULL      /* 1  ユーザーID     */
 , PASSWD   VARCHAR2(20)                  NOT NULL      /* 2  パスワード     */
 , ROLES    VARCHAR2(500)                 NOT NULL      /* 3  ロールズ       */
 , NAME_JA  VARCHAR2(500)                 NOT NULL      /* 4  ユーザー名称   */
 , MAILAD   VARCHAR2(200)                 NOT NULL      /* 5  メールアドレス */
 , UPROFILE VARCHAR2(4000)                              /* 6  プロフィール   */
 , IMGUSER  VARCHAR2(200)                               /* 7  ユーザー画像   */
 , UPOINT   NUMBER(9)         DEFAULT 0   NOT NULL      /* 8  ポイント       */
 , UNIQ     NUMBER(9)         DEFAULT 0   NOT NULL      /* 9  ユニークキー   */
 , FGJ      VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 10 状態フラグ     */
 , DYSET    VARCHAR2(14)                                /* 11 登録日時       */
 , PGSET    VARCHAR2(10)                                /* 12 作成PG         */
 , PGPSET   VARCHAR2(10)                                /* 13 作成親PG       */
 , USRSET   VARCHAR2(10)                                /* 14 作成社員       */
 , DYUPD    VARCHAR2(14)                                /* 15 更新日時       */
 , PGUPD    VARCHAR2(10)                                /* 16 更新PG         */
 , PGPUPD   VARCHAR2(10)                                /* 17 更新親PG       */
 , USRUPD   VARCHAR2(10)                                /* 18 更新者         */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN04S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN04T00 
BEFORE INSERT ON AN04
FOR EACH ROW 
BEGIN 
SELECT AN04S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

