/**************************************************************************/
/* AN02 ( アンケート項目マスタ )                                          */
/*                                                                        */
/* Created : 2010/10/08 09:29:32                                          */
/**************************************************************************/
CREATE TABLE AN02 (
   USERID    VARCHAR2(10)                  NOT NULL      /* 1  ユーザーID       */
 , CDANK     VARCHAR2(10)                  NOT NULL      /* 2  アンケートC      */
 , CDSITSU   VARCHAR2(10)                  NOT NULL      /* 3  質問C            */
 , SEQNO     NUMBER(7)         DEFAULT 0   NOT NULL      /* 4  表示順           */
 , NAIYO     VARCHAR2(4000)                NOT NULL      /* 5  質問内容         */
 , SITSUGRP  VARCHAR2(4000)                              /* 6  質問グループ     */
 , IMGNAI    VARCHAR2(200)                               /* 7  質問画像         */
 , IMGSNAI   VARCHAR2(10)                                /* 8  質問画像(拡張子) */
 , FGKEY     VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 9  キー項目         */
 , FGMUST    VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 10 回答必須         */
 , KBUNRUI   VARCHAR2(10)                  NOT NULL      /* 11 回答方法         */
 , KLENGTH   NUMBER(9)         DEFAULT 10  NOT NULL      /* 12 入力桁数         */
 , KNOTE     VARCHAR2(200)                               /* 13 回答注釈         */
 , SUONELINE NUMBER(9)         DEFAULT 1   NOT NULL      /* 14 1行選択肢数      */
 , RSCODE    VARCHAR2(20)                                /* 15 連携用質問C      */
 , INIVAL    VARCHAR2(50)                                /* 16 初期値           */
 , CSKEY     VARCHAR2(200)                               /* 17 抽出キー         */
 , CSWAY     VARCHAR2(10)                                /* 18 抽出方法         */
 , SUCS      NUMBER(9)         DEFAULT 0   NOT NULL      /* 19 抽出件数         */
 , VDCDTN    VARCHAR2(200)                               /* 20 有効条件         */
 , SUPTRITSU NUMBER(3)         DEFAULT 10  NOT NULL      /* 21 得点比率         */
 , SUPOINT   NUMBER(3)         DEFAULT 0   NOT NULL      /* 22 得点             */
 , KAISETSU  VARCHAR2(4000)                              /* 23 解説             */
 , BIKO      VARCHAR2(4000)                              /* 24 備考             */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 25 ユニークキー     */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 26 状態フラグ       */
 , DYSET     VARCHAR2(14)                                /* 27 登録日時         */
 , PGSET     VARCHAR2(10)                                /* 28 作成PG           */
 , PGPSET    VARCHAR2(10)                                /* 29 作成親PG         */
 , USRSET    VARCHAR2(10)                                /* 30 作成社員         */
 , DYUPD     VARCHAR2(14)                                /* 31 更新日時         */
 , PGUPD     VARCHAR2(10)                                /* 32 更新PG           */
 , PGPUPD    VARCHAR2(10)                                /* 33 更新親PG         */
 , USRUPD    VARCHAR2(10)                                /* 34 更新者           */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN02S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN02T00 
BEFORE INSERT ON AN02
FOR EACH ROW 
BEGIN 
SELECT AN02S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

