/**************************************************************************/
/* AN01 ( アンケートマスタ )                                              */
/*                                                                        */
/* Created : 2010/10/08 09:29:32                                          */
/**************************************************************************/
CREATE TABLE AN01 (
   USERID     VARCHAR2(10)                               NOT NULL      /* 1  ユーザーID             */
 , CDANK      VARCHAR2(10)                               NOT NULL      /* 2  アンケートC            */
 , NMANK      VARCHAR2(500)                              NOT NULL      /* 3  アンケート名称         */
 , SMANK      VARCHAR2(4000)                                           /* 4  アンケート概要         */
 , DYKSTR     VARCHAR2(14)      DEFAULT '00000101000000' NOT NULL      /* 5  公開開始日             */
 , DYKEND     VARCHAR2(14)      DEFAULT '99991231000000' NOT NULL      /* 6  公開終了日             */
 , FGKOKAI    VARCHAR2(1)       DEFAULT '0'              NOT NULL      /* 7  公開方法               */
 , FGNODPL    VARCHAR2(1)       DEFAULT '0'              NOT NULL      /* 8  複数回答禁止           */
 , FGTEMPLATE VARCHAR2(1)       DEFAULT '0'              NOT NULL      /* 9  雛形                   */
 , KTSTAGS    VARCHAR2(4000)                                           /* 10 回答者タグ             */
 , IRAIADDRS  VARCHAR2(4000)                                           /* 11 回答依頼送信先         */
 , IRAIMLDT   VARCHAR2(14)                                             /* 12 回答依頼メール送信日時 */
 , BIKO       VARCHAR2(4000)                                           /* 13 備考                   */
 , CHECKKEY   VARCHAR2(200)                                            /* 14 チェックキー(暗号化前) */
 , CRYPTKEY   VARCHAR2(200)                                            /* 15 チェックキー(暗号化後) */
 , FGSHUBETSU VARCHAR2(1)       DEFAULT '1'              NOT NULL      /* 16 種別                   */
 , FGRESDISP  VARCHAR2(1)       DEFAULT '1'              NOT NULL      /* 17 結果表示               */
 , UNIQ       NUMBER(9)         DEFAULT 0                NOT NULL      /* 18 ユニークキー           */
 , FGJ        VARCHAR2(1)       DEFAULT '1'              NOT NULL      /* 19 状態フラグ             */
 , DYSET      VARCHAR2(14)                                             /* 20 登録日時               */
 , PGSET      VARCHAR2(10)                                             /* 21 作成PG                 */
 , PGPSET     VARCHAR2(10)                                             /* 22 作成親PG               */
 , USRSET     VARCHAR2(10)                                             /* 23 作成社員               */
 , DYUPD      VARCHAR2(14)                                             /* 24 更新日時               */
 , PGUPD      VARCHAR2(10)                                             /* 25 更新PG                 */
 , PGPUPD     VARCHAR2(10)                                             /* 26 更新親PG               */
 , USRUPD     VARCHAR2(10)                                             /* 27 更新者                 */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN01S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN01T00 
BEFORE INSERT ON AN01
FOR EACH ROW 
BEGIN 
SELECT AN01S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

