/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.Selection_DB;
import org.opengion.hayabusa.db.Selection_DBRADIO;

public final class SelectionFactory {
    private static final Map<String, Selection> dbMap = new WeakHashMap<String, Selection>(50);
    private static final Map<String, Selection> dbRadioMap = new WeakHashMap<String, Selection>(50);

    private SelectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selection newDBSelection(String string, String string2, String string3) {
        String string4 = string + string2 + string3;
        Selection selection = dbMap.get(string4);
        if (selection == null || selection.isTimeOver()) {
            Map<String, Selection> map = dbMap;
            synchronized (map) {
                selection = new Selection_DB(string, string2, string3);
                dbMap.put(string4, selection);
            }
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selection newDBRadioSelection(String string, String string2, String string3) {
        String string4 = string + string2 + string3;
        Selection selection = dbRadioMap.get(string4);
        if (selection == null || selection.isTimeOver()) {
            Map<String, Selection> map = dbRadioMap;
            synchronized (map) {
                selection = new Selection_DBRADIO(string, string2, string3);
                dbRadioMap.put(string4, selection);
            }
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Selection> map = dbMap;
        synchronized (map) {
            dbMap.clear();
        }
        map = dbRadioMap;
        synchronized (map) {
            dbRadioMap.clear();
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                SelectionFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

