/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * アンケートの各種マスタ(AN01,AN02,AN03)のデータの整合性をチェックするためのサブルーチンです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class AnkCheck extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		return must( "CDANK" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		String nmank =
			"select NMANK,FGSHUBETSU from AN01 A"
			+ " where A.USERID = '{@CON.USERID}'"
			+ " and A.CDANK = '{@CDANK}'"
			+ " and A.FGJ in ('0','1')";
		sql( nmank );

		// ANE0009:アンケート項目が設定されていません。アンケート名={0}
		String chk =
			"select count(*) CNT from AN02 A"
			+ " where A.USERID = '{@CON.USERID}'"
			+ " and A.CDANK = '{@CDANK}'"
			+ " and A.FGJ in ('0','1')";
		sql( chk );
		if( vari( "CNT" ) == 0 ) {
			error( 2, "ANE0009", "{@NMANK}" );
			return false;
		}

		// ANE0010:アンケート項目の中で、選択項目が定義されていない項目があります。アンケート名={0}、質問内容={1}
		chk =
			"select A.NAIYO from AN02 A"
			+ " where A.USERID = '{@CON.USERID}'"
			+ " and A.CDANK = '{@CDANK}'"
			+ " and A.KBUNRUI in ('RADIO','CHBOX','MENU')"
			+ " and A.FGJ in ('0','1')"
			+ " and not exists ("
			+ "  select 'x' from AN03 B"
			+ "  where B.USERID = A.USERID"
			+ "  and B.CDANK = A.CDANK"
			+ "  and B.CDSITSU = A.CDSITSU"
			+ "  and B.FGJ in ('0','1'))";
		sql( chk );
		if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
			error( 2, "ANE0010", "{@NMANK}","{@NAIYO}" );
			return false;
		}

		// ANE0012:その他フラグは、1質問に対して、1回答のみ設定することができます。アンケート名={0}
		chk =
			"select A.CDSITSU from AN03 A"
			+ " where A.USERID = '{@CON.USERID}'"
			+ " and A.CDANK = '{@CDANK}'"
			+ " and A.FGOTHER = '1'"
			+ " and A.FGJ in ('0','1')"
			+ " group by CDSITSU having count(*) > 1";
		sql( chk );
		if( var( "CDSITSU" ) != null && var( "CDSITSU" ).length() > 0 ) {
			error( 2, "ANE0012", "{@NMANK}" );
			return false;
		}

		if( "2".equals( var( "FGSHUBETSU" ) ) ) {
			// ANE0029:テストの場合、回答値分類は、「ラジオボタン(RADIO)」以外は設定することができません。アンケート名={0}、質問内容={1}
			chk
				= "select A.NAIYO from AN02 A"
				+ " where A.USERID = '{@CON.USERID}'"
				+ " and A.CDANK = '{@CDANK}'"
				+ " and A.KBUNRUI != 'RADIO'"
				+ " and A.FGJ in ('0','1')";
			sql( chk );
			if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
				error( 2, "ANE0029", "{@NMANK}","{@NAIYO}" );
				return false;
			}

			// ANE0030:正解の存在しない質問があります。アンケート名={0}、質問内容={1}
			chk =
				"select A.NAIYO from AN02 A"
				+ " where A.USERID = '{@CON.USERID}'"
				+ " and A.CDANK = '{@CDANK}'"
				+ " and A.FGJ in ('0','1')"
				+ " and not exists ("
				+ "  select 'x' from AN03 B"
				+ "  where B.USERID = A.USERID"
				+ "  and B.CDANK = A.CDANK"
				+ "  and B.CDSITSU = A.CDSITSU"
				+ "  and B.FGCORRECT = '1'"
				+ "  and B.FGJ in ('0','1'))";
			sql( chk );
			if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
				error( 2, "ANE0030", "{@NMANK}","{@NAIYO}" );
				return false;
			}

			// ANE0031:得点比率の設定されていない質問があります。アンケート名={0}、質問内容={1}
			chk
				= "select A.NAIYO from AN02 A"
				+ " where A.USERID = '{@CON.USERID}'"
				+ " and A.CDANK = '{@CDANK}'"
				+ " and A.SUPTRITSU <= 0"
				+ " and A.FGJ in ('0','1')";
			sql( chk );
			if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
				error( 2, "ANE0031", "{@NMANK}","{@NAIYO}" );
				return false;
			}

			// ANE0032:テストの場合、全ての質問は、回答必須でなければいけません。アンケート名={0}、質問内容={1}
			chk
				= "select A.NAIYO from AN02 A"
				+ " where A.USERID = '{@CON.USERID}'"
				+ " and A.CDANK = '{@CDANK}'"
				+ " and A.FGMUST = '0'"
				+ " and A.FGJ in ('0','1')";
			sql( chk );
			if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
				error( 2, "ANE0032", "{@NMANK}","{@NAIYO}" );
				return false;
			}

			// ANE0033:テストの場合、その他項目を定義することはできません。アンケート名={0}、質問内容={1}
			chk =
				"select A.NAIYO from AN02 A"
				+ " where A.USERID = '{@CON.USERID}'"
				+ " and A.CDANK = '{@CDANK}'"
				+ " and A.FGJ in ('0','1')"
				+ " and exists ("
				+ "  select 'x' from AN03 B"
				+ "  where B.USERID = A.USERID"
				+ "  and B.CDANK = A.CDANK"
				+ "  and B.CDSITSU = A.CDSITSU"
				+ "  and B.FGOTHER = '1'"
				+ "  and B.FGJ in ('0','1'))";
			sql( chk );
			if( var( "NAIYO" ) != null && var( "NAIYO" ).length() > 0 ) {
				error( 2, "ANE0033", "{@NMANK}","{@NAIYO}" );
				return false;
			}
		}

		return true;
	}
}

