/**************************************************************************/
/* AN02 ( アンケート項目マスタ )                                          */
/*                                                                        */
/* Created : 2010/09/27 16:41:31                                          */
/**************************************************************************/
CREATE TABLE AN02 (
   USERID    VARCHAR2(10)                  NOT NULL      /* 10  ユーザーID       */
 , CDANK     VARCHAR2(10)                  NOT NULL      /* 20  アンケートC      */
 , CDSITSU   VARCHAR2(10)                  NOT NULL      /* 30  質問C            */
 , SEQNO     NUMBER(7)         DEFAULT 0   NOT NULL      /* 40  表示順           */
 , NAIYO     VARCHAR2(4000)                NOT NULL      /* 50  質問内容         */
 , SITSUGRP  VARCHAR2(4000)                              /* 60  質問グループ     */
 , IMGNAI    VARCHAR2(200)                               /* 70  質問画像         */
 , IMGSNAI   VARCHAR2(10)                                /* 80  質問画像(拡張子) */
 , FGKEY     VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 90  キー項目F        */
 , FGMUST    VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 100 回答必須F        */
 , KBUNRUI   VARCHAR2(10)                  NOT NULL      /* 110 回答値分類       */
 , KLENGTH   NUMBER(9)         DEFAULT 10  NOT NULL      /* 120 回答値桁数       */
 , KNOTE     VARCHAR2(200)                               /* 130 回答注釈         */
 , SUONELINE NUMBER(9)         DEFAULT 1   NOT NULL      /* 140 1行選択肢数      */
 , RSCODE    VARCHAR2(20)                                /* 150 連携用質問C      */
 , INIVAL    VARCHAR2(50)                                /* 160 初期値           */
 , CSKEY     VARCHAR2(200)                               /* 170 抽出キー         */
 , CSWAY     VARCHAR2(10)                                /* 180 抽出方法         */
 , SUCS      NUMBER(9)         DEFAULT 0   NOT NULL      /* 190 抽出件数         */
 , VDCDTN    VARCHAR2(200)                               /* 200 有効条件         */
 , SUPTRITSU NUMBER(3)         DEFAULT 10  NOT NULL      /* 210 得点比率         */
 , SUPOINT   NUMBER(3)         DEFAULT 0   NOT NULL      /* 220 得点             */
 , KAISETSU  VARCHAR2(4000)                              /* 230 解説             */
 , BIKO      VARCHAR2(4000)                              /* 240 備考             */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 250 ユニークキー     */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 260 状態フラグ       */
 , DYSET     VARCHAR2(14)                                /* 270 登録日時         */
 , PGSET     VARCHAR2(10)                                /* 280 作成PG           */
 , PGPSET    VARCHAR2(10)                                /* 290 作成親PG         */
 , USRSET    VARCHAR2(10)                                /* 300 作成社員         */
 , DYUPD     VARCHAR2(14)                                /* 310 更新日時         */
 , PGUPD     VARCHAR2(10)                                /* 320 更新PG           */
 , PGPUPD    VARCHAR2(10)                                /* 330 更新親PG         */
 , USRUPD    VARCHAR2(10)                                /* 340 更新者           */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN02S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN02T00 
BEFORE INSERT ON AN02
FOR EACH ROW 
BEGIN 
SELECT AN02S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

