/***************************************************************************
 * 3.8.6.1 (2006/10/20)
 * POPUP画面起動用標準Function(TS より寄贈)
 * Modified: 2009/05/15 Extend to Firefox
 * Revision: $Id$
 ***************************************************************************/

/* ポップアップ画面から値を渡し、ウィンドウを閉じる(ogPopup と同時使用)	*/
/* <og:view ････ popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA" />				*/
function rtnPopup( rtnValue ) {
	window.returnValue = rtnValue;
	window.close();
}

/* TS POPUP画面起動用標準Function()									*/
/*	引数0：POPUP PGID												*/
/*	引数1：POPUP 高													*/
/*	引数2：POPUP 幅													*/
/*	引数3：入力の引数(1,2をｾｯﾄに複数可能)							*/
/*				1:key   ･･･ 呼出先画面のｶﾗﾑ名						*/
/*				2:value ･･･ 呼出元画面の値							*/
/*	引数4：this														*/
/*	引数5：出力の引数(KEY1,KEY2,・・)								*/
/*																	*/
/*	【例1】返り値が不要なケース										*/
/*		<og:popup gamenId="GEXXXX" href="popup.jsp"				*/
/*			keys="SYSTEM_ID,CLM,NAME_JA"							*/
/*			vals="{@SYS.SYSTEM_ID},CLM.value,NAME_JA.value" />		*/
/*																	*/
/*	【例2】返り値が通常のテキストフィールドのケース					*/
/*		<og:popup gamenId="GEXXXX" href="popup.jsp"				*/
/*			keys="SYSTEM_ID,CLM,NAME_JA"							*/
/*			vals="{@SYS.SYSTEM_ID},CLM.value,NAME_JA.value"			*/
/*			rtnKeys="SYSTEM_ID,CLM,NAME_JA" />						*/
/*																	*/
/*	【例3】一覧表示の行単位に値を設定するケース						*/
/*		<og:viewMarker command="{@command}" isRenderer="false">	*/
/*			<og:popup column="PUP" href="popup.jsp" 				*/
/*					keys="SYSTEM_ID,CLM,NAME_JA" 					*/
/*					vals="[SYSTEM_ID],[CLM].value,[NAME_JA].value"	*/
/*					rtnKeys="SYSTEM_ID,CLM,NAME_JA" />				*/
/*		</og:viewMarker>											*/

// 5.1.7.0 (2010/06/01) 引数にコマンドを追加
// function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,event ) {
function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,command,event ) {

	var height = 600 ;
	var width  = 900 ;

//	if( p_height != null && p_height.length() > 0 ) { height = p_height; }
//	if( p_width  != null && p_width.length()  > 0 ) { width  = p_width;  }
	if( p_height != null ) { height = p_height; }
	if( p_width  != null ) { width  = p_width;  }

	// ポップアップ画面定義
//	var url  =  p_pgid + "?command=NEW";
//	var url  =  p_pgid + "?command=" + command;
	var url  =  p_pgid + "?command=" + ( command ? command : "NEW" );
	var sTmp = 'dialogHeight:' + height + 'px;dialogWidth:' + width + 'px';
	if( event ) {
		sTmp = sTmp + ';dialogLeft:' + event.screenX + 'px;' + 'dialogTop:' + event.screenY + 'px';
	}

	// 入力引数の設定
	if( p_in_Array != null ) {
		for( i=0; i<p_in_Array.length; i+=2 ) {
//			url = url + "&" + p_in_Array[i] + "=" + EscapeUTF8(p_in_Array[i+1]);
			url = url + "&" + p_in_Array[i] + "=" + encodeURIComponent( p_in_Array[i+1]);  // 5.2.0.0 (2010/09/01)
		}
	}

	// ポップアップ画面
	var param = "";
	if( ( p_out_Array != null ) && ( document.getElementById( p_out_Array[0] ) ) ){
		param = document.getElementById( p_out_Array[0] ).value;
	}
	var	ret_val = showModalDialog( url,param,sTmp );
	// 4.1.1.2 2008/03/11 既存仕様に合わせるため、戻り値が文字列の場合は、配列に変換
	//if( ( ret_val != null ) && ( ret_val[0] == null ) ){
	if( ( ret_val != null ) && ( typeof ret_val !== "object" ) ){
		ret_val = new Array( ret_val );
	}

	// 出力引数に、ポップアップからの戻り値を設定
	if( ret_val != null && p_out_Array != null ) {
		var	tmp;
		for( j=0; ( j<p_out_Array.length && j<ret_val.length ) ; j++ ) {
			if( p_out_Array[j] != '' ) {
//				tmp = eval( 'document.' + p_this.form +'.' + p_out_Array[j]);
				tmp = p_this.form.elements[p_out_Array[j]];
				if( tmp != null ) {
					var _oldTmpVal = tmp.value;
					tmp.value = ret_val[j];
					// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
					if( _oldTmpVal != ret_val[j] ){
						$(tmp).change();
					}
				}
			}
		}
	}
}

// http://nurucom-archives.hp.infoseek.co.jp/digital/ecl.js.txt
//EscapeUTF8=function(str){
//	return str.replace(/[^*+.-9A-Z_a-z-]/g,function(s){
//		var c=s.charCodeAt(0);
//		return (c<16?"%0"+c.toString(16):c<128?"%"+c.toString(16):c<2048?"%"+(c>>6|192).toString(16)+"%"+(c&63|128).toString(16):"%"+(c>>12|224).toString(16)+"%"+(c>>6&63|128).toString(16)+"%"+(c&63|128).toString(16)).toUpperCase()
//	})
//};

/*
 * 4.0.1.0 (2007/12/12) Window opens.
 *
 * default.js#window_open( url,evt,name,opt ) の代替処理
 * The event is received, and new window is opened at the clicked position.
 *
 * ogOpen( url,evt,name,opt )
 *   url  : Opening URL is specified.
 *   evt  : When the number of cases is a little, height is adjusted, and the scroll bar is displayed.
 *   name : It is a name when the value is returned.
 *   opt  : It is an option for the opening of window.
 *
 *  The following examples are samples of the calendar assistance menu.
 *
 *  TEST1:<input type="text" name="TEST1"  id="TEST1"  size="10" maxlength="8" value="20040201" />
 *  <img src="calendar.gif" onclick="ogOpen('../common/calendar.html', event,'TEST1','width=220,height=170,resizable=no' );" />
 *
 */
function ogOpen( url,evt,name,opt ){
	var option = opt;
	if( evt != null ) {
		var move = 'left=' + evt.x + ',top=' + evt.y ;
		if( option != null ) {
			option += ',' + move ;
		}
	}

	window.open( url, name, option );
}
