<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query">
	<script type="text/javascript" src="op1003.js" ><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/query_info.jsp" />

<!-- キーのチェック・復号化 -->
<og:bizLogic logics="an.OP0001S" keys="KEY" />
<og:value command="SET" key="CDANK" value="{@RETURN}" />

<og:value command="SQL">
	select A.USERID,A.FGKOKAI,A.DYKSTR,A.DYKEND,A.FGNODPL
	from AN01 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
</og:value>

<!-- ANE0001:このアンケートは公開されていません。-->
<og:dataCheck command="NEW" msg="ANE0001" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@FGKOKAI}' != '0'
</og:dataCheck>

<og:equals val1="3" val2="{@FGKOKAI}">
	<!-- 回答者IDのチェック -->
	<og:bizLogic logics="an.OP0002S" keys="CDANK,UID" />
	<og:value command="SET" key="KUID" value="{@RETURN}" />
</og:equals>

<!-- ANE0003:このアンケートはまだ開始していません。-->
<og:dataCheck command="NEW" msg="ANE0003" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@USER.YMD}' &gt;= '{@DYKSTR}'
</og:dataCheck>

<!-- ANE0004:このアンケートは既に終了しています。-->
<og:dataCheck command="NEW" msg="ANE0004" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@USER.YMD}' &lt;= '{@DYKEND}'
</og:dataCheck>

<og:value command="SQL">
	select count(*) CNT
	from AN11 A
	where A.USERID = '{@USERID}'
	and A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	<og:equals val1="{@FGKOKAI}" val2="3">
	and A.KUID = '{@KUID}'
	</og:equals>
	<og:equals val1="{@FGKOKAI}" val2="3" notEquals="true">
	and A.KIPADDR = '{@USER.IPADDRESS}'
	</og:equals>
</og:value>

<og:equals val1="{@FGNODPL}" val2="1">
	<!-- ANE0006:このアンケートには既に回答済みです。-->
	<og:dataCheck command="NEW" msg="ANE0006"
		beforeErrorJsp="/jsp/common/history_back.jsp"
		afterErrorJsp="thanks.jsp">
		{@CNT} == 0
	</og:dataCheck>
</og:equals>

<og:equals val1="{@CNT}" val2="0" notEquals="true">
	<div style="padding:10px;">
		<!-- ANM0009:【アンケートの集計結果を見る】-->
		<og:link href="index.jsp" gamenId="OP1101" lbl="ANM0009" keys="KEY,UVIEW" vals="{@KEY},true" />
	</div>
</og:equals>

<div style="padding:10px;display:none;" id="confirm">
	<!-- ANM0022:以下の内容で送信します。よろしければ、最下部の送信ボタンを押して下さい。-->
	<og:text><b>{@LBL.ANM0022}</b></og:text>
	<br /><br />
	<!-- ANM0026:入力内容に誤りがある場合は、内容を変更し、送信ボタンを押して下さい。 -->
	<og:text><b>{@LBL.ANM0026}</b></og:text>
	<br /><br />
	<!-- ANM0027:※確認ボタンを押すと、再度、入力内容の確認を行うことができます。-->
	<og:text><b>{@LBL.ANM0027}</b></og:text>
</div>

<form method="POST" action="forward.jsp">

<jsp:directive.include file="ank_VIEW.jsp" />

<div style="margin:5px;">
	<og:submit value="entry" lbl="SEND" accesskey="S" optionAttributes="id='sendBtn' style='display:none;'" />
	<og:submit value="entry" lbl="CONFIRM" accesskey="C" onClick="return myConfirm();" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<og:hidden name="KEY" value="{@KEY}" />
	<og:hidden name="KUID" value="{@KUID}" />
</div>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
