<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select case
					when A.FGKOKAI = '0'
						then '0'
					when A.FGKOKAI != '0' and '{@USER.YMD}' &lt; A.DYKSTR
						then '1'
					when A.FGKOKAI != '0' and '{@USER.YMD}' between A.DYKSTR and A.DYKEND
						then '2'
					when A.FGKOKAI != '0' and '{@USER.YMD}' &gt; A.DYKEND
						then '3'
				end ANKJYOKYO
				,A.CDANK,A.NMANK
				,A.SMANK
				,0 KCNT,'0' KLINK
				,A.FGKOKAI,A.DYKSTR,A.DYKEND
				,A.KTSTAGS,A.IRAIADDRS,A.IRAIMLDT,A.FGNODPL
				,A.BIKO,A.CRYPTKEY,'{@SYS.CONTEXT_URL}jsp/index.jsp?k='||A.CRYPTKEY ANKURL
				,A.CHECKKEY,A.FGJ,A.DYSET,A.DYUPD,A.UNIQ,A.USERID
		from AN01 A
		where A.USERID = '{@USER.ID}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.NMANK		like	'%{@NMANK}%'" />
		<og:and value = "A.FGKOKAI		=		'{@FGKOKAI}'" />
		<og:and value = "A.DYKSTR		&gt;=	'{@DYKSTR}'" />
		<og:and value = "A.DYKEND		&lt;=	'{@DYKEND}'" />
		<og:and value = "A.CRYPTKEY		=		'{@CRYPTKEY}'" />
		<og:and value = "( '{@ISNOTEND}'='0' OR ('{@ISNOTEND}'='1' and '{@USER.YMD}' &lt;= A.DYKEND ) )" />
		<og:and value = "A.FGJ			=		'{@FGJ}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DYKEND,A.UNIQ" />
</og:query>

<og:tableFilter classId="DBSELECT" selectedAll="true">
	select count(*) KCNT, case when count(*) > 0 then '1' else '0' end KLINK
	from AN11 A
	where A.USERID = [USERID]
	and A.CDANK = [CDANK]
	and A.FGJ = '1'
</og:tableFilter>

<og:columnEditor columns="NMANK,FGKOKAI,DYKSTR,DYKEND,FGNODPL" must="true" />
<og:columnEditor column="CRYPTKEY" label="ANKCODE" />

<og:viewLink command="{@command}">
	<og:link column="NMANK" gamenId="AN0008" href="index.jsp" target="_top"
		keys="command,KEY" vals="NEW,[CRYPTKEY]" />
	<og:link column="KCNT" gamenId="AN0101" href="index.jsp" target="_top" onLink="[KLINK]"
		keys="command,KEY" vals="NEW,[CRYPTKEY]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="ANKKOKAI"  command="MODIFY" accesskey="K"
		keys="KOKAI,columnWritable" vals='true,"FGKOKAI,DYKSTR,DYKEND"' optionAttributes="style='background-color:orange;'" />
	<og:submit  value="index"  gamenId="AN0007" lbl="KIRAI"  command="NEW" accesskey="I" target="_top"
		dbkeys="CRYPTKEY,KTSTAGS" optionAttributes="style='background-color:orange;'" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="columnWritable" vals='"NMANK,SMANK,DYKSTR,DYKEND,FGNODPL,KTSTAGS,IRAIADDRS,BIKO"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable" vals="null" />
	&amp;nbsp;
	<og:link href="index.jsp" gamenId="AN0001" target="_top" keys="command" vals="NEW"  />
	&amp;nbsp;
	<og:link href="index.jsp" gamenId="AN0006" target="_top" keys="command,FGJ" vals="NEW,1" />
<br />
</og:writeCheck>

<og:equals val1="{@MEM.DISPALL}" val2="1" notEquals="true">
	<og:value command="SET" key="NO_DISP" value=",SMANK,KTSTAGS,IRAIADDRS,IRAIMLDT,FGNODPL,DYSET" />
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "CDANK,CHECKKEY,UNIQ,USERID,KLINK{@NO_DISP}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
