/**************************************************************************/
/* AN03 ( アンケート項目詳細マスタ )                                      */
/*                                                                        */
/* Created : 2010/09/07 19:49:17                                          */
/**************************************************************************/
CREATE TABLE AN03 (
   USERID   VARCHAR2(10)                  NOT NULL      /* 1  ユーザーID         */
 , CDANK    VARCHAR2(10)                  NOT NULL      /* 2  アンケートC        */
 , CDSITSU  VARCHAR2(10)                  NOT NULL      /* 3  質問C              */
 , KVAL     VARCHAR2(4000)                NOT NULL      /* 4  回答値             */
 , SEQNO    NUMBER(7)         DEFAULT 0   NOT NULL      /* 5  表示順             */
 , KNAME    VARCHAR2(4000)                NOT NULL      /* 6  回答名称           */
 , IMGKVAL  VARCHAR2(200)                               /* 7  回答値画像         */
 , IMGSKVAL VARCHAR2(10)                                /* 8  回答値画像(拡張子) */
 , FGOTHER  VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 9  その他F            */
 , RKCODE   VARCHAR2(20)                                /* 10 連携用回答C        */
 , BIKO     VARCHAR2(4000)                              /* 11 備考               */
 , UNIQ     NUMBER(9)         DEFAULT 0   NOT NULL      /* 12 ユニークキー       */
 , FGJ      VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 13 状態フラグ         */
 , DYSET    VARCHAR2(14)                                /* 14 登録日時           */
 , PGSET    VARCHAR2(10)                                /* 15 作成PG             */
 , PGPSET   VARCHAR2(10)                                /* 16 作成親PG           */
 , USRSET   VARCHAR2(10)                                /* 17 作成社員           */
 , DYUPD    VARCHAR2(14)                                /* 18 更新日時           */
 , PGUPD    VARCHAR2(10)                                /* 19 更新PG             */
 , PGPUPD   VARCHAR2(10)                                /* 20 更新親PG           */
 , USRUPD   VARCHAR2(10)                                /* 21 更新者             */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN03S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN03T00 
BEFORE INSERT ON AN03
FOR EACH ROW 
BEGIN 
SELECT AN03S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

