/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import java.io.IOException;
import org.opengion.fukurou.util.CSVTokenizer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.io.AbstractTableReader;
import org.opengion.hayabusa.resource.ResourceManager;

public class TableReader_Default
extends AbstractTableReader {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final String CR = System.getProperty("line.separator");
    private String separator = "\t";
    private ResourceManager resource = null;
    private int maxRowCount = HybsSystem.sysInt((String)"DB_MAX_ROW_COUNT");
    protected DBTableModel table = null;
    protected DBColumn[] dbColumn = null;
    protected String columns = null;
    private String encode = null;
    private boolean useNumber = true;
    private int skipRowCount = 0;

    public void readDBTable() {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void readDBTable(BufferedReader bufferedReader) {
        try {
            String string;
            String[] stringArray = null;
            int n = 0;
            char c = this.separator.charAt(0);
            boolean bl = true;
            this.table = DBTableModelUtil.newDBTable();
            if (this.columns != null && this.columns.length() > 0) {
                stringArray = StringUtil.csv2Array((String)this.columns);
                this.table.init(stringArray.length);
                this.setTableDBColumn(stringArray);
                bl = false;
            }
            int n2 = this.skipRowCount;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                int n3 = StringUtil.countChar((String)string, (char)'\"');
                if (n3 % 2 == 1) {
                    string2 = null;
                    while (n3 % 2 == 1 && (string2 = bufferedReader.readLine()) != null) {
                        string = string + CR + string2;
                        n3 += StringUtil.countChar((String)string2, (char)'\"');
                    }
                }
                if (n2 > 0) {
                    --n2;
                    continue;
                }
                if (string.length() == 0) continue;
                if (string.charAt(0) == '#') {
                    string2 = string.substring(0, 5);
                    if (!bl || !string2.equalsIgnoreCase("#NAME")) continue;
                    String string3 = string.substring(string.indexOf(c) + 1);
                    stringArray = StringUtil.csv2Array((String)string3, (char)c);
                    this.table.init(stringArray.length);
                    this.setTableDBColumn(stringArray);
                    bl = false;
                    continue;
                }
                if (bl) {
                    string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
                    throw new HybsSystemException(string2);
                }
                if (n < this.getMaxRowCount()) {
                    this.table.addColumnValues(this.readData(string, stringArray.length));
                    ++n;
                    continue;
                }
                this.table.setOverflow(true);
            }
            if (bl) {
                String string4 = "\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u6709\u52b9\u306a\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                throw new HybsSystemException(string4);
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + bufferedReader + "]";
            throw new HybsSystemException(string, (Throwable)iOException);
        }
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    protected void setTableDBColumn(String[] stringArray) {
        this.dbColumn = new DBColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DBColumn dBColumn = this.resource.makeDBColumn(stringArray[i]);
            this.table.setDBColumn(i, dBColumn);
            this.dbColumn[i] = dBColumn;
        }
    }

    protected String[] readData(String string, int n) {
        String[] stringArray = new String[n];
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, this.separator.charAt(0));
        if (this.useNumber) {
            cSVTokenizer.nextToken();
        }
        int n2 = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            String string2 = StringUtil.csvOutQuote((String)cSVTokenizer.nextToken());
            stringArray[n2++] = string2 != null && string2.startsWith("'0") ? StringUtil.rTrim((String)string2.substring(1)) : StringUtil.rTrim((String)string2);
            if (n2 < n) continue;
            break;
        }
        for (int i = n2; i < n; ++i) {
            stringArray[i] = "";
        }
        return stringArray;
    }

    public DBTableModel getDBTableModel() {
        return this.table;
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    public void setSheetName(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public boolean isExcel() {
        return false;
    }

    public void setFilename(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public void setColumns(String string) {
        this.columns = string;
    }

    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }
}

