/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import java.io.File;

import org.opengion.fukurou.business.BizLogic_ENTRY;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ZipFileUtil;
import org.opengion.hayabusa.common.HybsSystem;

/**
 * 質問の画像をZIP形式でまとめて圧縮します。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class AN0005S extends BizLogic_ENTRY {

	private final static String imgPath = HybsSystem.sys( "REAL_PATH" ) + "ankimages" + File.separator;

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		return must( "CDANK,QAIMAGE_ORIG" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		String arcFile = HybsSystem.sys( "REAL_PATH" ) + HybsSystem.sys( "FILE_URL" )
							+ var( "CON.USERID" ) + File.separator + "images.zip";

		String[] imagesOrig = StringUtil.csv2Array( var( "QAIMAGE_ORIG" ) );
		for( String imageOrig : imagesOrig ) {
			if( imageOrig != null && imageOrig.length() > 0 ) {
				if( !new File( imgPath + imageOrig ).exists() ) {
					error( 2, "ANE0017", imageOrig );
				}
			}
		}

		ZipFileUtil.compress( imgPath + "template" + File.separator + var( "CDANK" ), arcFile );

		return true;
	}
}

