<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />

<!-- キーのチェック・復号化 -->
<og:bizLogic logics="an.OP0001S" keys="KEY" />
<og:value command="SET" key="CDANK" value="{@RETURN}" />

<og:query command="{@command}" displayMsg="">
	select 'Q' QAKBN,A.NAIYO QANAIYO,A.KBUNRUI
			,case when A.IMGNAI is not null and A.IMGNAI != coalesce('',' ') then A.CDSITSU||'.'||A.IMGSNAI end QAIMAGE
			,A.IMGNAI QAIMAGE_ORIG,A.KNOTE,A.SEQNO * 1000000 SEQNO
	from AN02 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	union all
	select 'A' QAKBN,A.KNAME QANAIYO,'' KBUNRUI
			,case when A.IMGKVAL is not null and A.IMGKVAL != coalesce('',' ') then A.KVAL||'.'||A.IMGSKVAL end QAIMAGE
			,A.IMGKVAL QAIMAGE_ORIG,'' KNOTE,B.SEQNO * 1000000 + A.SEQNO SEQNO
	from AN03 A inner join AN02 B
	on A.CDANK = B.CDANK
	and A.CDSITSU = B.CDSITSU
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	order by SEQNO
</og:query>

<og:equals val1="{@IMAGE}" nullCheck="true">
	<og:writeTable
		writerClass	= "Calc"
		fileURL		= "{@USER.ID}"
		filename	= "def.ods"
		columns		= "QAKBN,QANAIYO,KBUNRUI,QAIMAGE,KNOTE"
	/>

	<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/def.ods" filename="def.ods" />
</og:equals>

<og:equals val1="{@IMAGE}" nullCheck="true" notEquals="true">
	<og:value command="SETTBL" action="ALL_APPEND" key="QAIMAGE_ORIG" />
	<og:bizLogic logics="an.AN0005S" keys="CDANK,QAIMAGE_ORIG" />
	<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/images.zip" filename="images.zip" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
