<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.CDANK,A.CDSITSU,A.KVAL,A.SEQNO,A.KNAME,A.IMGKVAL,A.FGOTHER,A.BIKO,A.FGJ,A.DYSET,A.DYUPD,A.UNIQ
				,case when A.IMGKVAL is null or A.IMGKVAL = '' then '0' else '1' end FGIMG
		from AN03 A left outer join AN02 B
		on A.USERID = B.USERID
		and A.CDANK = B.CDANK
		and A.CDSITSU = B.CDSITSU
		and '1' = B.FGJ
		where A.USERID = '{@USER.ID}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.CDANK		=		'{@CDANK}'" />
		<og:and value = "A.CDSITSU		=		'{@CDSITSU}'" />
		<og:and value = "A.KNAME		like	'{@KNAME}%'" />
		<og:and value = "A.FGJ			=		'{@FGJ}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "B.SEQNO,A.SEQNO" />
</og:query>

<og:columnEditor columns="CDSITSU,SEQNO,KNAME" must="true" />
<og:columnEditor columns="CDSITSU" label="NAIYO" />

<og:viewMarker command="{@command}">
	<og:columnMarker column="IMGKVAL" onMark="[FGIMG]" markList="1" >
		<a href="{@SYS.CONTEXT_URL}ankimages/[IMGKVAL]" target="IMAGE">
			<img src="{@SYS.CONTEXT_URL}ankimages/[IMGKVAL]" width="50px" height="50px" />
		</a>
		<og:equals val1="{@FGKOKAI}" val2="0">
			<a href="{@SYS.JSP}/customan/filePopup.jsp?BASE_DIR=ankimages&amp;NEWPATH=[CDANK]/[CDSITSU]&amp;NEWNAME=[CDANK]/[CDSITSU]/[KVAL]&amp;TBLNAME=AN03&amp;CLMNAME=IMGKVAL&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">Upload</a>
		</og:equals>
	</og:columnMarker>
	<og:columnMarker column="IMGKVAL" onMark="[FGIMG]" markList="0" >
		<og:equals val1="{@FGKOKAI}" val2="0">
			<a href="{@SYS.JSP}/customan/filePopup.jsp?BASE_DIR=ankimages&amp;NEWPATH=[CDANK]/[CDSITSU]&amp;NEWNAME=[CDANK]/[CDSITSU]/[KVAL]&amp;TBLNAME=AN03&amp;CLMNAME=IMGKVAL&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">Upload</a>
		</og:equals>
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals='"CDANK,KVAL,IMGKVAL,FGJ,DYSET,DYUPD"' />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"CDANK,CDSITSU,KVAL,IMGKVAL,FGJ,DYSET,DYUPD"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable" vals="null" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "CDANK,KVAL,UNIQ"
	columnGroup	= "CDSITSU"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
