<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select case
					when A.FGKOKAI = '0'
						then '0'
					when A.FGKOKAI != '0' and '{@USER.YMDH}' &lt; A.DYKSTR
						then '1'
					when A.FGKOKAI != '0' and '{@USER.YMDH}' between A.DYKSTR and A.DYKEND
						then '2'
					when A.FGKOKAI != '0' and '{@USER.YMDH}' &gt; A.DYKEND
						then '3'
				end ANKJYOKYO
				,A.CDANK,A.NMANK
				,0 KCNT,'0' KLINK
				,case when A.FGKOKAI = '0' then '' else '*' end ANKVIEW
				,A.FGKOKAI,A.DYKSTR,A.DYKEND
				,'*' ANKCONF,'*' QALISTOUT,'' IMAGESOUT
				,A.BIKO,A.CRYPTKEY,'{@SYS.CONTEXT_URL}jsp/index.jsp?k='||A.CRYPTKEY ANKURL
				,A.CHECKKEY,A.FGJ,A.DYSET,A.DYUPD,A.UNIQ,A.USERID
		from AN01 A
		where A.USERID = '{@USER.ID}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.NMANK		like	'%{@NMANK}%'" />
		<og:and value = "A.FGKOKAI		=		'{@FGKOKAI}'" />
		<og:and value = "A.DYKSTR		&gt;=	'{@DYKSTR}'" />
		<og:and value = "A.DYKEND		&lt;=	'{@DYKEND}'" />
		<og:and value = "( '{@ISNOTEND}'='0' OR ('{@ISNOTEND}'='1' and '{@USER.YMDH}' &lt;= A.DYKEND ) )" />
		<og:and value = "A.FGJ			=		'{@FGJ}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DYKEND,A.UNIQ" />
</og:query>

<og:tableFilter classId="DBSELECT" selectedAll="true">
	select count(*) KCNT, case when count(*) > 0 then '1' else '0' end KLINK
	from AN11 A
	where A.USERID = [USERID]
	and A.CDANK = [CDANK]
	and A.FGJ = '1'
</og:tableFilter>

<og:tableFilter classId="DBSELECT" selectedAll="true">
	select '*' IMAGESOUT
	from AN02 A
	where A.CDANK = [CDANK]
	and A.IMGNAI is not null and A.IMGNAI != coalesce('',' ')
	and A.FGJ = '1'
</og:tableFilter>

<og:tableFilter classId="DBSELECT" selectedAll="true">
	select '*' IMAGESOUT
	from AN03 A
	where A.CDANK = [CDANK]
	and A.IMGKVAL is not null and A.IMGKVAL != coalesce('',' ')
	and A.FGJ = '1'
</og:tableFilter>

<og:columnEditor columns="NMANK,FGKOKAI,DYKSTR,DYKEND" must="true" />
<og:columnEditor column="CRYPTKEY" label="ANKCODE" />

<og:viewLink command="{@command}">
	<og:link column="NMANK" gamenId="AN0003" href="preview.jsp" target="_top"
		keys="command,KEY" vals="NEW,[CRYPTKEY]" />
	<og:link column="ANKCONF" gamenId="AN0003" href="index.jsp" target="_top"
		keys="command,CDANK,FGJ" vals="NEW,[CDANK],1" />
	<og:link column="ANKVIEW" gamenId="AN0101" href="index.jsp" target="_top" onLink="[KLINK]"
		keys="command,KEY" vals="NEW,[CRYPTKEY]" />
	<og:link column="QALISTOUT" gamenId="AN0005" href="fileout.jsp" target="_top"
		keys="command,KEY" vals="NEW,[CRYPTKEY]" />
	<og:link column="IMAGESOUT" gamenId="AN0005" href="fileout.jsp" target="_top"
		keys="command,KEY,IMAGE" vals="NEW,[CRYPTKEY],true" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="ANKKOKAI"  command="MODIFY" accesskey="K"
		keys="KOKAI,columnWritable" vals='true,"FGKOKAI,DYKSTR,DYKEND"' optionAttributes="style='background-color:orange;'" />
	<og:submit  value="index" gamenId="AN0001" lbl="COPY" accesskey="C"
		keys="command" vals="NEW" dbkeys="NMANK" target="_top" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="columnWritable" vals='"NMANK,DYKSTR,DYKEND"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable" vals="null" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "CDANK,CHECKKEY,UNIQ,USERID,KLINK"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
