/**************************************************************************/
/* AN12 ( アンケート回答明細 )                                            */
/*                                                                        */
/* Created : 2010/08/02 19:03:06                                          */
/**************************************************************************/
CREATE TABLE AN12 (
   NOKAITO  VARCHAR2(10)                  NOT NULL      /* 10  回答番号     */
 , NOMEISAI NUMBER(9)         DEFAULT 0   NOT NULL      /* 20  回答明細番号 */
 , USERID   VARCHAR2(10)                  NOT NULL      /* 30  ユーザーID   */
 , CDANK    VARCHAR2(10)                  NOT NULL      /* 40  アンケートC  */
 , CDSITSU  VARCHAR2(10)                  NOT NULL      /* 50  質問C        */
 , KVAL     VARCHAR2(4000)                NOT NULL      /* 60  回答値       */
 , KNAME    VARCHAR2(4000)                              /* 70  回答名称     */
 , FGOTHER  VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 80  その他F      */
 , UNIQ     NUMBER(9)         DEFAULT 0   NOT NULL      /* 90  ユニークキー */
 , FGJ      VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 状態フラグ   */
 , DYSET    VARCHAR2(14)                                /* 110 登録日時     */
 , PGSET    VARCHAR2(10)                                /* 120 作成PG       */
 , PGPSET   VARCHAR2(10)                                /* 130 作成親PG     */
 , USRSET   VARCHAR2(10)                                /* 140 作成社員     */
 , DYUPD    VARCHAR2(14)                                /* 150 更新日時     */
 , PGUPD    VARCHAR2(10)                                /* 160 更新PG       */
 , PGPUPD   VARCHAR2(10)                                /* 170 更新親PG     */
 , USRUPD   VARCHAR2(10)                                /* 180 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN12S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN12T00 
BEFORE INSERT ON AN12
FOR EACH ROW 
BEGIN 
SELECT AN12S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

