/**************************************************************************/
/* AN02 ( アンケート項目マスタ )                                          */
/*                                                                        */
/* Created : 2010/08/02 19:03:06                                          */
/**************************************************************************/
CREATE TABLE AN02 (
   USERID    VARCHAR2(10)                     NOT NULL      /* 10  ユーザーID       */
 , CDANK     VARCHAR2(10)                     NOT NULL      /* 20  アンケートC      */
 , CDSITSU   VARCHAR2(10)                     NOT NULL      /* 30  質問C            */
 , SEQNO     NUMBER(7)         DEFAULT 0      NOT NULL      /* 40  表示順           */
 , NAIYO     VARCHAR2(4000)                   NOT NULL      /* 50  質問内容         */
 , IMGNAI    VARCHAR2(200)                                  /* 60  質問画像         */
 , IMGSNAI   VARCHAR2(10)                                   /* 70  質問画像(拡張子) */
 , FGKEY     VARCHAR2(1)       DEFAULT '0'    NOT NULL      /* 80  キー項目F        */
 , FGMUST    VARCHAR2(1)       DEFAULT '0'    NOT NULL      /* 90  回答必須F        */
 , KBUNRUI   VARCHAR2(10)      DEFAULT 'TEXT' NOT NULL      /* 100 回答値分類       */
 , KLENGTH   NUMBER(9)         DEFAULT 10     NOT NULL      /* 110 回答値桁数       */
 , KNOTE     VARCHAR2(200)                                  /* 120 回答注釈         */
 , SUONELINE NUMBER(9)         DEFAULT 1      NOT NULL      /* 130 1行選択肢数      */
 , BIKO      VARCHAR2(4000)                                 /* 140 備考             */
 , UNIQ      NUMBER(9)         DEFAULT 0      NOT NULL      /* 150 ユニークキー     */
 , FGJ       VARCHAR2(1)       DEFAULT '1'    NOT NULL      /* 160 状態フラグ       */
 , DYSET     VARCHAR2(14)                                   /* 170 登録日時         */
 , PGSET     VARCHAR2(10)                                   /* 180 作成PG           */
 , PGPSET    VARCHAR2(10)                                   /* 190 作成親PG         */
 , USRSET    VARCHAR2(10)                                   /* 200 作成社員         */
 , DYUPD     VARCHAR2(14)                                   /* 210 更新日時         */
 , PGUPD     VARCHAR2(10)                                   /* 220 更新PG           */
 , PGPUPD    VARCHAR2(10)                                   /* 230 更新親PG         */
 , USRUPD    VARCHAR2(10)                                   /* 240 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN02S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN02T00 
BEFORE INSERT ON AN02
FOR EACH ROW 
BEGIN 
SELECT AN02S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

