/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.text.TextBlock;
import org.jfree.ui.RectangleEdge;

public class HybsCategoryAxis
extends CategoryAxis {
    private static final long serialVersionUID = 4110L;
    private static final TextBlock NULL_LABEL = new TextBlock();
    private int skip = 1;
    private int count = 0;
    private transient List<LabelVisible> labelBreak = null;
    private int cutNo = -1;
    private String breakKey = null;
    private boolean isItemLabelLastVisible = false;
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();

    public HybsCategoryAxis(String string) {
        this(string, 1, -1);
    }

    protected HybsCategoryAxis(String string, int n, int n2) {
        super(string);
        this.skip = n;
        this.cutNo = n2;
    }

    protected void setItemLabelLastVisible(boolean bl) {
        this.isItemLabelLastVisible = bl;
    }

    public List<?> refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        this.count = 0;
        this.labelBreak = new ArrayList<LabelVisible>();
        return super.refreshTicks(graphics2D, axisState, rectangle2D, rectangleEdge);
    }

    protected TextBlock createLabel(Comparable comparable, float f, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = null;
        String string = null;
        if (comparable instanceof String && (string = (String)((Object)comparable)).startsWith("_")) {
            textBlock = NULL_LABEL;
        }
        if (this.cutNo > 0 && string != null) {
            if (string.length() >= this.cutNo) {
                string = string.substring(0, this.cutNo);
            }
            if (!string.equals(this.breakKey)) {
                textBlock = super.createLabel((Comparable)((Object)string), f, rectangleEdge, graphics2D);
                this.breakKey = string;
            }
        } else {
            if (this.count % this.skip == 0) {
                textBlock = super.createLabel(comparable, f, rectangleEdge, graphics2D);
            }
            ++this.count;
        }
        if (textBlock == null) {
            textBlock = NULL_LABEL;
            this.labelBreak.add(LabelVisible.FALSE);
        } else if (textBlock.equals((Object)NULL_LABEL)) {
            this.labelBreak.add(LabelVisible.UNDER);
        } else {
            this.labelBreak.add(LabelVisible.TRUE);
        }
        return textBlock;
    }

    protected boolean isLabelBreak(int n) {
        return this.labelBreak == null || this.labelBreak.size() <= n || this.labelBreak.get(n).booleanValue();
    }

    protected boolean isViewItemLabel(int n) {
        boolean bl;
        boolean bl2 = bl = this.labelBreak == null || this.labelBreak.size() <= n || this.labelBreak.get(n) != LabelVisible.UNDER;
        if (bl && this.isItemLabelLastVisible && this.labelBreak.size() - 1 != n) {
            bl = false;
        }
        return bl;
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = this.isLabelBreak(n) ? super.getCategoryJava2DCoordinate(categoryAnchor, n, n2, rectangle2D, rectangleEdge) : 0.0;
        return d;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this.hsCode == ((HybsCategoryAxis)((Object)object)).hsCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hsCode;
    }

    private static enum LabelVisible {
        TRUE(true),
        FALSE(false),
        UNDER(true);

        private final boolean flag;

        private LabelVisible(boolean bl) {
            this.flag = bl;
        }

        public boolean booleanValue() {
            return this.flag;
        }
    }
}

