﻿/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.resource.ResourceFactory;

/**
 * カラムリソースの追加・更新を行うための共通サブルーチンです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class ColumnRes extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		if( "X".equals( var( "CDKH" ) ) ) {
			return must( "CDANK,CDKH" );
		}
		else {
			return must( "CDANK,CDSITSU,NAIYO,KBUNRUI,KLENGTH,CDKH" );
		}
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		if( "A".equals( var( "CDKH" ) ) ) {
			set( "CLM", "AN_" + var( "CDANK" ) + "_" + var( "CDSITSU" ) );
			insupdGEA03();
			insupdGEA08();
		}
		else if( "D".equals( var( "CDKH" ) ) ) {
			set( "CLM", "AN_" + var( "CDANK" ) + "_" + var( "CDSITSU" ) );
			delete();
		}
		else if( "X".equals( var( "CDKH" ) ) ) {
			allDelete();
		}

		return true;
	}

	/**
	 * カラムリソースの追加・更新を行います。
	 */
	private void insupdGEA03() {
		set( "USE_LENGTH", StringUtil.valueOf( Utils.getLength( var( "KBUNRUI" ), vari( "KLENGTH" ) ) ) );
		set( "CLS_NAME", Utils.getDbcls( var( "KBUNRUI" ) ) );
		set( "RENDERER", Utils.getRenderer( var( "KBUNRUI" ) ) );
		set( "EDITOR", Utils.getEditor( var( "KBUNRUI" ) ) );
		set( "DBTYPE", Utils.getDbtype( var( "KBUNRUI" ) ) );
		set( "EDITOR_PARAM", Utils.getParam( var( "KBUNRUI" ) ) );

		String cnt = "select count(*) CNT from GEA03 "
			+ "where SYSTEM_ID='AN' and CLM='{@CDSITSU}' and KBSAKU = '1' and FGJ='1'";
		sql( cnt );
		if( vari( "CNT" ) == 0 ) {
			String sql = "insert into GEA03("
				+ "SYSTEM_ID,CLM,CLS_NAME,USE_LENGTH,RENDERER,EDITOR,DBTYPE,EDITOR_PARAM,KBSAKU"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'AN','{@CLM}','{@CLS_NAME}',{@USE_LENGTH},'{@RENDERER}','{@EDITOR}','{@DBTYPE}','{@EDITOR_PARAM}','2'"
				+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
				+ ")";
			sql( sql );
		}
		else {
			String sql = "update GEA03 set"
				+ " CLS_NAME = '{@CLS_NAME}'"
				+ ",USE_LENGTH = {@USE_LENGTH}"
				+ ",RENDERER = '{@RENDERER}'"
				+ ",EDITOR = '{@EDITOR}'"
				+ ",DBTYPE = '{@DBTYPE}'"
				+ ",EDITOR_PARAM = '{@EDITOR_PARAM}'"
				+ ",DYUPD = '{@CON.YMDH}'"
				+ ",PGUPD = '{@CON.PGID}'"
				+ ",PGPUPD = '{@CON.PGPID}'"
				+ ",USRUPD = '{@CON.USERID}'"
				+ "where SYSTEM_ID='AN' and CLM='{@CLM}' and KBSAKU = '2' and FGJ='1'";
			sql( sql );

			ResourceFactory.newInstance( "ja" ).clear( var( "CLM"  ) );
		}
	}

	/**
	 * ラベルリソースの追加・更新を行います。
	 */
	private void insupdGEA08() {
		String cnt = "select count(*) CNT from GEA08 "
			+ "where SYSTEM_ID='AN' and CLM='{@CDSITSU}' and LANG='ja' and KBSAKU = '2' and FGJ='1'";
		sql( cnt );
		if( vari( "CNT" ) == 0 ) {
			String sql = "insert into GEA08("
				+ "SYSTEM_ID,CLM,LANG,LNAME,KBLBL,KBSAKU"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'AN','{@CLM}','ja','{@NAIYO}','0','2'"
				+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
				+ ")";
			sql( sql );
		}
		else {
			String sql = "update GEA08 set"
				+ " LNAME = '{@NAIYO}'"
				+ ",DYUPD = '{@CON.YMDH}'"
				+ ",PGUPD = '{@CON.PGID}'"
				+ ",PGPUPD = '{@CON.PGPID}'"
				+ ",USRUPD = '{@CON.USERID}'"
				+ "where SYSTEM_ID='AN' and CLM='{@CLM}' and LANG='ja' and KBSAKU = '2' and FGJ='1'";
			sql( sql );

			ResourceFactory.newInstance( "ja" ).clear( var( "CLM"  ) );
		}
	}

	/**
	 * カラムリソース・ラベルリソースの削除を行います。
	 */
	private void delete() {
		String sql = "update GEA03 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where SYSTEM_ID='AN' and CLM='{@CLM}' and KBSAKU = '2' and FGJ='1'";
		sql( sql );

		String sql2 = "update GEA08 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where SYSTEM_ID='AN' and CLM='{@CLM}' and LANG='ja' and KBSAKU = '1' and FGJ='1'";
		sql( sql2 );
	}

	/**
	 * アンケートコードに関連する、カラムリソース、ラベルリソースを全て削除します。
	 */
	private void allDelete() {
		set( "PARAM", "AN_" + var( "CDANK" ) + "_" );
		String sql = "update GEA03 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where SYSTEM_ID='AN' and CLM like '{@PARAM}%' and KBSAKU = '2' and FGJ='1'";
		sql( sql );

		String sql2 = "update GEA08 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where SYSTEM_ID='AN' and CLM like '{@PARAM}%' and LANG='ja' and KBSAKU = '2' and FGJ='1'";
		sql( sql2 );
	}
}

