/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * 回答を分析する際のキー項目を定義するフラグ(FGKEY)を更新します。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class AN0101A extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
//		return must( "FGKEY" );
		return true;
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		set( "KEYS", "," + ( var( "FGKEY" ) ) + "," );

		String sql = "update AN02 set"
			+ " FGKEY = case when '{@KEYS}' like '%,'||CDSITSU||',%' then '1' else '0' end"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGPID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ " where CDANK = '{@CDANK}'"
			+ " and FGJ = '1'";
		sql( sql );


		return true;
	}
}

