/**************************************************************************/
/* AN11 ( アンケート回答ヘッダ )                                          */
/*                                                                        */
/* Created : 2010/07/09 11:19:12                                          */
/**************************************************************************/
CREATE TABLE AN11 (
   NOKAITO VARCHAR2(10)                NOT NULL      /* 1  回答番号         */
 , USERID  VARCHAR2(10)                NOT NULL      /* 2  ユーザーID       */
 , CDANK   VARCHAR2(10)                NOT NULL      /* 3  アンケートC      */
 , KIPADDR VARCHAR2(15)                NOT NULL      /* 4  回答者IPアドレス */
 , DYKAITO VARCHAR2(14)                NOT NULL      /* 5  回答日時         */
 , KUID    VARCHAR2(10)                NOT NULL      /* 6  回答者ID         */
 , UNIQ    NUMBER(9)       DEFAULT 0   NOT NULL      /* 7  ユニークキー     */
 , FGJ     VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 8  状態フラグ       */
 , DYSET   VARCHAR2(14)                              /* 9  登録日時         */
 , PGSET   VARCHAR2(10)                              /* 10 作成PG           */
 , PGPSET  VARCHAR2(10)                              /* 11 作成親PG         */
 , USRSET  VARCHAR2(10)                              /* 12 作成社員         */
 , DYUPD   VARCHAR2(14)                              /* 13 更新日時         */
 , PGUPD   VARCHAR2(10)                              /* 14 更新PG           */
 , PGPUPD  VARCHAR2(10)                              /* 15 更新親PG         */
 , USRUPD  VARCHAR2(10)                              /* 16 更新者           */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN11S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN11T01 
BEFORE INSERT ON AN11
FOR EACH ROW 
BEGIN 
SELECT AN11S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

