/**************************************************************************/
/* AN03 ( アンケート項目詳細マスタ )                                      */
/*                                                                        */
/* Created : 2010/07/09 11:19:12                                          */
/**************************************************************************/
CREATE TABLE AN03 (
   USERID  VARCHAR2(10)                  NOT NULL      /* 1  ユーザーID   */
 , CDANK   VARCHAR2(10)                  NOT NULL      /* 2  アンケートC  */
 , CDSITSU VARCHAR2(10)                  NOT NULL      /* 3  質問C        */
 , KVAL    VARCHAR2(4000)    DEFAULT '1' NOT NULL      /* 4  回答値       */
 , SEQNO   NUMBER(7)         DEFAULT 0   NOT NULL      /* 5  表示順       */
 , KNAME   VARCHAR2(4000)                NOT NULL      /* 6  回答名称     */
 , IMGKVAL VARCHAR2(200)                               /* 7  回答値画像   */
 , FGOTHER VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 8  その他F      */
 , BIKO    VARCHAR2(4000)                              /* 9  備考         */
 , UNIQ    NUMBER(9)         DEFAULT 0   NOT NULL      /* 10 ユニークキー */
 , FGJ     VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 11 状態フラグ   */
 , DYSET   VARCHAR2(14)                                /* 12 登録日時     */
 , PGSET   VARCHAR2(10)                                /* 13 作成PG       */
 , PGPSET  VARCHAR2(10)                                /* 14 作成親PG     */
 , USRSET  VARCHAR2(10)                                /* 15 作成社員     */
 , DYUPD   VARCHAR2(14)                                /* 16 更新日時     */
 , PGUPD   VARCHAR2(10)                                /* 17 更新PG       */
 , PGPUPD  VARCHAR2(10)                                /* 18 更新親PG     */
 , USRUPD  VARCHAR2(10)                                /* 19 更新者       */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN03S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN03T01 
BEFORE INSERT ON AN03
FOR EACH ROW 
BEGIN 
SELECT AN03S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

