/**************************************************************************/
/* AN02 ( アンケート項目マスタ )                                          */
/*                                                                        */
/* Created : 2010/07/09 11:19:12                                          */
/**************************************************************************/
CREATE TABLE AN02 (
   USERID  VARCHAR2(10)                     NOT NULL      /* 1  ユーザーID   */
 , CDANK   VARCHAR2(10)                     NOT NULL      /* 2  アンケートC  */
 , CDSITSU VARCHAR2(10)                     NOT NULL      /* 3  質問C        */
 , SEQNO   NUMBER(7)         DEFAULT 0      NOT NULL      /* 4  表示順       */
 , NAIYO   VARCHAR2(4000)                   NOT NULL      /* 5  質問内容     */
 , IMGNAI  VARCHAR2(200)                                  /* 6  質問画像     */
 , FGKEY   VARCHAR2(1)       DEFAULT '0'    NOT NULL      /* 7  キー項目F    */
 , FGMUST  VARCHAR2(1)       DEFAULT '0'    NOT NULL      /* 8  回答必須F    */
 , KBUNRUI VARCHAR2(10)      DEFAULT 'TEXT' NOT NULL      /* 9  回答値分類   */
 , KLENGTH NUMBER(9)         DEFAULT 10     NOT NULL      /* 10 回答値桁数   */
 , KNOTE   VARCHAR2(200)                                  /* 11 回答注釈     */
 , BIKO    VARCHAR2(4000)                                 /* 13 備考         */
 , UNIQ    NUMBER(9)         DEFAULT 0      NOT NULL      /* 14 ユニークキー */
 , FGJ     VARCHAR2(1)       DEFAULT '1'    NOT NULL      /* 15 状態フラグ   */
 , DYSET   VARCHAR2(14)                                   /* 16 登録日時     */
 , PGSET   VARCHAR2(10)                                   /* 17 作成PG       */
 , PGPSET  VARCHAR2(10)                                   /* 18 作成親PG     */
 , USRSET  VARCHAR2(10)                                   /* 19 作成社員     */
 , DYUPD   VARCHAR2(14)                                   /* 20 更新日時     */
 , PGUPD   VARCHAR2(10)                                   /* 21 更新PG       */
 , PGPUPD  VARCHAR2(10)                                   /* 22 更新親PG     */
 , USRUPD  VARCHAR2(10)                                   /* 23 更新者       */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN02S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN02T01 
BEFORE INSERT ON AN02
FOR EACH ROW 
BEGIN 
SELECT AN02S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

