/**************************************************************************/
/* AN01 ( アンケートマスタ )                                              */
/*                                                                        */
/* Created : 2010/07/09 11:19:11                                          */
/**************************************************************************/
CREATE TABLE AN01 (
   USERID   VARCHAR2(10)                               NOT NULL      /* 1  ユーザーID             */
 , CDANK    VARCHAR2(10)                               NOT NULL      /* 2  アンケートC            */
 , NMANK    VARCHAR2(500)                              NOT NULL      /* 3  アンケート名称         */
 , DYKSTR   VARCHAR2(14)      DEFAULT '00000101000000' NOT NULL      /* 4  公開開始日             */
 , DYKEND   VARCHAR2(14)      DEFAULT '99991231000000' NOT NULL      /* 5  公開終了日             */
 , FGKOKAI  VARCHAR2(1)       DEFAULT '0'              NOT NULL      /* 6  公開F                  */
 , BIKO     VARCHAR2(4000)                                           /* 7  備考                   */
 , CHECKKEY VARCHAR2(200)                                            /* 8  チェックキー(暗号化前) */
 , CRYPTKEY VARCHAR2(200)                                            /* 9  チェックキー(暗号化後) */
 , UNIQ     NUMBER(9)         DEFAULT 0                NOT NULL      /* 10 ユニークキー           */
 , FGJ      VARCHAR2(1)       DEFAULT '1'              NOT NULL      /* 11 状態フラグ             */
 , DYSET    VARCHAR2(14)                                             /* 12 登録日時               */
 , PGSET    VARCHAR2(10)                                             /* 13 作成PG                 */
 , PGPSET   VARCHAR2(10)                                             /* 14 作成親PG               */
 , USRSET   VARCHAR2(10)                                             /* 15 作成社員               */
 , DYUPD    VARCHAR2(14)                                             /* 16 更新日時               */
 , PGUPD    VARCHAR2(10)                                             /* 17 更新PG                 */
 , PGPUPD   VARCHAR2(10)                                             /* 18 更新親PG               */
 , USRUPD   VARCHAR2(10)                                             /* 19 更新者                 */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN01S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN01T01 
BEFORE INSERT ON AN01
FOR EACH ROW 
BEGIN 
SELECT AN01S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

