/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.xml.OGAtts;
import org.xml.sax.Attributes;

public class OGAttributes {
    public static final String CR = System.getProperty("line.separator");
    public static final int CR_CNT = 4;
    public static final int CR_LEN = 80;
    private final List<OGAtts> attList = new ArrayList<OGAtts>();
    private String attTab = CR + "\t";
    private boolean useCR = false;
    private int maxValLen = 0;

    public OGAttributes() {
    }

    public OGAttributes(String string, Attributes attributes, boolean bl) {
        if (string != null) {
            this.attTab = CR + string + "\t";
        }
        this.useCR = bl;
        int n = attributes == null ? 0 : attributes.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            OGAtts oGAtts = new OGAtts(attributes.getQName(i), attributes.getValue(i));
            this.attList.add(oGAtts);
            n2 = oGAtts.maxKeyLen(n2);
        }
        this.maxValLen = n2;
    }

    public void setAttrTab(String string) {
        if (string != null) {
            this.attTab = CR + string + "\t";
        }
    }

    public void setUseCR(boolean bl) {
        this.useCR = bl;
    }

    public int size() {
        return this.attList.size();
    }

    public String getKey(int n) {
        return this.attList.get((int)n).KEY;
    }

    public String getVal(int n) {
        return this.attList.get((int)n).VAL;
    }

    public void setVal(int n, String string) {
        OGAtts oGAtts = this.attList.remove(n);
        this.attList.add(n, new OGAtts(oGAtts.KEY, string));
    }

    public void add(String string, String string2) {
        OGAtts oGAtts = new OGAtts(string, string2);
        this.attList.add(oGAtts);
        this.maxValLen = oGAtts.maxKeyLen(this.maxValLen);
    }

    public void add(int n, String string, String string2) {
        OGAtts oGAtts = new OGAtts(string, string2);
        this.attList.add(n, oGAtts);
        this.maxValLen = oGAtts.maxKeyLen(this.maxValLen);
    }

    public void remove(int n) {
        this.attList.remove(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useCR) {
            for (int i = 0; i < this.size(); ++i) {
                OGAtts oGAtts = this.attList.get(i);
                stringBuilder.append(this.attTab).append(oGAtts.getAlignKey(this.maxValLen)).append(" = ").append(oGAtts.QRT_VAL);
            }
        } else {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                OGAtts oGAtts = this.attList.get(i);
                if (i > 0 && (++n > 4 || (n2 += oGAtts.LEN) > 80)) {
                    stringBuilder.append(this.attTab).append(oGAtts.KEY).append("=").append(oGAtts.QRT_VAL);
                    n = 0;
                    n2 = 0;
                    continue;
                }
                stringBuilder.append(" ").append(oGAtts.KEY).append("=").append(oGAtts.QRT_VAL);
            }
        }
        return stringBuilder.toString();
    }
}

