/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.xml.OGDocument;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNode;
import org.opengion.fukurou.xml.OGNodeType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class JspSaxParser
extends DefaultHandler2 {
    public static final String CR = System.getProperty("line.separator");
    private String attTab = "";
    private Stack<OGNode> stack = null;
    private OGNode ele = null;
    private boolean inCDATA = false;
    private boolean inEntity = false;
    private File file = null;

    public static OGDocument read(File file) {
        JspSaxParser jspSaxParser = new JspSaxParser();
        jspSaxParser.setFile(file);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", jspSaxParser);
            sAXParser.parse(file, (DefaultHandler)jspSaxParser);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            String string = "XMLReader \u306f\u3001\u8a8d\u8b58\u3055\u308c\u306a\u3044\u6a5f\u80fd\u307e\u305f\u306f\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u8b58\u5225\u5b50\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + sAXNotRecognizedException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, sAXNotRecognizedException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + parserConfigurationException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, parserConfigurationException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            String string = "XMLReader \u306f\u3001\u8981\u6c42\u3055\u308c\u305f\u64cd\u4f5c (\u72b6\u614b\u307e\u305f\u306f\u5024\u306e\u8a2d\u5b9a) \u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\t" + sAXNotSupportedException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, sAXNotSupportedException);
        }
        catch (SAXException sAXException) {
            String string = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + sAXException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u53d6\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + iOException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, iOException);
        }
        catch (Exception exception) {
            String string = "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + exception.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, exception);
        }
        return jspSaxParser.getDocument();
    }

    public static OGDocument string2Node(String string) {
        JspSaxParser jspSaxParser = new JspSaxParser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", jspSaxParser);
            InputSource inputSource = new InputSource(new StringReader(string));
            sAXParser.parse(inputSource, (DefaultHandler)jspSaxParser);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            String string2 = "XMLReader \u306f\u3001\u8a8d\u8b58\u3055\u308c\u306a\u3044\u6a5f\u80fd\u307e\u305f\u306f\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u8b58\u5225\u5b50\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002" + CR + sAXNotRecognizedException.getMessage();
            throw new RuntimeException(string2, sAXNotRecognizedException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + parserConfigurationException.getMessage();
            throw new RuntimeException(string3, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string4 = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + sAXException.getMessage();
            throw new RuntimeException(string4, sAXException);
        }
        catch (IOException iOException) {
            String string5 = "\u30b9\u30c8\u30ea\u30fc\u30e0\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + iOException.getMessage();
            throw new RuntimeException(string5, iOException);
        }
        catch (Exception exception) {
            String string6 = "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + exception.getMessage();
            throw new RuntimeException(string6, exception);
        }
        return jspSaxParser.getDocument();
    }

    public static void write(File file, OGDocument oGDocument) {
        JspSaxParser.write(file, oGDocument, "UTF-8");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(File file, OGDocument oGDocument, String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)));
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
            printWriter.println(oGDocument.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9\u540d\u3067\u793a\u3055\u308c\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\t" + fileNotFoundException.getMessage() + CR + "\t" + file;
                throw new RuntimeException(string2, fileNotFoundException);
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string3 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0(UTF-8)\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + "\t" + unsupportedEncodingException.getMessage() + CR + "\t" + file;
                    throw new RuntimeException(string3, unsupportedEncodingException);
                }
                catch (Exception exception) {
                    String string4 = "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + exception.getMessage() + CR + "\t" + file;
                    throw new RuntimeException(string4, exception);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(printWriter);
                throw throwable;
            }
        }
        Closer.ioClose(printWriter);
    }

    public static void copyDirectry(File file, File file2) {
        if (file.exists() && file.isFile()) {
            boolean bl = false;
            String string = file.getName();
            if (string.endsWith(".jsp") || string.endsWith(".xml")) {
                try {
                    OGDocument oGDocument = JspSaxParser.read(file);
                    if (oGDocument != null) {
                        JspSaxParser.write(file2, oGDocument);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            if (!bl) {
                FileUtil.copy(file, file2, true);
            }
            return;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            JspSaxParser.copyDirectry(fileArray[i], new File(file2, fileArray[i].getName()));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: JspSaxParser  <inFile|inDir> <outFile|outDir>");
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        JspSaxParser.copyDirectry(file, file2);
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void startDocument() {
        this.stack = new Stack();
        this.ele = new OGDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        OGElement oGElement = new OGElement(string3, this.attTab, attributes);
        this.ele.addNode(oGElement);
        this.stack.push(this.ele);
        this.ele = oGElement;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.inEntity) {
            return;
        }
        String string = this.toText(cArray, n, n2);
        if (this.inCDATA) {
            this.ele.addNode(string);
            return;
        }
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
        int n3 = string.lastIndexOf(10);
        this.attTab = n3 >= 0 ? string.substring(n3 + 1) : string;
    }

    @Override
    public void startCDATA() {
        OGNode oGNode = new OGNode();
        oGNode.setNodeType(OGNodeType.Cdata);
        this.ele.addNode(oGNode);
        this.stack.push(this.ele);
        this.ele = oGNode;
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() {
        this.ele = this.stack.pop();
        this.inCDATA = false;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE ").append(string);
        if (string2 != null) {
            stringBuilder.append(" PUBLIC \"").append(string2).append("\"");
        }
        if (string3 != null) {
            stringBuilder.append("\"").append(string3).append("\"");
        }
        OGNode oGNode = new OGNode(stringBuilder.toString());
        oGNode.setNodeType(OGNodeType.DTD);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String string) {
        String string2 = "&" + string + ";";
        OGNode oGNode = new OGNode(string2);
        this.ele.addNode(oGNode);
        this.inEntity = true;
    }

    @Override
    public void endEntity(String string) {
        this.inEntity = false;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        oGNode.setNodeType(OGNodeType.Comment);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.ele = this.stack.pop();
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        String string = sAXParseException.getMessage() + ":" + sAXParseException.getPublicId() + CR + "\t" + this.file + " (" + sAXParseException.getLineNumber() + ")";
        System.err.println("WARNING:" + string);
    }

    private String toText(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        return string.replaceAll("\n", CR);
    }

    public OGDocument getDocument() {
        if (this.ele != null && this.ele.getNodeType() == OGNodeType.Document) {
            return (OGDocument)this.ele;
        }
        return null;
    }
}

