/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.xml.HybsXMLSave;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class DirectXMLSaveTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String ENCODE = "UTF-8";
    private String dbid = null;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String displayMsg = "MSG0040";
    private String[] keys = null;
    private String[] vals = null;
    private long dyStart = 0L;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        return 0;
    }

    @Override
    public int doEndTag() {
        int n;
        int n2;
        int n3;
        Object object;
        this.debugPrint();
        BufferedReader bufferedReader = null;
        boolean bl = true;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.getApplicationInfo());
            bufferedReader = this.getBufferedReader();
            object = new HybsXMLSave(connection);
            if (this.keys != null) {
                object.setAfterMap(this.getAfterMap());
            }
            object.insertXML((Reader)bufferedReader);
            n3 = object.getInsertCount();
            n2 = object.getUpdateCount();
            n = object.getDeleteCount();
            Closer.commit((Connection)connection);
            bl = false;
        }
        catch (Throwable throwable) {
            Closer.rollback(connection);
            throw new HybsSystemException(throwable);
        }
        finally {
            if (bl) {
                ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            } else {
                ConnectionFactory.close((Connection)connection, (String)this.dbid);
            }
            Closer.ioClose((Closeable)bufferedReader);
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("INS:").append(n3);
            ((StringBuilder)object).append(" / UPD:").append(n2);
            ((StringBuilder)object).append(" / DEL:").append(n);
            ((StringBuilder)object).append(this.getResource().getLabel(this.displayMsg));
            ((StringBuilder)object).append(HybsSystem.BR);
            this.jspPrint(((StringBuilder)object).toString());
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(n3, l, this.fileURL + this.filename);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.displayMsg = "MSG0040";
        this.keys = null;
        this.vals = null;
    }

    private BufferedReader getBufferedReader() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        String string = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((String)string, (String)this.filename));
        BufferedReader bufferedReader = FileUtil.getBufferedReader((File)file, (String)ENCODE);
        return bufferedReader;
    }

    private Map<String, String> getAfterMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.keys.length; ++i) {
            hashMap.put(this.keys[i], this.vals[i]);
        }
        return hashMap;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("displayMsg", (Object)this.displayMsg).println("dyStart", (Object)this.dyStart).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

