/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ZipFileUtil;
import org.opengion.fukurou.xml.HybsXMLSave;
import org.opengion.hayabusa.common.HybsSystem;

public final class SystemInstaller {
    private final String VERSION;
    private final Connection connection;
    private final PrintWriter out;
    public static final String GE12_XML = "org/opengion/hayabusa/common/GE12.xml";
    public static final String SEL_MAX_ENG = "select PARAM from GE12 where SYSTEM_ID='**' and PARAM_ID='ENGINE_INFO' and FGJ='1' and KBSAKU='0'";
    public static final String SEL_SYS_ENG = "select PARAM from GE12 where SYSTEM_ID=? and PARAM_ID='ENGINE_INFO' and KBSAKU='0' and CONTXT_PATH=? and FGJ='1'";

    public SystemInstaller(Connection connection, PrintWriter printWriter) {
        this.connection = connection;
        this.out = printWriter;
        this.VERSION = "5.1.9.0 Release5 Builds (10190)";
    }

    public void autoInsUpd(String string, String string2, String string3) throws SQLException, UnsupportedEncodingException {
        String string4 = this.getOldMaxVersion();
        String string5 = this.getOldSystemVersion(string, string3);
        this.out.println("    System Version Information ( " + string + " )");
        this.out.println("      Load Version [ " + this.VERSION + " ]");
        this.out.println("        -> Resource Version[ " + string4 + " ]");
        this.out.println("        -> System   Version[ " + string5 + " ]");
        if ("none".equalsIgnoreCase(string4)) {
            this.out.println("      !!! openGion ENVIROMENT IS NOT INSTALLED !!!");
            String string6 = System.getenv("INSTALL_CONTEXTS");
            if (string6 == null || string6.length() == 0) {
                this.out.println("        !!! \"INSTALL_CONTEXT\" IS NOT CONFIGURED\" !!!");
                this.out.println("        !!! \"SET ENRIVOMENT PARAMETER NAMED \"INSTALL_CONTEXT\" ON INIT_SCRIPT !!!");
                return;
            }
            this.out.println("      Start Initiall Enviroment Install : install type ( " + string6 + " )");
            String[] stringArray = StringUtil.csv2Array((String)string6);
            for (int i = 0; i < stringArray.length; ++i) {
                this.out.println("        install    ( " + stringArray[i] + " )");
                this.loadXMLScript("install", stringArray[i]);
                this.connection.commit();
                this.out.println("        completed  ( " + stringArray[i] + " )");
            }
            this.out.println("      Start SystemParameter reload");
            this.dbXMLResourceInsert();
            this.connection.commit();
            this.out.println("      completed");
        } else {
            if (string5 == null || string5.compareTo(this.VERSION) < 0) {
                this.out.println("      Start Enviroment Update ( " + string2 + " )");
                this.loadXMLScript("update", string2);
                this.connection.commit();
                this.out.println("      completed               ( " + string2 + " )");
            }
            if (string4 == null || string4.compareTo(this.VERSION) < 0) {
                this.out.println("      Start SystemParameter Reload");
                this.dbXMLResourceInsert();
                this.connection.commit();
                this.out.println("      completed");
            }
        }
    }

    public void install(File file) throws SQLException {
        String string;
        File[] fileArray;
        String string2 = File.separator;
        String string3 = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("FILE_URL") + String.valueOf(System.currentTimeMillis() + string2);
        String string4 = System.getenv("CATALINA_HOME") + string2 + "conf" + string2 + System.getenv("ENGINE_NAME") + string2 + "localhost" + string2;
        String string5 = System.getenv("APP_BASE") + string2;
        this.out.println("      Check Archive File and Enviroment");
        if (!file.exists()) {
            this.out.println("        !!! Archive File does not exists File=[ " + file.getAbsolutePath() + "] !!!");
            this.out.println("        !!! Install Aborted !!! ");
            return;
        }
        ZipFileUtil.unCompress((String)string3, (String)file.getAbsolutePath());
        for (File file2 : fileArray = new File(string3).listFiles()) {
            if (!file2.isDirectory()) {
                this.out.println("        !!! This Archive is not Installer. Because include FILE not DIRECTORY. File=[ " + file2.getName() + "] !!!");
                this.out.println("        !!! Install Aborted !!! ");
                return;
            }
            string = file2.getName();
            File file3 = new File(string3 + string + string2 + "WEB-INF" + string2 + string + ".xml");
            if (!file3.exists()) {
                this.out.println("        !!! Context XML Does not exists =[ " + file3.getAbsolutePath() + "] !!!");
                this.out.println("        !!! Install Aborted !!! ");
                return;
            }
            File file4 = new File(string4 + string + ".xml");
            if (file4.exists()) {
                this.out.println("        !!! Context XML File Already Installed File=[ " + file4.getAbsolutePath() + "] !!!");
                this.out.println("        !!! Install Aborted !!! ");
                return;
            }
            File file5 = new File(string5 + string);
            if (file5.exists()) {
                this.out.println("        !!! Context Path Already Exists Path=[ " + file5.getAbsolutePath() + "] !!!");
                this.out.println("        !!! Install Aborted !!! ");
                return;
            }
            this.out.println("        This Archive includes SYSTEM ( " + file2.getName() + " ) for Install");
        }
        for (File file2 : fileArray) {
            string = file2.getName();
            this.out.println("      Start Enviroment Install ( " + string + " )");
            FileUtil.copyDirectry((String)(string3 + string), (String)(string5 + string));
            FileUtil.copy((String)(string3 + string + string2 + "WEB-INF" + string2 + string + ".xml"), (String)(string4 + string + ".xml"));
            this.loadXMLScript("install", string);
            this.connection.commit();
            this.out.println("      completed                ( " + string + " )");
        }
        this.out.println("      Install Process All Completed.");
    }

    private void loadXMLScript(String string, String string2) throws SQLException {
        String string3;
        Object object;
        Object object2;
        String string4 = File.separator;
        String string5 = System.getenv("APP_BASE");
        String string6 = this.connection.getMetaData().getDatabaseProductName().toLowerCase(Locale.JAPAN);
        String string7 = string5 + string4 + string2.toLowerCase(Locale.JAPAN) + string4 + "db";
        File[] fileArray = new File(string7).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            this.out.println("             DB Folder not found. [" + string7 + "]");
            return;
        }
        String string8 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (string6.indexOf(fileArray[i].getName()) < 0) continue;
            string8 = fileArray[i].getAbsolutePath();
            break;
        }
        if (string8 == null) {
            this.out.println("             !!! Script Folder for [ " + string6 + " ] not found !!!");
            return;
        }
        ArrayList arrayList = new ArrayList();
        FileUtil.getFileList((File)new File(string8 + string4 + "xml" + string4 + string), (boolean)true, arrayList);
        if (!arrayList.isEmpty()) {
            object2 = null;
            for (String string9 : arrayList) {
                if (!string9.endsWith(".xml")) continue;
                object = new File(string9);
                string3 = ((File)object).getParent();
                if (object2 == null || !object2.equalsIgnoreCase(string3)) {
                    this.out.println("            processing ... " + string3);
                    object2 = string3;
                }
                BufferedReader bufferedReader = new BufferedReader(FileUtil.getBufferedReader((File)object, (String)"UTF-8"));
                HybsXMLSave hybsXMLSave = new HybsXMLSave(this.connection, ((File)object).getName());
                hybsXMLSave.insertXML((Reader)bufferedReader);
            }
            this.out.println("            DB Enviroment Installed , [ " + arrayList.size() + " ] scripts loaded ");
        }
        if ((object2 = new File(string7 + string4 + "xml").listFiles()) != null && ((File[])object2).length > 0) {
            for (int i = 0; i < ((File[])object2).length; ++i) {
                String string9;
                string9 = object2[i].getName();
                if (!string9.endsWith(".xml")) continue;
                object = new BufferedReader(FileUtil.getBufferedReader((File)object2[i], (String)"UTF-8"));
                string3 = new HybsXMLSave(this.connection, string9);
                string3.insertXML((Reader)object);
            }
            this.out.println("            DB Data Files Installed , [ " + ((File[])object2).length + " ] files loaded ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldMaxVersion() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(SEL_MAX_ENG);
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                string = "none";
                Closer.rollback((Connection)this.connection);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose((Statement)statement);
                throw throwable;
            }
            Closer.resultClose((ResultSet)resultSet);
            Closer.stmtClose((Statement)statement);
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldSystemVersion(String string, String string2) {
        String string3;
        block6: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                preparedStatement = this.connection.prepareStatement(SEL_SYS_ENG);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
                Closer.resultClose((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                Closer.rollback((Connection)this.connection);
                break block6;
            }
            finally {
                Closer.resultClose(resultSet);
                Closer.stmtClose((Statement)preparedStatement);
            }
            Closer.stmtClose((Statement)preparedStatement);
        }
        return string3;
    }

    private void dbXMLResourceInsert() throws UnsupportedEncodingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(GE12_XML);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        HybsXMLSave hybsXMLSave = new HybsXMLSave(this.connection, "GE12");
        hybsXMLSave.insertXML((Reader)bufferedReader);
        int n = hybsXMLSave.getInsertCount();
        int n2 = hybsXMLSave.getDeleteCount();
        this.out.print("        XML Engine Resource Reconfiguration ");
        this.out.println("DELETE=[" + n2 + "],INSERT=[" + n + "] finished.");
    }
}

