#ifndef TYPING_RECORDER_H
#define TYPING_RECORDER_H

/*!
  \file
  \brief ^CsŐL^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TypingMode.h"
#include <memory>
#include <string>
#include <vector>


/*!
  \brief ^CsŐL^NX
*/
class TypingRecorder {
  TypingRecorder(const TypingRecorder& rhs);
  TypingRecorder& operator = (const TypingRecorder& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  /*!
    \brief 
  */
  enum {
    Clear = 0x1,                //!< NA
    BackSpace = 0x2,            //!< obNXy[X
    Return = 0x3,               //!< s
    Complete = 0x4,             //!< ͊
  };

  /*!
    \brief L[͏
  */
  typedef struct {
    int ticks;                  //!< ̓^C~O
    char ch;                    //!< ̓L[
  } KeyTiming;

  /*!
    \brief ȁ
  */
  typedef struct {
    int no;                      //!< a̔ԍ
    std::vector<KeyTiming> keys; //!< ̓L[
  } WakaTyping;

  /*!
    \brief L^ڍׂ̒`
  */
  typedef struct {
    int types;                    //!< ^Cv []
    int miss_types;               //!< ^Cv~X̉ []
    int delay_msec;               //!< ͊Jnx [msec]
    int elapse_msec;              //!< oߎ [msec]
  } ScoreData;

  /*!
    \brief Q[
  */
  typedef struct {
    std::string major_version;
    std::string minor_version;
    std::string micro_version;

    TypingMode mode;              //!< ^CsO[h
    std::string user_name;        //!< [U
    time_t time;                  //!< L^ꂽ
    int rand_seed;                //!< _V[h
    ScoreData score;              //!< XRA
    int waka_num;                 //!< a̐
    std::vector<WakaTyping> waka; //!< ȁ
    int kaminoku_speed;           //!< ̋̍Đx
    int shimonoku_speed;           //!< ̋̍Đx
  } GameSettings;

  TypingRecorder(void);
  ~TypingRecorder(void);

  /*!
    \brief Q[̋L^Jn

    \param rand_seed [i] _V[h
    \param mode [i] ^CsO[h
  */
  void recordGame(int rand_seed, TypingMode mode);

  /*!
    \brief ȁ̋L^Jn

    \param no [i] a̔ԍ
  */
  void recordWaka(size_t no);

  /*!
    \brief ^CsŐL^

    \param ch [i] ̓L[
    \param ticks [i] ̓^CsO
  */
  void recordTyping(char ch, size_t ticks);

  /*!
    \brief o^e̕]

    \param user_name [i] [U
  */
  void evaluate(const char* user_name);

  /*!
    \brief a̐̎擾
  */
  size_t getWakaNum(void);

  /*!
    \brief ͒x̎擾
  */
  double getStartDelay(void);

  /*!
    \brief ^CsOXs[h̎擾
  */
  double getTypingSpeed(void);

  /*!
    \brief ^Cv~X̎擾
  */
  size_t getMissTypes(void);

  /*!
    \brief Q[f[^Ԃ
  */
  GameSettings& getRecordData(void) const;

  /*!
    \brief Q[f[^̃GR[h
  */
  static std::string encodeGameData(const GameSettings& data);

  /*!
    \brief fobO\p
  */
  void print(void);
};

#endif /* !TYPING_RECORDER_H */
