/*!
  \file
  \brief a̕т̃VbtNX

  \author Satofumi KAMIMURA

  $Id$

  \todo ܂莚̂Ƃɂ́A܂莚O[vŃ\[g
*/

#include "ShuffleWaka.h"
#include "WakaData.h"
#include <algorithm>
#include <set>
#include <boost/random.hpp>

using namespace boost;


struct ShuffleWaka::pImpl {
  enum {
    InvalidNo = -1,

    // !!! 6 ł߂Ȃ̂łƂ肠 +2 ĂB strncmp C
    KimarijiMax = 6 + 2,        // â̌܂莚́AőłU
  };
  TypingMode typing_mode;
  int seed;
  int waka_no;
  int range_to;
  typedef std::vector<std::vector<int> > WakaGroup;
  WakaGroup kimariji_group;

  class KimarijiOrder {
    int waka_no;

  public:
    KimarijiOrder(void) : waka_no(0) {
    }

    KimarijiOrder(int no) : waka_no(no) {
    }

    bool operator<(const KimarijiOrder& rhs) const {
      return (strncmp(waka_no, rhs.waka_no, KimarijiMax) < 0) ? true : false;
    }

    int getNo(void) const {
      return waka_no;
    }

    // !!! n őf[^ȏɂȂȂ悤ɂ邱
    static int strncmp(int no1, int no2, size_t n) {
      if (no1 == no2) {
        return 0;
      }

      enum { Left = 0, Right = 1 };
      const Uint16* ch[2];
      ch[Left] = KanaWaka[no1][0];
      ch[Right] = KanaWaka[no2][0];

      for (size_t i = 0; i < n; ++i) {

        int cmp = *ch[Left] - *ch[Right];
        if (cmp != 0) {
          return cmp;
        }

        // ̔r 0x0 pĔrsȂ߂̏
        for (int i = 0; i < 2; ++i) {
          ++ch[i];
          if (*ch[i] == 0x0) {
            ++ch[i];
          }
        }
      }
      return 0;
    }
  };

  pImpl(TypingMode mode, int random_seed)
    : typing_mode(mode), seed(random_seed), waka_no(InvalidNo), range_to(0) {

    // xɑΏ
    //if (YomibitoName || KanjiWaka);
  }

  void shimonokuTypingSort(std::vector<int>& waka) {

    // â̗
    waka.clear();
    for (int i = 0; i < 100; ++i) {
      waka.push_back(i);
    }

    // ̏
    uniform_int<> range(0, 99);
    variate_generator<mt19937,uniform_int<> >
      rand(mt19937(static_cast<boost::uint32_t>(seed)), range);

    // Vbt
    if (seed != NoShuffleSeed) {
      for (int i = 0; i < 99; ++i) {
        int swap_index = rand();
        std::swap(waka[i], waka[swap_index]);
      }

      // d_K̘âw肳ꂽꏊOɈړ
      if (waka_no != pImpl::InvalidNo) {
        std::vector<int>::iterator p = find(waka.begin(), waka.end(), waka_no);
        if (p == waka.end()) {
          // 肦Ȃꉞ
          return;
        }
        int swap_index = rand() % range_to;
        std::swap(*p, waka[swap_index]);
      }
    }
  }

  void kimarijiTypingSort(std::vector<int>& waka) {

    // ܂莚̃O[v
    createKimarijiGroup();

    if (seed != NoShuffleSeed) {
      // ܂莚̎wO[v܂܂悤ɂ鏈
      // !!!

      // ܂莚O[ṽVbt
      // !!!

      // TuO[ṽVbt
      // !!!
    }

    // ܂莚̃O[v
    waka.clear();
    // !!! waka ɑ΂ă}[Wʂ
    // !!! \bh STL ɂC
    // !!! Ƃ肠Aׂɍ
    // !!! ɁAtypedef ׂH
    for (WakaGroup::iterator git = kimariji_group.begin();
         git != kimariji_group.end(); ++git) {
      for (std::vector<int>::iterator sit = git->begin();
           sit != git->end(); ++sit) {
        waka.push_back(*sit);
        //fprintf(stderr, "%d, ", *sit);
      }
    }
  }

  // ܂莚̃O[v
  void createKimarijiGroup(void) {

    // ς݂߂
    if (! kimariji_group.empty()) {
      return;
    }

    // ܂莚Ƀ\[g
    std::set<KimarijiOrder> kimariji_order;
    for (int i = 0; i < 100; ++i) {
      kimariji_order.insert(KimarijiOrder(i));
    }

    // ܂莚喈ɃTuO[vs
    std::vector<int> sub_group;
    size_t kimariji_length = 1;
    for (std::set<KimarijiOrder>::iterator it = kimariji_order.begin();
         it != kimariji_order.end(); ++it) {

      // O[vȂâo^
      int now_no = it->getNo();
      if (sub_group.empty()) {
        sub_group.push_back(now_no);
        kimariji_length = 1;
        continue;
      }

      // ̘âƓт΁A܂莚O[vɓo^
      int prev_no = sub_group.front();

      bool matched = false;
      for (; kimariji_length < KimarijiMax; ++kimariji_length) {
        // !!! ƁA肷C
        bool ret = (KimarijiOrder::strncmp(prev_no, now_no, kimariji_length)
                    == 0) ? true : false;
        matched |= ret;
        if (ret == false) {
          break;
        }
      }
      --kimariji_length;

      if (matched) {
        // ܂莚Ƃ݂ȂăTuO[vɓo^
        sub_group.push_back(now_no);

      } else {
        // TuO[vo^ċɂ
        kimariji_group.push_back(sub_group);

#if 0
        // !!! Ƃ肠Aт\ĊmF
        for (std::vector<int>::iterator test_it = sub_group.begin();
             test_it != sub_group.end(); ++test_it) {
          fprintf(stderr, "%d, ", *test_it);
        }
        fprintf(stderr, "\n");
#endif
        sub_group.clear();

        // !!! ̕ƋʎAꂭ
        sub_group.push_back(now_no);
        kimariji_length = 1;
      }
    }
    kimariji_group.push_back(sub_group);
    // !!! ...BKɊ֐܂傤
  }
};


ShuffleWaka::ShuffleWaka(TypingMode mode, int seed)
  : pimpl(new pImpl(mode, seed)) {
}


ShuffleWaka::~ShuffleWaka(void) {
}


void ShuffleWaka::setSomeWaka(int no, int range_to) {
  pimpl->waka_no = no;
  pimpl->range_to = range_to;
}


void ShuffleWaka::shuffle(std::vector<int>& waka) {

  switch (pimpl->typing_mode) {
  case ShimonokuTyping:
    pimpl->shimonokuTypingSort(waka);
    break;

  case KimarijiTyping:
    // !!! kimarijiTypingSort() ܂ł̎b菈
    pimpl->shimonokuTypingSort(waka);
    //pimpl->kimarijiTypingSort(waka);
    break;
  }
}


std::vector<int> ShuffleWaka::getKimarijiGroup(int no) {
  pimpl->createKimarijiGroup();

  for (pImpl::WakaGroup::iterator it = pimpl->kimariji_group.begin();
       it != pimpl->kimariji_group.end(); ++it) {
    std::vector<int>::iterator p = find(it->begin(), it->end(), no);
    if (p != it->end()) {
      return *it;
    }
  }

  // 肦Ȃ͂Aꉞ
  std::vector<int> not_found;
  return not_found;
}
