/*!
  \file
  \brief ̋̓͗K

  \author Satofumi KAMIMURA

  $Id$

  \todo L[\
  \todo Iɂ́ACD-ROM  T / TȂ IvVőIł悤ɂׂ
*/

#include "ShimonokuPractice.h"
#include "ShimonokuPractice_uni.h"
#include "PracticeMenu_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ResourceDefinition.h"
#include "ShimonokuInput.h"
#include "CommonResources.h"
#include "ResultDrawer.h"
#include "GraphDrawer.h"
#include "TypingRecorder.h"
#include "ShuffleWaka.h"
#include "VoicePlayer.h"
#include "GuiManager.h"
#include "Layer.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "GetTicks.h"
#include "Delay.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "SdlUtils.h"
#include "InputHandler.h"
#include "InputEvent.h"
#include "InputReceiveComponent.h"
#include "UtfString.h"
#include <time.h>

using namespace beego;


struct ShimonokuPractice::pImpl {

  class Schedule : public BaseEntity {
    bool is_terminated;
    StateMachine<Schedule>* state_machine;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      type->changeState(PrologueState::getObject(common));
    }

    void exit(Schedule* type) {

      // Q[̋L^
      int rand_seed = static_cast<int>(time(NULL));
      //rand_seed = ShuffleWaka::NoShuffleSeed;

      // â̏ԂVbt
      ShuffleWaka wakaShuffle(ShimonokuTyping, rand_seed);
      wakaShuffle.shuffle(common->waka_order);

      // !!! d_K܂̎
      // !!!
      // wakaShuffle.shuffle();

      common->recorder->recordGame(rand_seed, ShimonokuTyping);
    }
  };

  class PrologueState : public State<Schedule> {

    CommonResources* common;
    // !!! `܂͕ʃNXɂA肷邩
    TextProperty title_property;
    Surface title_surface;
    Component title_label;
    Surface subTitle_surface;
    Component subTitle_label;
    size_t first_ticks;

    PrologueState(CommonResources* common_obj)
      : common(common_obj),
        title_property(common->font, PracticeMenu_shimonoku, TitleSize,
                       Fore, Back, true),
        title_surface(new TextSurface(title_property)),
        title_label(new LabelComponent(title_surface)) {
    }

  public:
    static PrologueState* getObject(CommonResources* common) {
      static PrologueState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // ű^CsOvƕ\
      SDL_Rect position;
      set_SdlRect(&position, centerPosition(title_label, 640/2),
                  middlePosition(title_label, 480/4 + SubOffset));
      title_label->setPosition(&position);

      // uX ṽx쐬
      std::vector<Uint16> num_str;
      char buffer[4];
      sprintf(buffer, "%d", common->getPracticeNum());
      ustrcat(num_str, buffer);
      ustrcat(num_str, ShimonokuPractice_PrologueSubTitle);
      TextProperty text_property(common->font, &num_str[0],
                                 LargeSize, Fore, Back, true);
      Surface new_surface(new TextSurface(text_property));
      std::swap(new_surface, subTitle_surface);

      Component new_label(new LabelComponent(subTitle_surface));
      std::swap(new_label, subTitle_label);

      set_SdlRect(&position, centerPosition(subTitle_label, 640/2),
                  topPosition(subTitle_label, 480/4 + MenuOffset) + SubOffset);
      subTitle_label->setPosition(&position);

      placeComponents();

      // y̒~҂
      // !!! ^CAEgł悤ɂׂ
      while (common->nowSoundPlaying()) {
        delay(10);
      }

      // ʉ̍ĐJn
      common->playEffect(SoundEffect_1);

      first_ticks = GetTicks();

      // a CD-ROM ZbgĂ邩̊mFƁAf[^ǂݏo
      common->gui->update();
      // !!! XbhɂȂƁA`悪A
      common->voice_->checkCd();
    }

    void execute(Schedule* type) {

      // ҋ@Ԃo߂ATypingState ֑Jڂ
      InputEvent input_event;
      common->input_receiver->updateInputEvent(input_event);
      size_t spent_msec = GetTicks() - first_ticks;
      if ((spent_msec >= PrologueMsec) ||
          (InputEvent::isReleased(input_event, SDLK_RETURN))) {
        type->changeState(TypingState::getObject(common));
      }
    }

    void exit(Schedule* type) {

      // zuR|[lg폜
      removeComponents();

      // y̍Đ
      common->setNextMusic(BackMusic_2);
    }

    void placeComponents(void) {
      common->front_layer->push_front(title_label);
      common->front_layer->push_front(subTitle_label);

      common->input_receiver->clear();
    }

    void removeComponents(void) {
      common->front_layer->remove(title_label);
      common->front_layer->remove(subTitle_label);

      common->stopEffect();
    }
  };

  class TypingState : public State<Schedule> {
    CommonResources* common;
    ShimonokuInput shimonoku_input;
    InputEvent input_event;
    size_t practice_left;
    bool typing_complete;

    TypingState(CommonResources* common_obj)
      : common(common_obj),
        shimonoku_input(ShimonokuTyping, common->getConvertType()),
        typing_complete(false) {
    }

  public:
    static TypingState* getObject(CommonResources* common) {
      static TypingState obj(common);
      return &obj;
    }

    void setPracticeNum(size_t num) {
      practice_left = num;
    }

    void removeComponents(void) {
      shimonoku_input.removeComponents();
      common->voice_->stop();
    }

    void enter(Schedule* type) {

      // rݏグ̊Jn
      common->gui->update();
      // !!! XbhɂȂƁA`悪
      common->voice_->play(shimonoku_input.getCurrentWakaNo());

      typing_complete = false;
      shimonoku_input.updateWaka();

      common->input_receiver->clear();
    }

    void execute(Schedule* type) {

      // ̋A̋A͌`
      shimonoku_input.drawWaka();

      // ͊Aŝ҂
      common->input_receiver->updateInputEvent(input_event);
      if (typing_complete) {

        // s̓͂҂
        if (! InputEvent::isPressed(input_event, SDLK_RETURN)) {
          return;
        }

        typing_complete = false;
        if (practice_left <= 0) {
          // KAResultState ֑Jڂ
          type->changeState(ResultState::getObject(common));

          // rݏグ̒~
          common->voice_->stop();

        } else {
          // ēxAâ̓͂s
          shimonoku_input.setNextWaka();
          type->changeState(TypingState::getObject(common));
        }
        return;
      }

      // ̋̓͗
      if (! typing_complete) {
        shimonoku_input.drawInput();
      }

      // ͂玟̘â
      if (shimonoku_input.isComplete()) {
        --practice_left;
        shimonoku_input.removeInputComponents();
        typing_complete = true;

        // ʉ̍Đ
        common->playEffect(Decide);
      }
    }

    void exit(Schedule* type) {
      // zuR|[lg폜
      removeComponents();

      common->voice_->stop();
    }

    bool textEmpty(void) {
      return shimonoku_input.textEmpty();
    }
  };


  class ResultState : public State<Schedule> {
    CommonResources* common;
    ResultDrawer result_drawer;
    size_t first_ticks;

    ResultState(CommonResources* common_obj)
      : common(common_obj), result_drawer(ShimonokuTyping) {
      // !!!
    }

  public:
    static ResultState* getObject(CommonResources* common) {
      static ResultState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // ^CsOʂ̕]
      // !!! ۂ́A]ƃT[oւ̃f[^MAȂǂH

      // \p^C}[JE^̏
      result_drawer.createResult();
      first_ticks = GetTicks();
    }

    void execute(Schedule* type) {

      // ^CsO̕]\
      size_t ticks = GetTicks() - first_ticks;
      result_drawer.drawResult(ticks);

      // L[͂ȂǂŁAOt\
      if (result_drawer.keyPressed()) {
        type->changeState(WaitKeyState::
                          getObject(common, GraphState::getObject(common)));
      }
    }

    void exit(Schedule* type) {
    }

    void removeComponents(void) {
      result_drawer.removeComponents();
    }
  };

  class GraphState : public State<Schedule> {
    CommonResources* common;
    GraphDrawer graph_drawer;

    GraphState(CommonResources* common_obj)
      : common(common_obj), graph_drawer(ShimonokuTyping) {

      // Otp̏擾Agraph_drawer ɓn
      // !!!
    }

  public:
    static GraphState* getObject(CommonResources* common) {
      static GraphState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // ʕ\̍폜
      ResultState::getObject(common)->removeComponents();

      // Ot̕`
      if (graph_drawer.drawGraph() == false) {
        // !!! ̏Ԃɕ򂷂ׂ
        // !!! t@Cp[~bV܂ƂH
        return;
      }
      graph_drawer.placeComponents();
    }

    void execute(Schedule* type) {

      // L[͂ȂǂŁAI
      if (graph_drawer.keyPressed()) {
        type->changeState(FirstState::getObject(common));
      }
    }

    void exit(Schedule* type) {
    }

    void removeComponents(void) {
      graph_drawer.removeComponents();
    }
  };

  // !!! ̃NX́ÂƋʂɂȂ̂ŁA肽
  class WaitKeyState : public State<Schedule> {
    CommonResources* common;
    InputEvent input_event;
    State<Schedule>* next_state;

    WaitKeyState(CommonResources* common_obj, State<Schedule>* next_state_)
      : common(common_obj), next_state(next_state_) {
    }

  public:
    static WaitKeyState* getObject(CommonResources* common,
                                   State<Schedule>* next_state) {
      static WaitKeyState obj(common, next_state);
      return &obj;
    }

    void enter(Schedule* type) {
      common->input_receiver->clear();
    }

    void execute(Schedule* type) {
      common->input_receiver->updateInputEvent(input_event);
      if (InputEvent::isReleased(input_event, SDLK_RETURN)) {
        type->changeState(next_state);
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void removeComponents(void) {
    }
  };

  CommonResources* common;
  Schedule scheduler;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(0, common) {
    TypingState::getObject(common)->setPracticeNum(common->getPracticeNum());
  }

  void removeComponents(void) {
    PrologueState::getObject(common)->removeComponents();
    TypingState::getObject(common)->removeComponents();
    ResultState::getObject(common)->removeComponents();
    GraphState::getObject(common)->removeComponents();
    WaitKeyState::getObject(common, NULL)->removeComponents();
  }
};


ShimonokuPractice::ShimonokuPractice(void) : pimpl(new pImpl) {
}


ShimonokuPractice::~ShimonokuPractice(void) {
}


void ShimonokuPractice::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  bool escape_pressed = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    quit |= pimpl->scheduler.isTerminated();
    input.update_all();
    gui->update();
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    if (pImpl::TypingState::getObject(pimpl->common)->textEmpty()) {
      escape_pressed |= input.isPressed(SDLK_ESCAPE);
      if (escape_pressed && input.isReleased(SDLK_ESCAPE)) {
        quit |= true;
      }
    }
    delay(1);
  }

  // eR|[lg̍폜
  pimpl->removeComponents();
}
