/*!
  \file
  \brief ^CsOʂ̕\

  \author Satofumi KAMIMURA

  $Id$

  \todo ʂtF[hȂ\
*/

#include "ResultDrawer.h"
#include "ResultDrawer_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ResourceDefinition.h"
#include "CommonResources.h"
#include "AccessRecordPC.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "InputEvent.h"
#include "InputReceiveComponent.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "TextFadeSurface.h"
#include "LabelComponent.h"
#include "SdlUtils.h"
#include "Delay.h"
#include "UtfString.h"

using namespace beego;


struct ResultDrawer::pImpl {
  TypingMode typing_mode;
  CommonResources* common;
  bool is_decided;
  InputEvent input_event;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  std::vector<Surface> name_surfaces;
  std::vector<Component> name_labels;
  std::vector<Surface> num_surfaces;
  std::vector<Component> num_labels;
  std::vector<Surface> unit_surfaces;
  std::vector<Component> unit_labels;

  pImpl(TypingMode mode)
    : typing_mode(mode), common(CommonResources::getObject()),
      is_decided(false),
      title_property(common->font, ResultDrawer_title,
                     WakaDrawSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)) {
  }

  ~pImpl(void) {
    clearComponents();
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    for (std::vector<Component>::iterator it = name_labels.begin();
         it != name_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }
    for (std::vector<Component>::iterator it = num_labels.begin();
         it != num_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }
    for (std::vector<Component>::iterator it = unit_labels.begin();
         it != unit_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }

    is_decided = false;
    common->input_receiver->clear();
    common->front_layer->push_front(common->user_label);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    for (std::vector<Component>::iterator it = name_labels.begin();
         it != name_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }
    for (std::vector<Component>::iterator it = num_labels.begin();
         it != num_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }
    for (std::vector<Component>::iterator it = unit_labels.begin();
         it != unit_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }

    common->input_receiver->clear();
    common->front_layer->remove(common->user_label);
  }

  void clearComponents(void) {
    name_surfaces.clear();
    name_labels.clear();
    num_surfaces.clear();
    num_labels.clear();
    unit_surfaces.clear();
    unit_labels.clear();
  }

  void updateComponent(void) {

    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2), 480/6);
    title_label->setPosition(&position);

    // a̐
    TextProperty text_property(common->font, ResultDrawer_num,
                               MenuSize, Fore, Back, true);
    name_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    name_labels.push_back
      (static_cast<Component>(new LabelComponent(name_surfaces.back())));

    // 
    char buffer[13];
    int waka_num = static_cast<int>(common->recorder->getWakaNum());
    sprintf(buffer, "%d", waka_num);
    std::vector<Uint16> num_text;
    ustrcat(num_text, buffer);
    text_property.utext = &num_text[0];
    num_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    num_labels.push_back
      (static_cast<Component>(new LabelComponent(num_surfaces.back())));
    text_property.utext = ResultDrawer_syu;
    text_property.size = NormalSize;
    unit_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    unit_labels.push_back
      (static_cast<Component>(new LabelComponent(unit_surfaces.back())));

    if (typing_mode == ShimonokuTyping) {
      // ^Cvx
      text_property.utext = ResultDrawer_types;
      text_property.size = MenuSize;
      name_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      name_labels.push_back
        (static_cast<Component>(new LabelComponent(name_surfaces.back())));

      // /b
      num_text.clear();
      double typing_speed = common->recorder->getTypingSpeed();
      sprintf(buffer, "%.1f", typing_speed);
      ustrcat(num_text, buffer);
      text_property.utext = &num_text[0];
      num_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      num_labels.push_back
        (static_cast<Component>(new LabelComponent(num_surfaces.back())));
      text_property.utext = ResultDrawer_vel;
      text_property.size = NormalSize;
      unit_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      unit_labels.push_back
        (static_cast<Component>(new LabelComponent(unit_surfaces.back())));
    }

    // ͊Jn܂ł̎
    text_property.utext = ResultDrawer_delay;
    text_property.size = MenuSize;
    name_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    name_labels.push_back
      (static_cast<Component>(new LabelComponent(name_surfaces.back())));

    // b
    num_text.clear();
    double delay_sec = common->recorder->getStartDelay();
    sprintf(buffer, "%.2f", delay_sec);
    ustrcat(num_text, buffer);
    text_property.utext = &num_text[0];
    num_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    num_labels.push_back
      (static_cast<Component>(new LabelComponent(num_surfaces.back())));
    text_property.utext = ResultDrawer_sec;
    text_property.size = NormalSize;
    unit_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(text_property)));
    unit_labels.push_back
      (static_cast<Component>(new LabelComponent(unit_surfaces.back())));

    if (typing_mode == ShimonokuTyping) {
      // ^Cv
      text_property.utext = ResultDrawer_miss;
      text_property.size = MenuSize;
      name_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      name_labels.push_back
        (static_cast<Component>(new LabelComponent(name_surfaces.back())));

      // 
      num_text.clear();
      int miss_types = static_cast<int>(common->recorder->getMissTypes());
      sprintf(buffer, "%d", miss_types);
      ustrcat(num_text, buffer);
      text_property.utext = &num_text[0];
      num_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      num_labels.push_back
        (static_cast<Component>(new LabelComponent(num_surfaces.back())));
      text_property.utext = ResultDrawer_times;
      text_property.size = NormalSize;
      unit_surfaces.push_back
        (static_cast<Surface>(new TextFadeSurface(text_property)));
      unit_labels.push_back
        (static_cast<Component>(new LabelComponent(unit_surfaces.back())));
    }

    // ĉi̍ڈʒuɂ
    size_t unit_max_length = unit_labels.back()->getWidth();

    // R|[lg̈ʒuvZ
    position.y += ResultOffset - 10;
    SDL_Rect num_position;
    num_position.y = position.y;
    SDL_Rect unit_position;
    unit_position.y = position.y + (MenuSize - NormalSize);

    position.x = (640 - ResultWidth)/2;
    size_t num_pos_right = 640 - (640 - ResultWidth)/2 - unit_max_length;
    unit_position.x = static_cast<int>(num_pos_right);

    // ڂ̔zu
    for (std::vector<Component>::iterator it = name_labels.begin();
         it != name_labels.end(); ++it) {
      position.y += ResultOffset;
      (*it)->setPosition(&position);
    }

    // l̔zu
    for (std::vector<Component>::iterator it = num_labels.begin();
         it != num_labels.end(); ++it) {
      num_position.y += ResultOffset;
      num_position.x = rightPosition(*it, static_cast<int>(num_pos_right));
      (*it)->setPosition(&num_position);
    }

    // Pʂ̔zu
    for (std::vector<Component>::iterator it = unit_labels.begin();
         it != unit_labels.end(); ++it) {
      unit_position.y += ResultOffset;
      (*it)->setPosition(&unit_position);
    }
  }
};


ResultDrawer::ResultDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


ResultDrawer::~ResultDrawer(void) {
}


void ResultDrawer::createResult(void) {

  // \錋ʂ̌vZ
  const char* user_name = pimpl->common->getUserName();
  pimpl->common->recorder->evaluate(user_name);

  // L^̕ۑ
  AccessRecordPC pc_record(pimpl->typing_mode);
  TypingRecorder::GameSettings&
    record_data = pimpl->common->recorder->getRecordData();
  pc_record.save(record_data);

  // R|[lg̐
  pimpl->clearComponents();
  pimpl->updateComponent();

  // R|[lg̔zu
  // !!! ŔzuĂяốAȂ񂩕ςȋC邪A܂Â
  pimpl->placeComponents();

  // y̒~҂
  pimpl->common->stopMusic(3000);
}


void ResultDrawer::drawResult(size_t ticks) {
  // !!!
  // !!! ticks ɏ]āA`s
}


void ResultDrawer::placeComponents(void) {
  pimpl->placeComponents();
}


void ResultDrawer::removeComponents(void) {
  pimpl->removeComponents();

  // y̒~
  pimpl->common->haltMusic();
}


bool ResultDrawer::keyPressed(void) {

  pimpl->common->input_receiver->updateInputEvent(pimpl->input_event);
  pimpl->is_decided |= InputEvent::isReleased(pimpl->input_event, SDLK_RETURN);

  return pimpl->is_decided;
}
