#ifndef COMMON_RESOURCES_H
#define COMMON_RESOURCES_H

/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo oϐ̖𓝈ꂷ
*/

#include "TypingTextConverter.h"
#include "Component.h"
#include <string>


namespace beego {
  class GuiManager;
  class Layer;
  class TtfResource;
  class InputHandler;
  class InputReceiveComponent;
  class ConsolePanelComponent;
};
class TypingRecorder;
class AccessSettings;
class VoicePlayer;


/*!
  \brief ʃ\[XǗ
*/
class CommonResources {
  CommonResources(void);
  CommonResources(const char* savedir);
  CommonResources(const CommonResources& rhs);
  CommonResources& operator = (const CommonResources& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

 public:
  //////////////////////////////////////////////////////////////////////
  // GUI 
  beego::GuiManager* gui;       //!< GUI Ǘ
  beego::Layer* front_layer;    //!< OiC[
  beego::Layer* back_layer;     //!< wiC[
  boost::shared_ptr<beego::ConsolePanelComponent> debug; //!< fobO\p

  beego::Component back_label;  //!< wi摜
  beego::TtfResource* font;     //!< tHg\[X
  beego::Component menu_icon;   //!< j[ACR
  beego::Component user_label;  //!< [U

  beego::InputHandler* input;   //!< ̓nh
  boost::shared_ptr<beego::InputReceiveComponent> input_receiver; //!< ͎M

  //////////////////////////////////////////////////////////////////////
  // VXe
  TypingRecorder* recorder;     //!< ^CsŐL^
  std::vector<int> waka_order;  //!< â̕

  VoicePlayer* voice_;           //!< rݏグ

  //////////////////////////////////////////////////////////////////////
  // ݒ
  std::string savedir_;            //!< f[^̕ۑfBNg
  AccessSettings* settings;        //!< ݒ

  ~CommonResources(void);

  /*!
    \brief ʃ\[Xւ̊ǗIuWFNgԂ
  */
  static CommonResources* getObject(const char* savedir = NULL);

  /*!
    \brief GUI \[X̏

    \attention XN[ĂĂяoȂ΂ȂȂ
  */
  void initializeGui(void);

  /*!
    \brief tHgf[^邩Ԃ

    \retval true tHgf[^
    \retval false tHgf[^Ȃ
  */
  static bool accessFontData(void);

  /*!
    \brief yf[^邩Ԃ

    \retval true yf[^
    \retval false yf[^Ȃ
  */
  static bool accessMusicData(void);

  /*!
    \brief y̏
  */
  void initializeMusic(void);

  /*!
    \brief ݂̃[U̎擾
  */
  const char* getUserName(void) const;

  /*!
    \brief [U̍폜

    \brief user_name [i] ǉ[U
  */
  void addUser(const char* user_name, const char* password);

  /*!
    \brief w胆[U̍폜

    \brief user_name [i] 폜[Uԍ
  */
  void deleteUser(int  user_index);

  void updateUserLable(void);

  TypingTextConverter::ConvertType getConvertType(void);

  int getPracticeNum(void);

  int getPracticeNumIndex(void);
  void setPracticeNumIndex(size_t index);

  void setNextMusic(int id);
  bool nowSoundPlaying(void);
  void stopMusic(int fadeout_msec = 0);
  void haltMusic(void);
  void updateSoundVolume(int percent);

  void playEffect(int id);
  bool nowEffectPlaying(void);
  void stopEffect(void);
  void updateEffectVolume(int percent);
};

#endif /* !COMMON_RESOURCES_H */
