#ifndef WAKA_DATA_H
#define WAKA_DATA_H

/*!
  \file
  \brief Slf[^()

  \author Satofumi KAMIMURA

  $Id$
*/

#include <SDL.h>


const static Uint16 YomibitoName[][2][29] = {
  // VqVc
  { { 0x5929, 0x667a, 0x5929, 0x7687, 0x0 },
    { 0x3066, 0x3093, 0x3058, 0x3066, 0x3093, 0x306e, 0x3046, 0x0 } },

  // Vc
  { { 0x6301, 0x7d71, 0x5929, 0x7687, 0x0 },
    { 0x3058, 0x3068, 0x3046, 0x3066, 0x3093, 0x306e, 0x3046, 0x0 } },

  // `{lC
  { { 0x67ff, 0x672c, 0x4eba, 0x9ebb, 0x5442, 0x0 },
    { 0x304b, 0x304d, 0x306e, 0x3082, 0x3068, 0x306e, 0x3072, 0x3068, 0x307e, 0x308d, 0x0 } },

  // RԐl
  { { 0x5c71, 0x90e8, 0x8d64, 0x4eba, 0x0 },
    { 0x3084, 0x307e, 0x3079, 0x306e, 0x3042, 0x304b, 0x3072, 0x3068, 0x0 } },

  // ۑv
  { { 0x733f, 0x4e38, 0x5927, 0x592b, 0x0 },
    { 0x3055, 0x308b, 0x307e, 0x308b, 0x3060, 0x3086, 0x3046, 0x0 } },

  // [Ǝ
  { { 0x4e2d, 0x7d0d, 0x8a00, 0x5bb6, 0x6301, 0x0 },
    { 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3084, 0x304b, 0x3082, 0x3061, 0x0 } },

  // {
  { { 0x5b89, 0x500d, 0x4ef2, 0x9ebf, 0x0 },
    { 0x3042, 0x3079, 0x306e, 0x306a, 0x304b, 0x307e, 0x308d, 0x0 } },

  // @t
  { { 0x559c, 0x64b0, 0x6cd5, 0x5e2b, 0x0 },
    { 0x304d, 0x305b, 0x3093, 0x307b, 0x3046, 0x3057, 0x0 } },

  // 쏬
  { { 0x5c0f, 0x91ce, 0x5c0f, 0x753a, 0x0 },
    { 0x304a, 0x306e, 0x306e, 0x3053, 0x307e, 0x3061, 0x0 } },

  // 
  { { 0x8749, 0x4e38, 0x0 },
    { 0x305b, 0x307f, 0x307e, 0x308b, 0x0 } },

  // Qc
  { { 0x53c2, 0x8b70, 0x7bc1, 0x0 },
    { 0x3055, 0x3093, 0x304e, 0x305f, 0x304b, 0x3080, 0x3089, 0x0 } },

  // mՏ
  { { 0x50e7, 0x6b63, 0x904d, 0x662d, 0x0 },
    { 0x305d, 0x3046, 0x3058, 0x3087, 0x3046, 0x3078, 0x3093, 0x3058, 0x3087, 0x3046, 0x0 } },

  // z@
  { { 0x967d, 0x6210, 0x9662, 0x0 },
    { 0x3088, 0x3046, 0x305c, 0x3044, 0x3044, 0x3093, 0x0 } },

  // ͌b
  { { 0x6cb3, 0x539f, 0x5de6, 0x5927, 0x81e3, 0x0 },
    { 0x304b, 0x308f, 0x3089, 0x306e, 0x3055, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // FVc
  { { 0x5149, 0x5b5d, 0x5929, 0x7687, 0x0 },
    { 0x3053, 0x3046, 0x3053, 0x3046, 0x3066, 0x3093, 0x306e, 0x3046, 0x0 } },

  // [s
  { { 0x4e2d, 0x7d0d, 0x8a00, 0x884c, 0x5e73, 0x0 },
    { 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3086, 0x304d, 0x3072, 0x3089, 0x0 } },

  // ݌ƕb
  { { 0x5728, 0x539f, 0x696d, 0x5e73, 0x671d, 0x81e3, 0x0 },
    { 0x3042, 0x308a, 0x308f, 0x3089, 0x306e, 0x306a, 0x308a, 0x3072, 0x3089, 0x3042, 0x305d, 0x3093, 0x0 } },

  // qsb
  { { 0x85e4, 0x539f, 0x654f, 0x884c, 0x671d, 0x81e3, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x3068, 0x3057, 0x3086, 0x304d, 0x3042, 0x305d, 0x3093, 0x0 } },

  // ɐ
  { { 0x4f0a, 0x52e2, 0x0 },
    { 0x3044, 0x305b, 0x0 } },

  // ǐe
  { { 0x5143, 0x826f, 0x89aa, 0x738b, 0x0 },
    { 0x3082, 0x3068, 0x3088, 0x3057, 0x3057, 0x3093, 0x306e, 0x3046, 0x0 } },

  // f@t
  { { 0x7d20, 0x6027, 0x6cd5, 0x5e2b, 0x0 },
    { 0x305d, 0x305b, 0x3044, 0x307b, 0x3046, 0x3057, 0x0 } },

  // NG
  { { 0x6587, 0x5c4b, 0x5eb7, 0x79c0, 0x0 },
    { 0x3075, 0x3093, 0x3084, 0x306e, 0x3084, 0x3059, 0x3072, 0x3067, 0x0 } },

  // ]痢
  { { 0x5927, 0x6c5f, 0x5343, 0x91cc, 0x0 },
    { 0x304a, 0x304a, 0x3048, 0x306e, 0x3061, 0x3055, 0x3068, 0x0 } },

  // ǉ
  { { 0x7ba1, 0x5bb6, 0x0 },
    { 0x304b, 0x3093, 0x3051, 0x0 } },

  // OEb
  { { 0x4e09, 0x6761, 0x53f3, 0x5927, 0x81e3, 0x0 },
    { 0x3055, 0x3093, 0x3058, 0x3087, 0x3046, 0x306e, 0x3046, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // M
  { { 0x8c9e, 0x4fe1, 0x516c, 0x0 },
    { 0x3066, 0x3044, 0x3057, 0x3093, 0x3053, 0x3046, 0x0 } },

  // [
  { { 0x4e2d, 0x7d0d, 0x8a00, 0x517c, 0x8f14, 0x0 },
    { 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x304b, 0x306d, 0x3059, 0x3051, 0x0 } },

  // @b
  { { 0x6e90, 0x5b97, 0x4e8e, 0x671d, 0x81e3, 0x0 },
    { 0x307f, 0x306a, 0x3082, 0x3068, 0x306e, 0x3080, 0x306d, 0x3086, 0x304d, 0x3042, 0x305d, 0x3093, 0x0 } },

  // }͓ZP
  { { 0x51e1, 0x6cb3, 0x5185, 0x8eac, 0x6052, 0x0 },
    { 0x304a, 0x304a, 0x3057, 0x3053, 0x3046, 0x3061, 0x306e, 0x307f, 0x3064, 0x306d, 0x0 } },

  // p
  { { 0x58ec, 0x751f, 0x5fe0, 0x5c91, 0x0 },
    { 0x307f, 0x3076, 0x306e, 0x305f, 0x3060, 0x307f, 0x306d, 0x0 } },

  // 㐥
  { { 0x5742, 0x4e0a, 0x662f, 0x5247, 0x0 },
    { 0x3055, 0x304b, 0x306e, 0x3046, 0x3048, 0x306e, 0x3053, 0x308c, 0x306e, 0x308a, 0x0 } },

  // t
  { { 0x6625, 0x9053, 0x5217, 0x6a39, 0x0 },
    { 0x306f, 0x308b, 0x307f, 0x3061, 0x306e, 0x3064, 0x3089, 0x304d, 0x0 } },

  // IF
  { { 0x7d00, 0x53cb, 0x5247, 0x0 },
    { 0x304d, 0x306e, 0x3068, 0x3082, 0x306e, 0x308a, 0x0 } },

  // 
  { { 0x85e4, 0x539f, 0x8208, 0x98a8, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x304a, 0x304d, 0x304b, 0x305c, 0x0 } },

  // IєV
  { { 0x7d00, 0x8cab, 0x4e4b, 0x0 },
    { 0x304d, 0x306e, 0x3064, 0x3089, 0x3086, 0x304d, 0x0 } },

  // [{
  { { 0x6e05, 0x539f, 0x6df1, 0x990a, 0x7236, 0x0 },
    { 0x304d, 0x3088, 0x306f, 0x3089, 0x306e, 0x3075, 0x304b, 0x3084, 0x3076, 0x0 } },

  // N
  { { 0x6587, 0x5c4b, 0x671d, 0x5eb7, 0x0 },
    { 0x3075, 0x3093, 0x3084, 0x306e, 0x3042, 0x3055, 0x3084, 0x3059, 0x0 } },

  // E
  { { 0x53f3, 0x8fd1, 0x0 },
    { 0x3046, 0x3053, 0x3093, 0x0 } },

  // Qc
  { { 0x53c2, 0x8b70, 0x7b49, 0x0 },
    { 0x3055, 0x3093, 0x304e, 0x3072, 0x3068, 0x3057, 0x0 } },

  // 
  { { 0x5e73, 0x517c, 0x76db, 0x0 },
    { 0x305f, 0x3044, 0x3089, 0x306e, 0x304b, 0x306d, 0x3082, 0x308a, 0x0 } },

  // p
  { { 0x58ec, 0x751f, 0x5fe0, 0x898b, 0x0 },
    { 0x307f, 0x3076, 0x306e, 0x305f, 0x3060, 0x307f, 0x0 } },

  // 
  { { 0x6e05, 0x539f, 0x5143, 0x8f14, 0x0 },
    { 0x304d, 0x3088, 0x306f, 0x3089, 0x306e, 0x3082, 0x3068, 0x3059, 0x3051, 0x0 } },

  // [֒
  { { 0x6a29, 0x4e2d, 0x7d0d, 0x8a00, 0x6566, 0x5fe0, 0x0 },
    { 0x3054, 0x3093, 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3042, 0x3064, 0x305f, 0x3060, 0x0 } },

  // [
  { { 0x4e2d, 0x7d0d, 0x8a00, 0x671d, 0x5fe0, 0x0 },
    { 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3042, 0x3055, 0x305f, 0x3060, 0x0 } },

  // 
  { { 0x8b19, 0x5fb3, 0x516c, 0x0 },
    { 0x3051, 0x3093, 0x3068, 0x304f, 0x3053, 0x3046, 0x0 } },

  // ]HD
  { { 0x66fd, 0x79b0, 0x597d, 0x5fe0, 0x0 },
    { 0x305d, 0x306d, 0x306e, 0x3088, 0x3057, 0x305f, 0x3060, 0x0 } },

  // bc@t
  { { 0x6075, 0x6176, 0x6cd5, 0x5e2b, 0x0 },
    { 0x3048, 0x304e, 0x3087, 0x3046, 0x307b, 0x3046, 0x3057, 0x0 } },

  // dV
  { { 0x6e90, 0x91cd, 0x4e4b, 0x0 },
    { 0x307f, 0x306a, 0x3082, 0x3068, 0x306e, 0x3057, 0x3052, 0x3086, 0x304d, 0x0 } },

  // 咆b\钩b
  { { 0x5927, 0x4e2d, 0x81e3, 0x80fd, 0x5ba3, 0x671d, 0x81e3, 0x0 },
    { 0x304a, 0x304a, 0x306a, 0x304b, 0x3068, 0x307f, 0x306e, 0x3088, 0x3057, 0x306e, 0x3076, 0x3042, 0x305d, 0x3093, 0x0 } },

  // `F
  { { 0x85e4, 0x539f, 0x7fa9, 0x5b5d, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x3088, 0x3057, 0x305f, 0x304b, 0x0 } },

  // b
  { { 0x85e4, 0x539f, 0x5b9f, 0x65b9, 0x671d, 0x81e3, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x3055, 0x306d, 0x304b, 0x305f, 0x3042, 0x305d, 0x3093, 0x0 } },

  // Mb
  { { 0x85e4, 0x539f, 0x9053, 0x4fe1, 0x671d, 0x81e3, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x307f, 0x3061, 0x306e, 0x3076, 0x3042, 0x305d, 0x3093, 0x0 } },

  // E叫j
  { { 0x53f3, 0x5927, 0x5c06, 0x9053, 0x7db1, 0x6bcd, 0x0 },
    { 0x3046, 0x3060, 0x3044, 0x3057, 0x3087, 0x3046, 0x307f, 0x3061, 0x3064, 0x306a, 0x306e, 0x306f, 0x306f, 0x0 } },

  // VOi
  { { 0x5100, 0x540c, 0x4e09, 0x53f8, 0x6bcd, 0x0 },
    { 0x304e, 0x3069, 0x3046, 0x3055, 0x3093, 0x3057, 0x306e, 0x306f, 0x306f, 0x0 } },

  // [C
  { { 0x5927, 0x7d0d, 0x8a00, 0x516c, 0x4efb, 0x0 },
    { 0x3060, 0x3044, 0x306a, 0x3054, 0x3093, 0x304d, 0x3093, 0x3068, 0x3046, 0x0 } },

  // a򎮕
  { { 0x548c, 0x6cc9, 0x5f0f, 0x90e8, 0x0 },
    { 0x3044, 0x305a, 0x307f, 0x3057, 0x304d, 0x3076, 0x0 } },

  // 
  { { 0x7d2b, 0x5f0f, 0x90e8, 0x0 },
    { 0x3080, 0x3089, 0x3055, 0x304d, 0x3057, 0x304d, 0x3076, 0x0 } },

  // O
  { { 0x5927, 0x5f10, 0x4e09, 0x4f4d, 0x0 },
    { 0x3060, 0x3044, 0x306b, 0x306e, 0x3055, 0x3093, 0x307f, 0x0 } },

  // Ԑq
  { { 0x8d64, 0x67d3, 0x885b, 0x9580, 0x0 },
    { 0x3042, 0x304b, 0x305e, 0x3081, 0x3048, 0x3082, 0x3093, 0x0 } },

  // 
  { { 0x5c0f, 0x5f0f, 0x90e8, 0x5185, 0x4f8d, 0x0 },
    { 0x3053, 0x3057, 0x304d, 0x3076, 0x306e, 0x306a, 0x3044, 0x3057, 0x0 } },

  // ɐ
  { { 0x4f0a, 0x52e2, 0x5927, 0x8f14, 0x0 },
    { 0x3044, 0x305b, 0x306e, 0x305f, 0x3044, 0x3075, 0x0 } },

  // [
  { { 0x6e05, 0x5c11, 0x7d0d, 0x8a00, 0x0 },
    { 0x305b, 0x3044, 0x3057, 0x3087, 0x3046, 0x306a, 0x3054, 0x3093, 0x0 } },

  // v
  { { 0x5de6, 0x4eac, 0x5927, 0x592b, 0x9053, 0x96c5, 0x0 },
    { 0x3055, 0x304d, 0x3087, 0x3046, 0x306e, 0x3060, 0x3044, 0x3075, 0x307f, 0x3061, 0x307e, 0x3055, 0x0 } },

  // [藊
  { { 0x6a29, 0x4e2d, 0x7d0d, 0x8a00, 0x5b9a, 0x983c, 0x0 },
    { 0x3054, 0x3093, 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3055, 0x3060, 0x3088, 0x308a, 0x0 } },

  // 
  { { 0x76f8, 0x6a21, 0x0 },
    { 0x3055, 0x304c, 0x307f, 0x0 } },

  // Oms
  { { 0x524d, 0x5927, 0x50e7, 0x6b63, 0x884c, 0x5c0a, 0x0 },
    { 0x305c, 0x3093, 0x3060, 0x3044, 0x305d, 0x3046, 0x3058, 0x3087, 0x3046, 0x304e, 0x3087, 0x3046, 0x305d, 0x3093, 0x0 } },

  // h
  { { 0x5468, 0x9632, 0x5185, 0x4f8d, 0x0 },
    { 0x3059, 0x304a, 0x3046, 0x306e, 0x306a, 0x3044, 0x3057, 0x0 } },

  // O@
  { { 0x4e09, 0x6761, 0x9662, 0x0 },
    { 0x3055, 0x3093, 0x3058, 0x3087, 0x3046, 0x3044, 0x3093, 0x0 } },

  // \@t
  { { 0x80fd, 0x56e0, 0x6cd5, 0x5e2b, 0x0 },
    { 0x306e, 0x3046, 0x3044, 0x3093, 0x307b, 0x3046, 0x3057, 0x0 } },

  // ǝ@t
  { { 0x826f, 0x66b9, 0x6cd5, 0x5e2b, 0x0 },
    { 0x308a, 0x3087, 0x3046, 0x305c, 0x3093, 0x307b, 0x3046, 0x3057, 0x0 } },

  // [oM
  { { 0x5927, 0x7d0d, 0x8a00, 0x7d4c, 0x4fe1, 0x0 },
    { 0x3060, 0x3044, 0x306a, 0x3054, 0x3093, 0x3064, 0x306d, 0x306e, 0x3076, 0x0 } },

  // SqeƋI
  { { 0x7950, 0x5b50, 0x5185, 0x89aa, 0x738b, 0x5bb6, 0x7d00, 0x4f0a, 0x0 },
    { 0x3086, 0x3046, 0x3057, 0x306a, 0x3044, 0x3057, 0x3093, 0x306e, 0x3046, 0x3051, 0x306e, 0x304d, 0x3044, 0x0 } },

  // [[
  { { 0x6a29, 0x4e2d, 0x7d0d, 0x8a00, 0x5321, 0x623f, 0x0 },
    { 0x3054, 0x3093, 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x307e, 0x3055, 0x3075, 0x3055, 0x0 } },

  // rb
  { { 0x6e90, 0x4fca, 0x983c, 0x671d, 0x81e3, 0x0 },
    { 0x307f, 0x306a, 0x3082, 0x3068, 0x306e, 0x3068, 0x3057, 0x3088, 0x308a, 0x3042, 0x305d, 0x3093, 0x0 } },

  // r
  { { 0x85e4, 0x539f, 0x57fa, 0x4fca, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x3082, 0x3068, 0x3068, 0x3057, 0x0 } },

  // @O֔b
  { { 0x6cd5, 0x6027, 0x5bfa, 0x5165, 0x9053, 0x524d, 0x95a2, 0x767d, 0x592a, 0x653f, 0x5927, 0x81e3, 0x0 },
    { 0x307b, 0x3046, 0x3057, 0x3087, 0x3046, 0x3058, 0x306e, 0x306b, 0x3085, 0x3046, 0x3069, 0x3046, 0x3055, 0x304d, 0x306e, 0x304b, 0x3093, 0x3071, 0x304f, 0x3060, 0x3044, 0x3058, 0x3087, 0x3046, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // @
  { { 0x5d07, 0x5fb3, 0x9662, 0x0 },
    { 0x3059, 0x3068, 0x304f, 0x3044, 0x3093, 0x0 } },

  // 
  { { 0x6e90, 0x517c, 0x660c, 0x0 },
    { 0x307f, 0x306a, 0x3082, 0x3068, 0x306e, 0x304b, 0x306d, 0x307e, 0x3055, 0x0 } },

  // v
  { { 0x5de6, 0x4eac, 0x5927, 0x592b, 0x9855, 0x8f14, 0x0 },
    { 0x3055, 0x304d, 0x3087, 0x3046, 0x306e, 0x3060, 0x3044, 0x3076, 0x3042, 0x304d, 0x3059, 0x3051, 0x0 } },

  // Ҍ@x
  { { 0x5f85, 0x8ce2, 0x9580, 0x9662, 0x5800, 0x5ddd, 0x0 },
    { 0x305f, 0x3044, 0x3051, 0x3093, 0x3082, 0x3093, 0x3044, 0x3093, 0x306e, 0x307b, 0x308a, 0x304b, 0x308f, 0x0 } },

  // 㓿厛b
  { { 0x5f8c, 0x5fb3, 0x5927, 0x5bfa, 0x5de6, 0x5927, 0x81e3, 0x0 },
    { 0x3054, 0x3068, 0x304f, 0x3060, 0x3044, 0x3058, 0x306e, 0x3055, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // @t
  { { 0x9053, 0x56e0, 0x6cd5, 0x5e2b, 0x0 },
    { 0x3069, 0x3046, 0x3044, 0x3093, 0x307b, 0x3046, 0x3057, 0x0 } },

  // c@{vr
  { { 0x7687, 0x592a, 0x540e, 0x5bae, 0x5927, 0x592b, 0x4fca, 0x6210, 0x0 },
    { 0x3053, 0x3046, 0x305f, 0x3044, 0x3054, 0x3046, 0x3050, 0x3046, 0x306e, 0x3060, 0x3044, 0x3076, 0x3057, 0x3085, 0x3093, 0x305c, 0x3044, 0x0 } },

  // 㒩b
  { { 0x85e4, 0x539f, 0x6e05, 0x8f14, 0x671d, 0x81e3, 0x0 },
    { 0x3075, 0x3058, 0x308f, 0x3089, 0x306e, 0x304d, 0x3088, 0x3059, 0x3051, 0x3042, 0x305d, 0x3093, 0x0 } },

  // rb@t
  { { 0x4fca, 0x6075, 0x6cd5, 0x5e2b, 0x0 },
    { 0x3086, 0x3093, 0x3048, 0x307b, 0x3046, 0x3057, 0x0 } },

  // s@t
  { { 0x897f, 0x884c, 0x6cd5, 0x5e2b, 0x0 },
    { 0x3055, 0x3044, 0x304e, 0x3087, 0x3046, 0x307b, 0x3046, 0x3057, 0x0 } },

  // @@t
  { { 0x5bc2, 0x84ee, 0x6cd5, 0x5e2b, 0x0 },
    { 0x3058, 0x3083, 0x304f, 0x308c, 0x3093, 0x307b, 0x3046, 0x3057, 0x0 } },

  // cÖ@ʓ
  { { 0x7687, 0x5609, 0x9580, 0x9662, 0x5225, 0x5f53, 0x0 },
    { 0x3053, 0x3046, 0x304b, 0x3082, 0x3093, 0x3044, 0x3093, 0x3079, 0x3063, 0x3068, 0x3046, 0x0 } },

  // qe
  { { 0x5f0f, 0x5b50, 0x5185, 0x89aa, 0x738b, 0x0 },
    { 0x3057, 0x304d, 0x3057, 0x306a, 0x3044, 0x3057, 0x3093, 0x306e, 0x3046, 0x0 } },

  // ux@
  { { 0x6bb7, 0x5bcc, 0x9580, 0x9662, 0x5927, 0x8f14, 0x0 },
    { 0x3044, 0x3093, 0x3077, 0x3082, 0x3093, 0x3044, 0x3093, 0x306e, 0x305f, 0x3044, 0x3075, 0x0 } },

  // ㋞ɐېOb
  { { 0x5f8c, 0x4eac, 0x6975, 0x6442, 0x653f, 0x524d, 0x592a, 0x653f, 0x5927, 0x81e3, 0x0 },
    { 0x3054, 0x304d, 0x3087, 0x3046, 0x3054, 0x304f, 0x305b, 0x3063, 0x3057, 0x3087, 0x3046, 0x3055, 0x304d, 0x306e, 0x3060, 0x3044, 0x3058, 0x3087, 0x3046, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // @]
  { { 0x4e8c, 0x6761, 0x9662, 0x8b83, 0x5c90, 0x0 },
    { 0x306b, 0x3058, 0x3087, 0x3046, 0x3044, 0x3093, 0x306e, 0x3055, 0x306c, 0x304d, 0x0 } },

  // qEb
  { { 0x938c, 0x5009, 0x53f3, 0x5927, 0x81e3, 0x0 },
    { 0x304b, 0x307e, 0x304f, 0x3089, 0x306e, 0x3046, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // Qco
  { { 0x53c2, 0x8b70, 0x96c5, 0x7d4c, 0x0 },
    { 0x3055, 0x3093, 0x304e, 0x307e, 0x3055, 0x3064, 0x306d, 0x0 } },

  // Om~
  { { 0x524d, 0x5927, 0x50e7, 0x6b63, 0x6148, 0x5186, 0x0 },
    { 0x3055, 0x304d, 0x306e, 0x3060, 0x3044, 0x305d, 0x3046, 0x3058, 0x3087, 0x3046, 0x3058, 0x3048, 0x3093, 0x0 } },

  // O吭b
  { { 0x5165, 0x9053, 0x524d, 0x5927, 0x653f, 0x5927, 0x81e3, 0x0 },
    { 0x306b, 0x3085, 0x3046, 0x3069, 0x3046, 0x3055, 0x304d, 0x306e, 0x3060, 0x3044, 0x3058, 0x3087, 0x3046, 0x3060, 0x3044, 0x3058, 0x3093, 0x0 } },

  // [
  { { 0x6a29, 0x4e2d, 0x7d0d, 0x8a00, 0x5b9a, 0x5bb6, 0x0 },
    { 0x3054, 0x3093, 0x3061, 0x3085, 0x3046, 0x306a, 0x3054, 0x3093, 0x3066, 0x3044, 0x304b, 0x0 } },

  // ]ʉƗ
  { { 0x5f93, 0x4e8c, 0x4f4d, 0x5bb6, 0x9686, 0x0 },
    { 0x3058, 0x3085, 0x3046, 0x306b, 0x3044, 0x3044, 0x3048, 0x305f, 0x304b, 0x0 } },

  // 㒹H@
  { { 0x5f8c, 0x9ce5, 0x7fbd, 0x9662, 0x0 },
    { 0x3054, 0x3068, 0x3070, 0x3044, 0x3093, 0x0 } },

  // @
  { { 0x9806, 0x5fb3, 0x9662, 0x0 },
    { 0x3058, 0x3085, 0x3093, 0x3068, 0x304f, 0x3044, 0x3093, 0x0 } },
};

const static Uint16 KanjiWaka[][5][9] = {
  { // 1 H̓c...
    {0x79cb, 0x306e, 0x7530, 0x306e, 0x0 },
    {0x304b, 0x308a, 0x307b, 0x306e, 0x5eb5, 0x306e, 0x0 },
    {0x82eb, 0x3092, 0x3042, 0x3089, 0x307f, 0x0 },
    {0x308f, 0x304c, 0x8863, 0x624b, 0x306f, 0x0 },
    {0x9732, 0x306b, 0x306c, 0x308c, 0x3064, 0x3064, 0x0 },
  },
  { // 2 t߂...
    {0x6625, 0x904e, 0x304e, 0x3066, 0x0 },
    {0x590f, 0x6765, 0x306b, 0x3051, 0x3089, 0x3057, 0x0 },
    {0x767d, 0x5999, 0x306e, 0x0 },
    {0x8863, 0x307b, 0x3059, 0x3066, 0x3075, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x304b, 0x3050, 0x5c71, 0x0 },
  },
  { // 3 g...
    {0x3042, 0x3057, 0x66f3, 0x306e, 0x0 },
    {0x5c71, 0x3069, 0x308a, 0x306e, 0x5c3e, 0x306e, 0x0 },
    {0x3057, 0x3060, 0x308a, 0x3092, 0x306e, 0x0 },
    {0x306a, 0x304c, 0x306a, 0x304c, 0x3057, 0x591c, 0x3092, 0x0 },
    {0x72ec, 0x308a, 0x304b, 0x3082, 0x306d, 0x3080, 0x0 },
  },
  { // 4 cq̂...
    {0x7530, 0x5b50, 0x306e, 0x3046, 0x3089, 0x306b, 0x0 },
    {0x3046, 0x3061, 0x51fa, 0x3067, 0x3066, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x767d, 0x5999, 0x306e, 0x0 },
    {0x3075, 0x3058, 0x306e, 0x9ad8, 0x306d, 0x306b, 0x0 },
    {0x96ea, 0x306f, 0x3075, 0x308a, 0x3064, 0x3064, 0x0 },
  },
  { // 5 R...
    {0x304a, 0x304f, 0x5c71, 0x306b, 0x0 },
    {0x7d05, 0x8449, 0x3075, 0x307f, 0x5206, 0x3051, 0x0 },
    {0x306a, 0x304f, 0x9e7f, 0x306e, 0x0 },
    {0x3053, 0x3091, 0x805e, 0x304f, 0x3068, 0x304d, 0x305e, 0x0 },
    {0x79cb, 0x306f, 0x304b, 0x306a, 0x3057, 0x304d, 0x0 },
  },
  { // 6 F...
    {0x9d72, 0x306e, 0x0 },
    {0x308f, 0x305f, 0x305b, 0x308b, 0x6a4b, 0x306b, 0x0 },
    {0x304a, 0x304f, 0x3057, 0x3082, 0x306e, 0x0 },
    {0x3057, 0x308d, 0x304d, 0x3092, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x591c, 0x305e, 0x66f4, 0x3051, 0x306b, 0x3051, 0x308b, 0x0 },
  },
  { // 7 V̌...
    {0x5929, 0x306e, 0x539f, 0x0 },
    {0x3075, 0x308a, 0x3055, 0x3051, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x304b, 0x3059, 0x304c, 0x306a, 0x308b, 0x0 },
    {0x4e09, 0x7b20, 0x306e, 0x5c71, 0x306b, 0x0 },
    {0x51fa, 0x3067, 0x3057, 0x6708, 0x304b, 0x3082, 0x0 },
  },
  { // 8 ...
    {0x6211, 0x5eb5, 0x306f, 0x0 },
    {0x90fd, 0x306e, 0x305f, 0x3064, 0x307f, 0x0 },
    {0x3057, 0x304b, 0x305e, 0x3059, 0x3080, 0x0 },
    {0x4e16, 0x3092, 0x5b87, 0x6cbb, 0x5c71, 0x3068, 0x0 },
    {0x4eba, 0x306f, 0x3044, 0x3075, 0x306a, 0x308a, 0x0 },
  },
  { // 9 Ԃ̐F...
    {0x82b1, 0x306e, 0x8272, 0x306f, 0x0 },
    {0x3046, 0x3064, 0x308a, 0x306b, 0x3051, 0x308a, 0x306a, 0x0 },
    {0x3044, 0x305f, 0x3065, 0x3089, 0x306b, 0x0 },
    {0x6211, 0x8eab, 0x4e16, 0x306b, 0x3075, 0x308b, 0x0 },
    {0x306a, 0x304c, 0x3081, 0x305b, 0x3057, 0x307e, 0x306b, 0x0 },
  },
  { // 10 ⍟...
    {0x3053, 0x308c, 0x3084, 0x6b64, 0x0 },
    {0x3086, 0x304f, 0x3082, 0x5e30, 0x308b, 0x3082, 0x0 },
    {0x5225, 0x308c, 0x3066, 0x306f, 0x0 },
    {0x3057, 0x308b, 0x3082, 0x3057, 0x3089, 0x306c, 0x3082, 0x0 },
    {0x3042, 0x3075, 0x5742, 0x306e, 0x95a2, 0x0 },
  },
  { // 11 킽̌...
    {0x308f, 0x305f, 0x306e, 0x539f, 0x0 },
    {0x516b, 0x5341, 0x5cf6, 0x304b, 0x3051, 0x3066, 0x0 },
    {0x6f15, 0x304e, 0x51fa, 0x3067, 0x306c, 0x3068, 0x0 },
    {0x4eba, 0x306b, 0x306f, 0x3064, 0x3052, 0x3088, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x91e3, 0x821f, 0x0 },
  },
  { // 12 V...
    {0x5929, 0x3064, 0x304b, 0x305c, 0x0 },
    {0x96f2, 0x306e, 0x901a, 0x8def, 0x0 },
    {0x5439, 0x304d, 0x3068, 0x3062, 0x3088, 0x0 },
    {0x3092, 0x3068, 0x3081, 0x306e, 0x3059, 0x304c, 0x305f, 0x0 },
    {0x3057, 0x3070, 0x3057, 0x3068, 0x3069, 0x3081, 0x3080, 0x0 },
  },
  { // 13 ΂˂...
    {0x3064, 0x304f, 0x3070, 0x306d, 0x306e, 0x0 },
    {0x5dba, 0x3088, 0x308a, 0x304a, 0x3064, 0x308b, 0x0 },
    {0x307f, 0x306a, 0x306e, 0x5ddd, 0x0 },
    {0x3053, 0x3072, 0x305e, 0x3064, 0x3082, 0x308a, 0x3066, 0x0 },
    {0x6df5, 0x3068, 0x306a, 0x308a, 0x306c, 0x308b, 0x0 },
  },
  { // 14 ݂̂...
    {0x307f, 0x3061, 0x306e, 0x304f, 0x306e, 0x0 },
    {0x5fcd, 0x3076, 0x3082, 0x3062, 0x305a, 0x308a, 0x0 },
    {0x305f, 0x308c, 0x3086, 0x3091, 0x306b, 0x0 },
    {0x4e71, 0x308c, 0x521d, 0x3081, 0x306b, 0x3057, 0x0 },
    {0x6211, 0x306a, 0x3089, 0x306a, 0x304f, 0x306b, 0x0 },
  },
  { // 15 N...
    {0x541b, 0x304c, 0x305f, 0x3081, 0x0 },
    {0x6625, 0x306e, 0x91ce, 0x306b, 0x51fa, 0x3067, 0x3066, 0x0 },
    {0x308f, 0x304b, 0x306a, 0x3064, 0x3080, 0x0 },
    {0x6211, 0x8863, 0x624b, 0x306b, 0x0 },
    {0x96ea, 0x306f, 0x3075, 0x308a, 0x3064, 0x3064, 0x0 },
  },
  { // 16 ʂ...
    {0x7acb, 0x3061, 0x5225, 0x308c, 0x0 },
    {0x3044, 0x306a, 0x3070, 0x306e, 0x5c71, 0x306e, 0x0 },
    {0x307f, 0x306d, 0x306b, 0x751f, 0x3075, 0x308b, 0x0 },
    {0x677e, 0x3068, 0x3057, 0x304d, 0x304b, 0x3070, 0x0 },
    {0x4eca, 0x5e30, 0x308a, 0x6765, 0x3080, 0x0 },
  },
  { // 17 瑁U...
    {0x5343, 0x65e9, 0x632f, 0x0 },
    {0x795e, 0x4ee3, 0x3082, 0x304d, 0x304b, 0x305a, 0x0 },
    {0x305f, 0x3064, 0x305f, 0x5ddd, 0x0 },
    {0x304b, 0x3089, 0x7d05, 0x306b, 0x0 },
    {0x6c34, 0x304f, 0x304f, 0x308b, 0x3068, 0x306f, 0x0 },
  },
  { // 18 Z̍]...
    {0x4f4f, 0x306e, 0x6c5f, 0x306e, 0x0 },
    {0x5cb8, 0x306b, 0x3088, 0x308b, 0x6ce2, 0x0 },
    {0x3088, 0x308b, 0x3055, 0x3078, 0x3084, 0x0 },
    {0x5922, 0x306e, 0x901a, 0x8def, 0x0 },
    {0x4eba, 0x3081, 0x3088, 0x304f, 0x3089, 0x3080, 0x0 },
  },
  { // 19 g...
    {0x96e3, 0x6ce2, 0x304c, 0x305f, 0x0 },
    {0x307f, 0x3058, 0x304b, 0x304d, 0x3042, 0x3057, 0x306e, 0x0 },
    {0x3075, 0x3057, 0x306e, 0x9593, 0x3082, 0x0 },
    {0x3042, 0x306f, 0x3067, 0x6b64, 0x4e16, 0x3092, 0x0 },
    {0x3059, 0x3050, 0x3057, 0x3066, 0x3088, 0x3068, 0x3084, 0x0 },
  },
  { // 20 ̂тʂ...
    {0x4f98, 0x3073, 0x306c, 0x308c, 0x3070, 0x0 },
    {0x4eca, 0x306f, 0x305f, 0x304a, 0x306a, 0x3058, 0x0 },
    {0x306a, 0x306b, 0x306f, 0x306a, 0x308b, 0x0 },
    {0x8eab, 0x3092, 0x3064, 0x304f, 0x3057, 0x3066, 0x3082, 0x0 },
    {0x3042, 0x306f, 0x3080, 0x3068, 0x305e, 0x601d, 0x3075, 0x0 },
  },
  { // 21 ނ...
    {0x4eca, 0x3053, 0x3080, 0x3068, 0x0 },
    {0x3044, 0x3072, 0x3057, 0x3070, 0x304b, 0x308a, 0x306b, 0x0 },
    {0x9577, 0x6708, 0x306e, 0x0 },
    {0x6709, 0x660e, 0x306e, 0x6708, 0x3092, 0x0 },
    {0x5f85, 0x51fa, 0x3067, 0x3064, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 22 ...
    {0x5439, 0x304f, 0x304b, 0x3089, 0x306b, 0x0 },
    {0x79cb, 0x306e, 0x8349, 0x6728, 0x306e, 0x0 },
    {0x3057, 0x3092, 0x308b, 0x308c, 0x3070, 0x0 },
    {0x3080, 0x3079, 0x5c71, 0x304b, 0x305c, 0x3092, 0x0 },
    {0x3042, 0x3089, 0x3057, 0x3068, 0x3044, 0x3075, 0x3089, 0x3080, 0x0 },
  },
  { // 23 ݂...
    {0x6708, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x5343, 0x5343, 0x306b, 0x7269, 0x3053, 0x305d, 0x0 },
    {0x304b, 0x306a, 0x3057, 0x3051, 0x308c, 0x0 },
    {0x6211, 0x8eab, 0x3072, 0x3068, 0x3064, 0x306e, 0x0 },
    {0x79cb, 0x306b, 0x306f, 0x3042, 0x3089, 0x306d, 0x3069, 0x0 },
  },
  { // 24 ̓x...
    {0x3053, 0x306e, 0x5ea6, 0x306f, 0x0 },
    {0x306c, 0x3055, 0x3082, 0x3068, 0x308a, 0x3042, 0x3078, 0x305a, 0x0 },
    {0x624b, 0x5411, 0x5c71, 0x0 },
    {0x7d05, 0x8449, 0x306e, 0x306b, 0x3057, 0x304d, 0x0 },
    {0x795e, 0x306e, 0x307e, 0x306b, 0x307e, 0x306b, 0x0 },
  },
  { // 25 ɂ͂...
    {0x540d, 0x306b, 0x3057, 0x304a, 0x306f, 0x3070, 0x0 },
    {0x76f8, 0x5742, 0x5c71, 0x306e, 0x0 },
    {0x3055, 0x306d, 0x304b, 0x3065, 0x3089, 0x0 },
    {0x4eba, 0x306b, 0x3057, 0x3089, 0x308c, 0x3067, 0x0 },
    {0x304f, 0x308b, 0x3088, 0x3057, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 26 ...
    {0x3092, 0x3050, 0x3089, 0x3084, 0x307e, 0x0 },
    {0x307f, 0x306d, 0x306e, 0x3082, 0x307f, 0x3062, 0x8449, 0x0 },
    {0x5fc3, 0x3042, 0x3089, 0x3070, 0x0 },
    {0x4eca, 0x4e00, 0x5ea6, 0x306e, 0x0 },
    {0x307f, 0x3086, 0x304d, 0x307e, 0x305f, 0x306a, 0x3080, 0x0 },
  },
  { // 27 ݂̌...
    {0x307f, 0x304b, 0x306e, 0x539f, 0x0 },
    {0x308f, 0x304d, 0x3066, 0x306a, 0x304c, 0x308b, 0x308b, 0x0 },
    {0x3044, 0x3065, 0x307f, 0x5ddd, 0x0 },
    {0x3044, 0x3064, 0x307f, 0x304d, 0x3068, 0x3066, 0x304b, 0x0 },
    {0x604b, 0x3057, 0x304b, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 28 RƂ...
    {0x5c71, 0x3056, 0x3068, 0x306f, 0x0 },
    {0x51ac, 0x305e, 0x3055, 0x3073, 0x3057, 0x3055, 0x0 },
    {0x307e, 0x3055, 0x308a, 0x3051, 0x308b, 0x0 },
    {0x4eba, 0x3081, 0x3082, 0x8349, 0x3082, 0x0 },
    {0x304b, 0x308c, 0x306c, 0x3068, 0x304a, 0x3082, 0x3078, 0x3070, 0x0 },
  },
  { // 29 SĂ...
    {0x5fc3, 0x3042, 0x3066, 0x306b, 0x0 },
    {0x3092, 0x3089, 0x3070, 0x3084, 0x3092, 0x3089, 0x3080, 0x0 },
    {0x306f, 0x3064, 0x3057, 0x3082, 0x306e, 0x0 },
    {0x7f6e, 0x304d, 0x307e, 0x3069, 0x306f, 0x305b, 0x308b, 0x0 },
    {0x3057, 0x3089, 0x304e, 0x304f, 0x306e, 0x82b1, 0x0 },
  },
  { // 30 L...
    {0x6709, 0x660e, 0x306e, 0x0 },
    {0x3064, 0x308c, 0x306a, 0x304f, 0x898b, 0x3048, 0x3057, 0x0 },
    {0x5225, 0x3088, 0x308a, 0x0 },
    {0x6681, 0x3070, 0x304b, 0x308a, 0x0 },
    {0x3046, 0x304d, 0x7269, 0x306f, 0x306a, 0x3057, 0x0 },
  },
  { // 31 ڂ炯...
    {0x671d, 0x307c, 0x3089, 0x3051, 0x0 },
    {0x3042, 0x308a, 0x3042, 0x3051, 0x306e, 0x6708, 0x3068, 0x0 },
    {0x898b, 0x308b, 0x307e, 0x3067, 0x306b, 0x0 },
    {0x82b3, 0x91ce, 0x306e, 0x3055, 0x3068, 0x306b, 0x0 },
    {0x3075, 0x308c, 0x308b, 0x767d, 0x96ea, 0x0 },
  },
  { // 32 R͂...
    {0x5c71, 0x6cb3, 0x306b, 0x0 },
    {0x304b, 0x305c, 0x306e, 0x304b, 0x3051, 0x305f, 0x308b, 0x0 },
    {0x3057, 0x304c, 0x3089, 0x307f, 0x306f, 0x0 },
    {0x306a, 0x304c, 0x308c, 0x3082, 0x3042, 0x3078, 0x306c, 0x0 },
    {0x7d05, 0x8449, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 33 v...
    {0x4e45, 0x5805, 0x306e, 0x0 },
    {0x5149, 0x306e, 0x3069, 0x3051, 0x304d, 0x0 },
    {0x6625, 0x306e, 0x65e5, 0x306b, 0x0 },
    {0x3057, 0x3065, 0x3053, 0x3053, 0x308d, 0x306a, 0x304f, 0x0 },
    {0x82b1, 0x306e, 0x3061, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 34 ...
    {0x305f, 0x308c, 0x3092, 0x304b, 0x3082, 0x0 },
    {0x3057, 0x308b, 0x4eba, 0x306b, 0x305b, 0x3080, 0x0 },
    {0x9ad8, 0x7802, 0x306e, 0x0 },
    {0x677e, 0x3082, 0x3080, 0x304b, 0x3057, 0x306e, 0x0 },
    {0x53cb, 0x306a, 0x3089, 0x306a, 0x304f, 0x306b, 0x0 },
  },
  { // 35 l͂...
    {0x4eba, 0x306f, 0x3044, 0x3055, 0x0 },
    {0x5fc3, 0x3082, 0x3057, 0x3089, 0x305a, 0x0 },
    {0x3075, 0x308b, 0x3055, 0x3068, 0x306f, 0x0 },
    {0x82b1, 0x305e, 0x3080, 0x304b, 0x3057, 0x306e, 0x0 },
    {0x304b, 0x306b, 0x306b, 0x307b, 0x3072, 0x3051, 0x308b, 0x0 },
  },
  { // 36 Ă̖...
    {0x590f, 0x306e, 0x591c, 0x306f, 0x0 },
    {0x307e, 0x3060, 0x3088, 0x3072, 0x306a, 0x304c, 0x3089, 0x0 },
    {0x660e, 0x3051, 0x306c, 0x308b, 0x3092, 0x0 },
    {0x96f2, 0x306e, 0x3044, 0x3065, 0x3053, 0x306b, 0x0 },
    {0x6708, 0x3084, 0x3069, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 37 I...
    {0x3057, 0x3089, 0x9732, 0x306b, 0x0 },
    {0x98a8, 0x306e, 0x5439, 0x304d, 0x3057, 0x304f, 0x0 },
    {0x79cb, 0x306e, 0x91ce, 0x306f, 0x0 },
    {0x3064, 0x3089, 0x306c, 0x304d, 0x3068, 0x3081, 0x306c, 0x0 },
    {0x7389, 0x305e, 0x3061, 0x308a, 0x3051, 0x308b, 0x0 },
  },
  { // 38 Y...
    {0x5fd8, 0x3089, 0x308b, 0x308b, 0x0 },
    {0x8eab, 0x3092, 0x3070, 0x601d, 0x306f, 0x305a, 0x0 },
    {0x8a93, 0x3072, 0x3066, 0x3057, 0x0 },
    {0x4eba, 0x306e, 0x3044, 0x306e, 0x3061, 0x306e, 0x0 },
    {0x304a, 0x3057, 0x304f, 0x3082, 0x3042, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 39 ӂ...
    {0x3042, 0x3055, 0x3062, 0x3075, 0x306e, 0x0 },
    {0x3092, 0x306e, 0x306e, 0x3057, 0x306e, 0x539f, 0x0 },
    {0x5fcd, 0x3076, 0x308c, 0x3069, 0x0 },
    {0x3042, 0x307e, 0x308a, 0x3066, 0x306a, 0x3069, 0x304b, 0x0 },
    {0x4eba, 0x306e, 0x3053, 0x3072, 0x3057, 0x304d, 0x0 },
  },
  { // 40 EԂ...
    {0x5fcd, 0x3076, 0x308c, 0x3069, 0x0 },
    {0x8272, 0x306b, 0x3044, 0x3067, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x6211, 0x604b, 0x306f, 0x0 },
    {0x7269, 0x3084, 0x304a, 0x3082, 0x3075, 0x3068, 0x0 },
    {0x4eba, 0x306e, 0x3068, 0x3075, 0x307e, 0x3067, 0x0 },
  },
  { // 41 Ă...
    {0x604b, 0x3059, 0x3066, 0x3075, 0x0 },
    {0x6211, 0x540d, 0x306f, 0x307e, 0x3060, 0x304d, 0x0 },
    {0x7acb, 0x3061, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x4eba, 0x3057, 0x308c, 0x305a, 0x3053, 0x305d, 0x0 },
    {0x601d, 0x3072, 0x305d, 0x3081, 0x3057, 0x304b, 0x0 },
  },
  { // 42 _肫...
    {0x5951, 0x308a, 0x304d, 0x306a, 0x0 },
    {0x304b, 0x305f, 0x307f, 0x306b, 0x8896, 0x3092, 0x0 },
    {0x3057, 0x307c, 0x308a, 0x3064, 0x3064, 0x0 },
    {0x3059, 0x3091, 0x306e, 0x677e, 0x5c71, 0x0 },
    {0x6ce2, 0x3053, 0x3055, 0x3058, 0x3068, 0x306f, 0x0 },
  },
  { // 43 Ă...
    {0x9022, 0x898b, 0x3066, 0x306e, 0x0 },
    {0x306e, 0x3061, 0x306e, 0x3053, 0x3053, 0x308d, 0x306b, 0x0 },
    {0x304f, 0x3089, 0x3076, 0x308c, 0x3070, 0x0 },
    {0x3080, 0x304b, 0x3057, 0x306f, 0x7269, 0x3092, 0x0 },
    {0x304a, 0x3082, 0x306f, 0x3056, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 44 ӎ...
    {0x3042, 0x3075, 0x4e8b, 0x306e, 0x0 },
    {0x305f, 0x3048, 0x3066, 0x3057, 0x306a, 0x304f, 0x306f, 0x0 },
    {0x4e2d, 0x4e2d, 0x306b, 0x0 },
    {0x4eba, 0x3092, 0x3082, 0x8eab, 0x3092, 0x3082, 0x0 },
    {0x3046, 0x3089, 0x307f, 0x3056, 0x3089, 0x307e, 0x3057, 0x0 },
  },
  { // 45 ͂Ƃ...
    {0x3042, 0x306f, 0x308c, 0x3068, 0x3082, 0x0 },
    {0x3044, 0x3075, 0x3079, 0x304d, 0x4eba, 0x306f, 0x0 },
    {0x304a, 0x3082, 0x307b, 0x3048, 0x3067, 0x0 },
    {0x8eab, 0x306e, 0x3044, 0x305f, 0x3065, 0x3089, 0x306b, 0x0 },
    {0x6210, 0x308a, 0x306c, 0x3079, 0x304d, 0x304b, 0x306a, 0x0 },
  },
  { // 46 Rǂ̓n...
    {0x7531, 0x826f, 0x306e, 0x6e21, 0x3092, 0x0 },
    {0x308f, 0x305f, 0x308b, 0x821f, 0x4eba, 0x0 },
    {0x304b, 0x3062, 0x3092, 0x305f, 0x3048, 0x0 },
    {0x884c, 0x304f, 0x3078, 0x3082, 0x3057, 0x3089, 0x306c, 0x0 },
    {0x3053, 0x3072, 0x306e, 0x307f, 0x3061, 0x304b, 0x306a, 0x0 },
  },
  { // 47 d...
    {0x516b, 0x91cd, 0x844e, 0x0 },
    {0x3057, 0x3052, 0x308c, 0x308b, 0x3084, 0x3069, 0x306e, 0x0 },
    {0x3055, 0x3073, 0x3057, 0x304d, 0x306b, 0x0 },
    {0x4eba, 0x3053, 0x305d, 0x898b, 0x3048, 0x306d, 0x0 },
    {0x79cb, 0x306f, 0x6765, 0x306b, 0x3051, 0x308a, 0x0 },
  },
  { // 48 ...
    {0x304b, 0x305c, 0x3092, 0x3044, 0x305f, 0x307f, 0x0 },
    {0x5ca9, 0x3046, 0x3064, 0x6ce2, 0x306e, 0x0 },
    {0x304a, 0x306e, 0x308c, 0x306e, 0x307f, 0x0 },
    {0x304f, 0x3060, 0x3051, 0x3066, 0x7269, 0x3092, 0x0 },
    {0x601d, 0x3075, 0x3053, 0x308d, 0x304b, 0x306a, 0x0 },
  },
  { // 49 _...
    {0x5fa1, 0x57a3, 0x5b88, 0x0 },
    {0x885b, 0x58eb, 0x306e, 0x305f, 0x304f, 0x706b, 0x306e, 0x0 },
    {0x3088, 0x308b, 0x306f, 0x3082, 0x3048, 0x0 },
    {0x3072, 0x308b, 0x306f, 0x304d, 0x3048, 0x3064, 0x3064, 0x0 },
    {0x7269, 0x3092, 0x3053, 0x305d, 0x601d, 0x3078, 0x0 },
  },
  { // 50 N...
    {0x541b, 0x304c, 0x305f, 0x3081, 0x0 },
    {0x304a, 0x3057, 0x304b, 0x3089, 0x3056, 0x308a, 0x3057, 0x0 },
    {0x547d, 0x3055, 0x3078, 0x0 },
    {0x306a, 0x304c, 0x304f, 0x3082, 0x304c, 0x306a, 0x3068, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x3051, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 51 Ƃ...
    {0x304b, 0x304f, 0x3068, 0x3060, 0x306b, 0x0 },
    {0x3048, 0x3084, 0x306f, 0x3044, 0x3076, 0x304d, 0x306e, 0x0 },
    {0x3055, 0x3057, 0x3082, 0x8349, 0x0 },
    {0x3055, 0x3057, 0x3082, 0x3057, 0x3089, 0x3058, 0x306a, 0x0 },
    {0x3082, 0x3086, 0x308b, 0x601d, 0x3072, 0x3092, 0x0 },
  },
  { // 52 ʂ...
    {0x660e, 0x3051, 0x306c, 0x308c, 0x3070, 0x0 },
    {0x304f, 0x308b, 0x308b, 0x3082, 0x306e, 0x3068, 0x306f, 0x0 },
    {0x3057, 0x308a, 0x306a, 0x304c, 0x3089, 0x0 },
    {0x7336, 0x3046, 0x3089, 0x3081, 0x3057, 0x304d, 0x0 },
    {0x671d, 0x307c, 0x3089, 0x3051, 0x304b, 0x306a, 0x0 },
  },
  { // 53 V...
    {0x6b4e, 0x304d, 0x3064, 0x3064, 0x0 },
    {0x72ec, 0x306c, 0x308b, 0x591c, 0x306e, 0x0 },
    {0x3042, 0x304f, 0x308b, 0x307e, 0x306f, 0x0 },
    {0x3044, 0x304b, 0x306b, 0x4e45, 0x3057, 0x304d, 0x0 },
    {0x3082, 0x306e, 0x3068, 0x304b, 0x306f, 0x3057, 0x308b, 0x0 },
  },
  { // 54 Yꂶ...
    {0x5fd8, 0x308c, 0x3058, 0x306e, 0x0 },
    {0x3086, 0x304f, 0x3059, 0x3091, 0x307e, 0x3067, 0x306f, 0x0 },
    {0x304b, 0x305f, 0x3051, 0x308c, 0x3070, 0x0 },
    {0x3051, 0x3075, 0x3092, 0x304b, 0x304e, 0x308a, 0x306e, 0x0 },
    {0x547d, 0x3068, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 55 ̂Ƃ...
    {0x6edd, 0x306e, 0x304a, 0x3068, 0x306f, 0x0 },
    {0x7d76, 0x3048, 0x3066, 0x4e45, 0x3057, 0x304f, 0x0 },
    {0x6210, 0x308a, 0x306c, 0x308c, 0x3069, 0x0 },
    {0x540d, 0x3053, 0x305d, 0x306a, 0x304c, 0x308c, 0x3066, 0x0 },
    {0x7336, 0x304d, 0x3053, 0x3048, 0x3051, 0x308c, 0x0 },
  },
  { // 56 炴...
    {0x3042, 0x3089, 0x3056, 0x3089, 0x3080, 0x0 },
    {0x6b64, 0x4e16, 0x306e, 0x307b, 0x304b, 0x306e, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x51fa, 0x306b, 0x0 },
    {0x4eca, 0x4e00, 0x305f, 0x3073, 0x306e, 0x0 },
    {0x3042, 0x3075, 0x4e8b, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 57 ߂肠Ђ...
    {0x3081, 0x3050, 0x308a, 0x3042, 0x3072, 0x3066, 0x0 },
    {0x307f, 0x3057, 0x3084, 0x305d, 0x308c, 0x3068, 0x3082, 0x0 },
    {0x308f, 0x304b, 0x306c, 0x307e, 0x306b, 0x0 },
    {0x96f2, 0x304c, 0x304f, 0x308c, 0x306b, 0x3057, 0x0 },
    {0x591c, 0x534a, 0x306e, 0x6708, 0x304b, 0x306a, 0x0 },
  },
  { // 58 LԎR...
    {0x6709, 0x9593, 0x5c71, 0x0 },
    {0x3090, 0x306a, 0x306e, 0x3055, 0x3055, 0x539f, 0x0 },
    {0x98a8, 0x3075, 0x3051, 0x3070, 0x0 },
    {0x3044, 0x3067, 0x305d, 0x3088, 0x4eba, 0x3092, 0x0 },
    {0x308f, 0x3059, 0x308c, 0x3084, 0x306f, 0x3059, 0x308b, 0x0 },
  },
  { // 59 ₷͂...
    {0x3084, 0x3059, 0x3089, 0x306f, 0x3067, 0x0 },
    {0x306d, 0x306a, 0x307e, 0x3057, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x3055, 0x591c, 0x66f4, 0x3051, 0x3066, 0x0 },
    {0x304b, 0x305f, 0x3076, 0x304f, 0x307e, 0x3067, 0x306e, 0x0 },
    {0x6708, 0x3092, 0x307f, 0x3057, 0x304b, 0x306a, 0x0 },
  },
  { // 60 ]R...
    {0x5927, 0x6c5f, 0x5c71, 0x0 },
    {0x3044, 0x304f, 0x91ce, 0x306e, 0x9053, 0x306e, 0x0 },
    {0x9060, 0x3051, 0x308c, 0x3070, 0x0 },
    {0x307e, 0x3060, 0x3075, 0x307f, 0x3082, 0x307f, 0x305a, 0x0 },
    {0x5929, 0x306e, 0x6a4b, 0x7acb, 0x0 },
  },
  { // 61 ɂւ...
    {0x3044, 0x306b, 0x3057, 0x3078, 0x306e, 0x0 },
    {0x5948, 0x826f, 0x306e, 0x307f, 0x3084, 0x3053, 0x306e, 0x0 },
    {0x516b, 0x91cd, 0x3056, 0x304f, 0x3089, 0x0 },
    {0x3051, 0x3075, 0x4e5d, 0x91cd, 0x306b, 0x0 },
    {0x5302, 0x3072, 0x306c, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 62 ߂...
    {0x591c, 0x3092, 0x3053, 0x3081, 0x3066, 0x0 },
    {0x9ce5, 0x306e, 0x305d, 0x3089, 0x97f3, 0x306f, 0x0 },
    {0x306f, 0x304b, 0x308b, 0x3068, 0x3082, 0x0 },
    {0x4e16, 0x306b, 0x3042, 0x3075, 0x3055, 0x304b, 0x306e, 0x0 },
    {0x305b, 0x304d, 0x306f, 0x3086, 0x308b, 0x3055, 0x3058, 0x0 },
  },
  { // 63 ܂͂...
    {0x3044, 0x307e, 0x306f, 0x305f, 0x3060, 0x0 },
    {0x601d, 0x3072, 0x305f, 0x3048, 0x306a, 0x3080, 0x0 },
    {0x3068, 0x3070, 0x304b, 0x308a, 0x3092, 0x0 },
    {0x4eba, 0x3065, 0x3066, 0x306a, 0x3089, 0x3067, 0x0 },
    {0x3044, 0x3075, 0x3088, 0x3057, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 64 N...
    {0x671d, 0x6717, 0x0 },
    {0x3046, 0x3062, 0x306e, 0x5ddd, 0x9727, 0x0 },
    {0x305f, 0x3048, 0x3060, 0x3048, 0x306b, 0x0 },
    {0x3042, 0x3089, 0x306f, 0x308c, 0x308f, 0x305f, 0x308b, 0x0 },
    {0x305b, 0x305c, 0x306e, 0x7db2, 0x4ee3, 0x6728, 0x0 },
  },
  { // 65 ݂...
    {0x6068, 0x307f, 0x308f, 0x3073, 0x0 },
    {0x307b, 0x3055, 0x306c, 0x8896, 0x3060, 0x306b, 0x0 },
    {0x3042, 0x308b, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x604b, 0x306b, 0x304f, 0x3061, 0x306a, 0x3080, 0x0 },
    {0x540d, 0x3053, 0x305d, 0x3092, 0x3057, 0x3051, 0x308c, 0x0 },
  },
  { // 66 Ƃ...
    {0x3082, 0x308d, 0x3068, 0x3082, 0x306b, 0x0 },
    {0x3042, 0x306f, 0x308c, 0x3068, 0x304a, 0x3082, 0x3078, 0x0 },
    {0x5c71, 0x3056, 0x304f, 0x3089, 0x0 },
    {0x82b1, 0x3088, 0x308a, 0x5916, 0x306b, 0x0 },
    {0x3057, 0x308b, 0x4eba, 0x3082, 0x306a, 0x3057, 0x0 },
  },
  { // 67 t̖...
    {0x6625, 0x306e, 0x591c, 0x306e, 0x0 },
    {0x3086, 0x3081, 0x3070, 0x304b, 0x308a, 0x306a, 0x308b, 0x0 },
    {0x624b, 0x6795, 0x306b, 0x0 },
    {0x304b, 0x3072, 0x306a, 0x304f, 0x305f, 0x305f, 0x3080, 0x0 },
    {0x540d, 0x3053, 0x305d, 0x304a, 0x3057, 0x3051, 0x308c, 0x0 },
  },
  { // 68 Sɂ...
    {0x5fc3, 0x306b, 0x3082, 0x0 },
    {0x3042, 0x3089, 0x3067, 0x3046, 0x304d, 0x4e16, 0x306b, 0x0 },
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x3053, 0x3072, 0x3057, 0x304b, 0x308b, 0x3079, 0x304d, 0x0 },
    {0x591c, 0x534a, 0x306e, 0x6708, 0x304b, 0x306a, 0x0 },
  },
  { // 69 炵...
    {0x3042, 0x3089, 0x3057, 0x5439, 0x304f, 0x0 },
    {0x4e09, 0x5ba4, 0x306e, 0x5c71, 0x306e, 0x0 },
    {0x3082, 0x307f, 0x3062, 0x8449, 0x306f, 0x0 },
    {0x9f8d, 0x7530, 0x306e, 0x5ddd, 0x306e, 0x0 },
    {0x306b, 0x3057, 0x304d, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 70 т...
    {0x3055, 0x3073, 0x3057, 0x3055, 0x306b, 0x0 },
    {0x3084, 0x3069, 0x3092, 0x305f, 0x3061, 0x3044, 0x3067, 0x3066, 0x0 },
    {0x306a, 0x304c, 0x3080, 0x308c, 0x3070, 0x0 },
    {0x3044, 0x3065, 0x3053, 0x3082, 0x304a, 0x306a, 0x3058, 0x0 },
    {0x79cb, 0x306e, 0x3086, 0x3075, 0x66ae, 0x0 },
  },
  { // 71 [...
    {0x5915, 0x3055, 0x308c, 0x3070, 0x0 },
    {0x9580, 0x7530, 0x306e, 0x7a32, 0x8449, 0x0 },
    {0x304a, 0x3068, 0x3065, 0x308c, 0x3066, 0x0 },
    {0x3042, 0x3057, 0x306e, 0x4e38, 0x5c4b, 0x306b, 0x0 },
    {0x79cb, 0x304b, 0x305c, 0x305e, 0x3075, 0x304f, 0x0 },
  },
  { // 72 ɂ...
    {0x97f3, 0x306b, 0x304d, 0x304f, 0x0 },
    {0x9ad8, 0x5e2b, 0x306e, 0x306f, 0x307e, 0x306e, 0x0 },
    {0x3042, 0x3060, 0x306a, 0x307f, 0x306f, 0x0 },
    {0x304b, 0x3051, 0x3058, 0x3084, 0x8896, 0x306e, 0x0 },
    {0x306c, 0x308c, 0x3082, 0x3053, 0x305d, 0x3059, 0x308c, 0x0 },
  },
  { // 73 ...
    {0x9ad8, 0x7802, 0x306e, 0x0 },
    {0x5c3e, 0x4e0a, 0x306e, 0x3055, 0x304f, 0x3089, 0x0 },
    {0x54b2, 0x304d, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x5916, 0x5c71, 0x306e, 0x304b, 0x3059, 0x307f, 0x0 },
    {0x305f, 0x305f, 0x305a, 0x3082, 0x3042, 0x3089, 0x306a, 0x3080, 0x0 },
  },
  { // 74 肯...
    {0x3046, 0x304b, 0x308a, 0x3051, 0x308b, 0x0 },
    {0x4eba, 0x3092, 0x306f, 0x3064, 0x305b, 0x306e, 0x0 },
    {0x5c71, 0x304a, 0x308d, 0x3057, 0x3088, 0x0 },
    {0x306f, 0x3052, 0x3057, 0x304b, 0x308c, 0x3068, 0x306f, 0x0 },
    {0x3044, 0x306e, 0x3089, 0x306c, 0x3082, 0x306e, 0x3092, 0x0 },
  },
  { // 75 _肨...
    {0x5951, 0x308a, 0x304a, 0x304d, 0x3057, 0x0 },
    {0x3055, 0x305b, 0x3082, 0x304c, 0x9732, 0x3092, 0x0 },
    {0x547d, 0x306b, 0x3066, 0x0 },
    {0x3042, 0x306f, 0x308c, 0x3053, 0x3068, 0x3057, 0x306e, 0x0 },
    {0x79cb, 0x3082, 0x3044, 0x306c, 0x3081, 0x308a, 0x0 },
  },
  { // 76 킽̌...
    {0x308f, 0x305f, 0x306e, 0x539f, 0x0 },
    {0x3053, 0x304e, 0x51fa, 0x3067, 0x3066, 0x898b, 0x308c, 0x3070, 0x0 },
    {0x3072, 0x3055, 0x304b, 0x305f, 0x306e, 0x0 },
    {0x96f2, 0x4e95, 0x306b, 0x307e, 0x304c, 0x3075, 0x0 },
    {0x5965, 0x3064, 0x3057, 0x3089, 0x306a, 0x307f, 0x0 },
  },
  { // 77 ͂...
    {0x702c, 0x3092, 0x306f, 0x3084, 0x307f, 0x0 },
    {0x5ca9, 0x306b, 0x305b, 0x304b, 0x308b, 0x308b, 0x0 },
    {0x305f, 0x304d, 0x6cb3, 0x306e, 0x0 },
    {0x308f, 0x308c, 0x3066, 0x3082, 0x3059, 0x3091, 0x306b, 0x0 },
    {0x3042, 0x306f, 0x3080, 0x3068, 0x305e, 0x601d, 0x3075, 0x0 },
  },
  { // 78 WH...
    {0x6de1, 0x8def, 0x5cf6, 0x0 },
    {0x304b, 0x3088, 0x3075, 0x5343, 0x9ce5, 0x306e, 0x0 },
    {0x306a, 0x304f, 0x3053, 0x3091, 0x306b, 0x0 },
    {0x3044, 0x304f, 0x591c, 0x306d, 0x3056, 0x3081, 0x306c, 0x0 },
    {0x3059, 0x307e, 0x306e, 0x95a2, 0x3082, 0x308a, 0x0 },
  },
  { // 79 H...
    {0x79cb, 0x304b, 0x305c, 0x306b, 0x0 },
    {0x305f, 0x306a, 0x3073, 0x304f, 0x96f2, 0x306e, 0x0 },
    {0x305f, 0x3048, 0x307e, 0x3088, 0x308a, 0x0 },
    {0x3082, 0x308c, 0x3044, 0x3065, 0x308b, 0x6708, 0x306e, 0x0 },
    {0x304b, 0x3052, 0x306e, 0x3055, 0x3084, 0x3051, 0x3055, 0x0 },
  },
  { // 80 Ȃ...
    {0x306a, 0x304c, 0x304b, 0x3089, 0x3080, 0x0 },
    {0x5fc3, 0x3082, 0x3057, 0x3089, 0x305a, 0x0 },
    {0x304f, 0x308d, 0x304b, 0x307f, 0x306e, 0x0 },
    {0x307f, 0x3060, 0x308c, 0x3066, 0x3051, 0x3055, 0x306f, 0x0 },
    {0x7269, 0x3092, 0x3053, 0x305d, 0x601d, 0x3078, 0x0 },
  },
  { // 81 قƂƂ...
    {0x307b, 0x3068, 0x3068, 0x304e, 0x3059, 0x0 },
    {0x9cf4, 0x304d, 0x3064, 0x308b, 0x65b9, 0x3092, 0x0 },
    {0x306a, 0x304c, 0x3080, 0x308c, 0x3070, 0x0 },
    {0x305f, 0x3060, 0x6709, 0x660e, 0x306e, 0x0 },
    {0x6708, 0x305e, 0x306e, 0x3053, 0x308c, 0x308b, 0x0 },
  },
  { // 82 vИ̂...
    {0x601d, 0x3072, 0x4f98, 0x3073, 0x0 },
    {0x3055, 0x3066, 0x3082, 0x3044, 0x306e, 0x3061, 0x306f, 0x0 },
    {0x3042, 0x308b, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x3046, 0x304d, 0x306b, 0x305f, 0x3078, 0x306c, 0x306f, 0x0 },
    {0x6d99, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 83 ...
    {0x4e16, 0x4e2d, 0x3088, 0x0 },
    {0x9053, 0x3053, 0x305d, 0x306a, 0x3051, 0x308c, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x3044, 0x308b, 0x0 },
    {0x5c71, 0x306e, 0x304a, 0x304f, 0x306b, 0x3082, 0x0 },
    {0x9e7f, 0x305e, 0x306a, 0x304f, 0x306a, 0x308b, 0x0 },
  },
  { // 84 Ȃւ...
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x53c8, 0x3053, 0x306e, 0x6bd4, 0x3084, 0x0 },
    {0x3057, 0x306e, 0x3070, 0x308c, 0x3080, 0x0 },
    {0x3046, 0x3057, 0x3068, 0x307f, 0x3057, 0x4e16, 0x305e, 0x0 },
    {0x4eca, 0x306f, 0x3053, 0x3072, 0x3057, 0x304d, 0x0 },
  },
  { // 85 ...
    {0x591c, 0x3082, 0x3059, 0x304c, 0x3089, 0x0 },
    {0x7269, 0x601d, 0x3075, 0x9803, 0x306f, 0x0 },
    {0x660e, 0x3051, 0x3084, 0x3089, 0x306c, 0x0 },
    {0x306d, 0x3084, 0x306e, 0x3072, 0x307e, 0x3055, 0x3078, 0x0 },
    {0x3064, 0x308c, 0x306a, 0x304b, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 86 ȂƂ...
    {0x306a, 0x3052, 0x3051, 0x3068, 0x3066, 0x0 },
    {0x6708, 0x3084, 0x306f, 0x7269, 0x3092, 0x0 },
    {0x304a, 0x3082, 0x306f, 0x3059, 0x308b, 0x0 },
    {0x304b, 0x3053, 0x3061, 0x304c, 0x307b, 0x306a, 0x308b, 0x0 },
    {0x6211, 0x306a, 0x307f, 0x3060, 0x304b, 0x306a, 0x0 },
  },
  { // 87 ނ炳߂...
    {0x3080, 0x3089, 0x3055, 0x3081, 0x306e, 0x0 },
    {0x9732, 0x3082, 0x307e, 0x3060, 0x3072, 0x306c, 0x0 },
    {0x69d9, 0x306e, 0x8449, 0x306b, 0x0 },
    {0x9727, 0x305f, 0x3061, 0x306e, 0x307c, 0x308b, 0x0 },
    {0x79cb, 0x306e, 0x3086, 0x3075, 0x3050, 0x308c, 0x0 },
  },
  { // 88 g]...
    {0x96e3, 0x6ce2, 0x6c5f, 0x306e, 0x0 },
    {0x3042, 0x3057, 0x306e, 0x304b, 0x308a, 0x306d, 0x306e, 0x0 },
    {0x4e00, 0x591c, 0x3086, 0x3091, 0x0 },
    {0x8eab, 0x3092, 0x3064, 0x304f, 0x3057, 0x3066, 0x3084, 0x0 },
    {0x604b, 0x308f, 0x305f, 0x308b, 0x3079, 0x304d, 0x0 },
  },
  { // 89 ʂ̏...
    {0x7389, 0x306e, 0x7dd2, 0x3088, 0x0 },
    {0x7d76, 0x3048, 0x306a, 0x3070, 0x305f, 0x3048, 0x306d, 0x0 },
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x5fcd, 0x3076, 0x308b, 0x3053, 0x3068, 0x306e, 0x0 },
    {0x3088, 0x306f, 0x308a, 0x3082, 0x305e, 0x3059, 0x308b, 0x0 },
  },
  { // 90 ΂...
    {0x898b, 0x305b, 0x3070, 0x3084, 0x306a, 0x0 },
    {0x3092, 0x5cf6, 0x306e, 0x3042, 0x307e, 0x306e, 0x0 },
    {0x8896, 0x3060, 0x306b, 0x3082, 0x0 },
    {0x306c, 0x308c, 0x306b, 0x305e, 0x306c, 0x308c, 0x3057, 0x0 },
    {0x8272, 0x306f, 0x304b, 0x306f, 0x3089, 0x305a, 0x0 },
  },
  { // 91 肬肷...
    {0x304d, 0x308a, 0x304e, 0x308a, 0x3059, 0x0 },
    {0x9cf4, 0x304f, 0x3084, 0x971c, 0x591c, 0x306e, 0x0 },
    {0x3055, 0x3080, 0x3057, 0x308d, 0x306b, 0x0 },
    {0x8863, 0x304b, 0x305f, 0x3057, 0x304d, 0x0 },
    {0x3072, 0x3068, 0x308a, 0x304b, 0x3082, 0x306d, 0x3080, 0x0 },
  },
  { // 92 䑳...
    {0x6211, 0x8896, 0x306f, 0x0 },
    {0x3057, 0x307b, 0x3072, 0x306b, 0x898b, 0x3048, 0x306c, 0x0 },
    {0x304a, 0x304d, 0x306e, 0x77f3, 0x306e, 0x0 },
    {0x4eba, 0x3053, 0x305d, 0x3057, 0x3089, 0x306d, 0x0 },
    {0x304b, 0x308f, 0x304f, 0x9593, 0x3082, 0x306a, 0x3057, 0x0 },
  },
  { // 93 ...
    {0x4e16, 0x4e2d, 0x306f, 0x0 },
    {0x5e38, 0x306b, 0x3082, 0x304c, 0x3082, 0x306a, 0x0 },
    {0x306a, 0x304e, 0x3055, 0x3053, 0x3050, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x5c0f, 0x821f, 0x306e, 0x0 },
    {0x7db1, 0x624b, 0x304b, 0x306a, 0x3057, 0x3082, 0x0 },
  },
  { // 94 ݂悵...
    {0x307f, 0x3088, 0x3057, 0x91ce, 0x306e, 0x0 },
    {0x5c71, 0x306e, 0x3042, 0x304d, 0x304b, 0x305c, 0x0 },
    {0x3055, 0x591c, 0x66f4, 0x3051, 0x3066, 0x0 },
    {0x6545, 0x90f7, 0x3055, 0x3080, 0x304f, 0x0 },
    {0x3053, 0x308d, 0x3082, 0x3046, 0x3064, 0x306a, 0x308a, 0x0 },
  },
  { // 95 قȂ...
    {0x304a, 0x307b, 0x3051, 0x306a, 0x304f, 0x0 },
    {0x3046, 0x304d, 0x4e16, 0x306e, 0x305f, 0x307f, 0x306b, 0x0 },
    {0x304a, 0x307b, 0x3075, 0x304b, 0x306a, 0x0 },
    {0x6211, 0x305f, 0x3064, 0x305d, 0x307e, 0x306b, 0x0 },
    {0x58a8, 0x67d3, 0x306e, 0x8896, 0x0 },
  },
  { // 96 Ԃ...
    {0x82b1, 0x3055, 0x305d, 0x3075, 0x0 },
    {0x3042, 0x3089, 0x3057, 0x306e, 0x5ead, 0x306e, 0x0 },
    {0x3086, 0x304d, 0x306a, 0x3089, 0x3067, 0x0 },
    {0x3075, 0x308a, 0x3086, 0x304f, 0x3082, 0x306e, 0x306f, 0x0 },
    {0x6211, 0x8eab, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 97 ʐl...
    {0x3053, 0x306c, 0x4eba, 0x3092, 0x0 },
    {0x677e, 0x5e06, 0x306e, 0x6d66, 0x306e, 0x0 },
    {0x5915, 0x306a, 0x304e, 0x306b, 0x0 },
    {0x3084, 0x304f, 0x3084, 0x3082, 0x3057, 0x307b, 0x306e, 0x0 },
    {0x8eab, 0x3082, 0x3053, 0x304c, 0x308c, 0x3064, 0x3064, 0x0 },
  },
  { // 98 悮...
    {0x98a8, 0x305d, 0x3088, 0x3050, 0x0 },
    {0x306a, 0x3089, 0x306e, 0x3092, 0x304c, 0x306f, 0x306e, 0x0 },
    {0x5915, 0x66ae, 0x306f, 0x0 },
    {0x307f, 0x305d, 0x304e, 0x305e, 0x590f, 0x306e, 0x0 },
    {0x3057, 0x308b, 0x3057, 0x306a, 0x308a, 0x3051, 0x308b, 0x0 },
  },
  { // 99 l...
    {0x4eba, 0x3082, 0x3092, 0x3057, 0x0 },
    {0x4eba, 0x3082, 0x3046, 0x3089, 0x3081, 0x3057, 0x0 },
    {0x3042, 0x3062, 0x304d, 0x306a, 0x304f, 0x0 },
    {0x4e16, 0x3092, 0x304a, 0x3082, 0x3075, 0x3086, 0x3091, 0x306b, 0x0 },
    {0x7269, 0x601d, 0x3075, 0x8eab, 0x306f, 0x0 },
  },
  { // 100 S~...
    {0x767e, 0x6577, 0x3084, 0x0 },
    {0x3075, 0x308b, 0x304d, 0x8ed2, 0x7aef, 0x306e, 0x0 },
    {0x5fcd, 0x3076, 0x306b, 0x3082, 0x0 },
    {0x7336, 0x3042, 0x307e, 0x308a, 0x3042, 0x308b, 0x0 },
    {0x3080, 0x304b, 0x3057, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
};

const static Uint16 KanaWaka[][5][9] = {
  { // 1 ̂...
    {0x3042, 0x304d, 0x306e, 0x305f, 0x306e, 0x0 },
    {0x304b, 0x308a, 0x307b, 0x306e, 0x3044, 0x307b, 0x306e, 0x0 },
    {0x3068, 0x307e, 0x3092, 0x3042, 0x3089, 0x307f, 0x0 },
    {0x308f, 0x304c, 0x3053, 0x308d, 0x3082, 0x3067, 0x306f, 0x0 },
    {0x3064, 0x3086, 0x306b, 0x306c, 0x308c, 0x3064, 0x3064, 0x0 },
  },
  { // 2 ͂邷...
    {0x306f, 0x308b, 0x3059, 0x304e, 0x3066, 0x0 },
    {0x306a, 0x3064, 0x304d, 0x306b, 0x3051, 0x3089, 0x3057, 0x0 },
    {0x3057, 0x308d, 0x305f, 0x3078, 0x306e, 0x0 },
    {0x3053, 0x308d, 0x3082, 0x307b, 0x3059, 0x3066, 0x3075, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x304b, 0x3050, 0x3084, 0x307e, 0x0 },
  },
  { // 3 т...
    {0x3042, 0x3057, 0x3073, 0x304d, 0x306e, 0x0 },
    {0x3084, 0x307e, 0x3069, 0x308a, 0x306e, 0x3092, 0x306e, 0x0 },
    {0x3057, 0x3060, 0x308a, 0x3092, 0x306e, 0x0 },
    {0x306a, 0x304c, 0x306a, 0x304c, 0x3057, 0x3088, 0x3092, 0x0 },
    {0x3072, 0x3068, 0x308a, 0x304b, 0x3082, 0x306d, 0x3080, 0x0 },
  },
  { // 4 ̂...
    {0x305f, 0x3054, 0x306e, 0x3046, 0x3089, 0x306b, 0x0 },
    {0x3046, 0x3061, 0x3044, 0x3067, 0x3066, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x3057, 0x308d, 0x305f, 0x3078, 0x306e, 0x0 },
    {0x3075, 0x3058, 0x306e, 0x305f, 0x304b, 0x306d, 0x306b, 0x0 },
    {0x3086, 0x304d, 0x306f, 0x3075, 0x308a, 0x3064, 0x3064, 0x0 },
  },
  { // 5 ܂...
    {0x304a, 0x304f, 0x3084, 0x307e, 0x306b, 0x0 },
    {0x3082, 0x307f, 0x3062, 0x3075, 0x307f, 0x308f, 0x3051, 0x0 },
    {0x306a, 0x304f, 0x3057, 0x304b, 0x306e, 0x0 },
    {0x3053, 0x3091, 0x304d, 0x304f, 0x3068, 0x304d, 0x305e, 0x0 },
    {0x3042, 0x304d, 0x306f, 0x304b, 0x306a, 0x3057, 0x304d, 0x0 },
  },
  { // 6 ...
    {0x304b, 0x3055, 0x3055, 0x304e, 0x306e, 0x0 },
    {0x308f, 0x305f, 0x305b, 0x308b, 0x306f, 0x3057, 0x306b, 0x0 },
    {0x304a, 0x304f, 0x3057, 0x3082, 0x306e, 0x0 },
    {0x3057, 0x308d, 0x304d, 0x3092, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x3088, 0x305e, 0x3075, 0x3051, 0x306b, 0x3051, 0x308b, 0x0 },
  },
  { // 7 ܂̂͂...
    {0x3042, 0x307e, 0x306e, 0x306f, 0x3089, 0x0 },
    {0x3075, 0x308a, 0x3055, 0x3051, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x304b, 0x3059, 0x304c, 0x306a, 0x308b, 0x0 },
    {0x307f, 0x304b, 0x3055, 0x306e, 0x3084, 0x307e, 0x306b, 0x0 },
    {0x3044, 0x3067, 0x3057, 0x3064, 0x304d, 0x304b, 0x3082, 0x0 },
  },
  { // 8 킪ق...
    {0x308f, 0x304c, 0x3044, 0x307b, 0x306f, 0x0 },
    {0x307f, 0x3084, 0x3053, 0x306e, 0x305f, 0x3064, 0x307f, 0x0 },
    {0x3057, 0x304b, 0x305e, 0x3059, 0x3080, 0x0 },
    {0x3088, 0x3092, 0x3046, 0x3062, 0x3084, 0x307e, 0x3068, 0x0 },
    {0x3072, 0x3068, 0x306f, 0x3044, 0x3075, 0x306a, 0x308a, 0x0 },
  },
  { // 9 ͂Ȃ̂...
    {0x306f, 0x306a, 0x306e, 0x3044, 0x308d, 0x306f, 0x0 },
    {0x3046, 0x3064, 0x308a, 0x306b, 0x3051, 0x308a, 0x306a, 0x0 },
    {0x3044, 0x305f, 0x3065, 0x3089, 0x306b, 0x0 },
    {0x308f, 0x304c, 0x307f, 0x3088, 0x306b, 0x3075, 0x308b, 0x0 },
    {0x306a, 0x304c, 0x3081, 0x305b, 0x3057, 0x307e, 0x306b, 0x0 },
  },
  { // 10 ₱...
    {0x3053, 0x308c, 0x3084, 0x3053, 0x306e, 0x0 },
    {0x3086, 0x304f, 0x3082, 0x304b, 0x3048, 0x308b, 0x3082, 0x0 },
    {0x308f, 0x304b, 0x308c, 0x3066, 0x306f, 0x0 },
    {0x3057, 0x308b, 0x3082, 0x3057, 0x3089, 0x306c, 0x3082, 0x0 },
    {0x3042, 0x3075, 0x3055, 0x304b, 0x306e, 0x305b, 0x304d, 0x0 },
  },
  { // 11 킽̂͂...
    {0x308f, 0x305f, 0x306e, 0x306f, 0x3089, 0x0 },
    {0x3084, 0x305d, 0x3057, 0x307e, 0x304b, 0x3051, 0x3066, 0x0 },
    {0x3053, 0x304e, 0x3044, 0x3067, 0x306c, 0x3068, 0x0 },
    {0x3072, 0x3068, 0x306b, 0x306f, 0x3064, 0x3052, 0x3088, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x3064, 0x308a, 0x3076, 0x306d, 0x0 },
  },
  { // 12 ܂...
    {0x3042, 0x307e, 0x3064, 0x304b, 0x305c, 0x0 },
    {0x304f, 0x3082, 0x306e, 0x304b, 0x3088, 0x3072, 0x3058, 0x0 },
    {0x3075, 0x304d, 0x3068, 0x3062, 0x3088, 0x0 },
    {0x3092, 0x3068, 0x3081, 0x306e, 0x3059, 0x304c, 0x305f, 0x0 },
    {0x3057, 0x3070, 0x3057, 0x3068, 0x3069, 0x3081, 0x3080, 0x0 },
  },
  { // 13 ΂˂...
    {0x3064, 0x304f, 0x3070, 0x306d, 0x306e, 0x0 },
    {0x307f, 0x306d, 0x3088, 0x308a, 0x304a, 0x3064, 0x308b, 0x0 },
    {0x307f, 0x306a, 0x306e, 0x304c, 0x308f, 0x0 },
    {0x3053, 0x3072, 0x305e, 0x3064, 0x3082, 0x308a, 0x3066, 0x0 },
    {0x3075, 0x3061, 0x3068, 0x306a, 0x308a, 0x306c, 0x308b, 0x0 },
  },
  { // 14 ݂̂...
    {0x307f, 0x3061, 0x306e, 0x304f, 0x306e, 0x0 },
    {0x3057, 0x306e, 0x3076, 0x3082, 0x3062, 0x305a, 0x308a, 0x0 },
    {0x305f, 0x308c, 0x3086, 0x3091, 0x306b, 0x0 },
    {0x307f, 0x3060, 0x308c, 0x305d, 0x3081, 0x306b, 0x3057, 0x0 },
    {0x308f, 0x308c, 0x306a, 0x3089, 0x306a, 0x304f, 0x306b, 0x0 },
  },
  { // 15 ݂...
    {0x304d, 0x307f, 0x304c, 0x305f, 0x3081, 0x0 },
    {0x306f, 0x308b, 0x306e, 0x306e, 0x306b, 0x3044, 0x3067, 0x3066, 0x0 },
    {0x308f, 0x304b, 0x306a, 0x3064, 0x3080, 0x0 },
    {0x308f, 0x304c, 0x3053, 0x308d, 0x3082, 0x3067, 0x306b, 0x0 },
    {0x3086, 0x304d, 0x306f, 0x3075, 0x308a, 0x3064, 0x3064, 0x0 },
  },
  { // 16 킩...
    {0x305f, 0x3061, 0x308f, 0x304b, 0x308c, 0x0 },
    {0x3044, 0x306a, 0x3070, 0x306e, 0x3084, 0x307e, 0x306e, 0x0 },
    {0x307f, 0x306d, 0x306b, 0x304a, 0x3075, 0x308b, 0x0 },
    {0x307e, 0x3064, 0x3068, 0x3057, 0x304d, 0x304b, 0x3070, 0x0 },
    {0x3044, 0x307e, 0x304b, 0x3078, 0x308a, 0x3053, 0x3080, 0x0 },
  },
  { // 17 ͂Ԃ...
    {0x3061, 0x306f, 0x3084, 0x3076, 0x308b, 0x0 },
    {0x304b, 0x307f, 0x3088, 0x3082, 0x304d, 0x304b, 0x305a, 0x0 },
    {0x305f, 0x3064, 0x305f, 0x304c, 0x306f, 0x0 },
    {0x304b, 0x3089, 0x304f, 0x308c, 0x306a, 0x3090, 0x306b, 0x0 },
    {0x307f, 0x305a, 0x304f, 0x304f, 0x308b, 0x3068, 0x306f, 0x0 },
  },
  { // 18 ݂̂...
    {0x3059, 0x307f, 0x306e, 0x3048, 0x306e, 0x0 },
    {0x304d, 0x3057, 0x306b, 0x3088, 0x308b, 0x306a, 0x307f, 0x0 },
    {0x3088, 0x308b, 0x3055, 0x3078, 0x3084, 0x0 },
    {0x3086, 0x3081, 0x306e, 0x304b, 0x3088, 0x3072, 0x3062, 0x0 },
    {0x3072, 0x3068, 0x3081, 0x3088, 0x304f, 0x3089, 0x3080, 0x0 },
  },
  { // 19 Ȃɂ͂...
    {0x306a, 0x306b, 0x306f, 0x304c, 0x305f, 0x0 },
    {0x307f, 0x3058, 0x304b, 0x304d, 0x3042, 0x3057, 0x306e, 0x0 },
    {0x3075, 0x3057, 0x306e, 0x307e, 0x3082, 0x0 },
    {0x3042, 0x306f, 0x3067, 0x3053, 0x306e, 0x3088, 0x3092, 0x0 },
    {0x3059, 0x3050, 0x3057, 0x3066, 0x3088, 0x3068, 0x3084, 0x0 },
  },
  { // 20 тʂ...
    {0x308f, 0x3073, 0x306c, 0x308c, 0x3070, 0x0 },
    {0x3044, 0x307e, 0x306f, 0x305f, 0x304a, 0x306a, 0x3058, 0x0 },
    {0x306a, 0x306b, 0x308f, 0x306a, 0x308b, 0x0 },
    {0x307f, 0x3092, 0x3064, 0x304f, 0x3057, 0x3066, 0x3082, 0x0 },
    {0x3042, 0x306f, 0x3080, 0x3068, 0x305e, 0x304a, 0x3082, 0x3075, 0x0 },
  },
  { // 21 ܂ނ...
    {0x3044, 0x307e, 0x3053, 0x3080, 0x3068, 0x0 },
    {0x3044, 0x3072, 0x3057, 0x3070, 0x304b, 0x308a, 0x306b, 0x0 },
    {0x306a, 0x304c, 0x3064, 0x304d, 0x306e, 0x0 },
    {0x3042, 0x308a, 0x3042, 0x3051, 0x306e, 0x3064, 0x304d, 0x3092, 0x0 },
    {0x307e, 0x3061, 0x3044, 0x3067, 0x3064, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 22 ӂ...
    {0x3075, 0x304f, 0x304b, 0x3089, 0x306b, 0x0 },
    {0x3042, 0x304d, 0x306e, 0x304f, 0x3055, 0x304d, 0x306e, 0x0 },
    {0x3057, 0x3092, 0x308b, 0x308c, 0x3070, 0x0 },
    {0x3080, 0x3079, 0x3084, 0x307e, 0x304b, 0x305c, 0x3092, 0x0 },
    {0x3042, 0x3089, 0x3057, 0x3068, 0x3044, 0x3075, 0x3089, 0x3080, 0x0 },
  },
  { // 23 ݂...
    {0x3064, 0x304d, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x3061, 0x3062, 0x306b, 0x3082, 0x306e, 0x3053, 0x305d, 0x0 },
    {0x304b, 0x306a, 0x3057, 0x3051, 0x308c, 0x0 },
    {0x308f, 0x304c, 0x307f, 0x3072, 0x3068, 0x3064, 0x306e, 0x0 },
    {0x3042, 0x304d, 0x306b, 0x306f, 0x3042, 0x3089, 0x306d, 0x3069, 0x0 },
  },
  { // 24 ̂т...
    {0x3053, 0x306e, 0x305f, 0x3073, 0x306f, 0x0 },
    {0x306c, 0x3055, 0x3082, 0x3068, 0x308a, 0x3042, 0x3078, 0x305a, 0x0 },
    {0x305f, 0x3080, 0x3051, 0x3084, 0x307e, 0x0 },
    {0x3082, 0x307f, 0x3062, 0x306e, 0x306b, 0x3057, 0x304d, 0x0 },
    {0x304b, 0x307f, 0x306e, 0x307e, 0x306b, 0x307e, 0x306b, 0x0 },
  },
  { // 25 Ȃɂ͂...
    {0x306a, 0x306b, 0x3057, 0x304a, 0x306f, 0x3070, 0x0 },
    {0x3042, 0x3075, 0x3055, 0x304b, 0x3084, 0x307e, 0x306e, 0x0 },
    {0x3055, 0x306d, 0x304b, 0x3065, 0x3089, 0x0 },
    {0x3072, 0x3068, 0x306b, 0x3057, 0x3089, 0x308c, 0x3067, 0x0 },
    {0x304f, 0x308b, 0x3088, 0x3057, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 26 ...
    {0x3092, 0x3050, 0x3089, 0x3084, 0x307e, 0x0 },
    {0x307f, 0x306d, 0x306e, 0x3082, 0x307f, 0x3062, 0x3070, 0x0 },
    {0x3053, 0x3053, 0x308d, 0x3042, 0x3089, 0x3070, 0x0 },
    {0x3044, 0x307e, 0x3072, 0x3068, 0x305f, 0x3073, 0x306e, 0x0 },
    {0x307f, 0x3086, 0x304d, 0x307e, 0x305f, 0x306a, 0x3080, 0x0 },
  },
  { // 27 ݂̂͂...
    {0x307f, 0x304b, 0x306e, 0x306f, 0x3089, 0x0 },
    {0x308f, 0x304d, 0x3066, 0x306a, 0x304c, 0x308b, 0x308b, 0x0 },
    {0x3044, 0x305a, 0x307f, 0x304b, 0x308f, 0x0 },
    {0x3044, 0x3064, 0x307f, 0x304d, 0x3068, 0x3066, 0x304b, 0x0 },
    {0x3053, 0x3072, 0x3057, 0x304b, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 28 ܂Ƃ...
    {0x3084, 0x307e, 0x3056, 0x3068, 0x306f, 0x0 },
    {0x3075, 0x3086, 0x305e, 0x3055, 0x3073, 0x3057, 0x3055, 0x0 },
    {0x307e, 0x3055, 0x308a, 0x3051, 0x308b, 0x0 },
    {0x3072, 0x3068, 0x3081, 0x3082, 0x304f, 0x3055, 0x3082, 0x0 },
    {0x304b, 0x308c, 0x306c, 0x3068, 0x304a, 0x3082, 0x3078, 0x3070, 0x0 },
  },
  { // 29 날Ă...
    {0x3053, 0x3053, 0x308d, 0x3042, 0x3066, 0x306b, 0x0 },
    {0x3092, 0x3089, 0x3070, 0x3084, 0x3092, 0x3089, 0x3080, 0x0 },
    {0x306f, 0x3064, 0x3057, 0x3082, 0x306e, 0x0 },
    {0x304a, 0x304d, 0x307e, 0x3069, 0x306f, 0x305b, 0x308b, 0x0 },
    {0x3057, 0x3089, 0x304e, 0x304f, 0x306e, 0x306f, 0x306a, 0x0 },
  },
  { // 30 肠...
    {0x3042, 0x308a, 0x3042, 0x3051, 0x306e, 0x0 },
    {0x3064, 0x308c, 0x306a, 0x304f, 0x307f, 0x3048, 0x3057, 0x0 },
    {0x308f, 0x304b, 0x308c, 0x3088, 0x308a, 0x0 },
    {0x3042, 0x304b, 0x3064, 0x304d, 0x3070, 0x304b, 0x308a, 0x0 },
    {0x3046, 0x304d, 0x3082, 0x306e, 0x306f, 0x306a, 0x3057, 0x0 },
  },
  { // 31 ڂ炯...
    {0x3042, 0x3055, 0x307c, 0x3089, 0x3051, 0x0 },
    {0x3042, 0x308a, 0x3042, 0x3051, 0x306e, 0x3064, 0x304d, 0x3068, 0x0 },
    {0x307f, 0x308b, 0x307e, 0x3067, 0x306b, 0x0 },
    {0x3088, 0x3057, 0x306e, 0x306e, 0x3055, 0x3068, 0x306b, 0x0 },
    {0x3075, 0x308c, 0x308b, 0x3057, 0x3089, 0x3086, 0x304d, 0x0 },
  },
  { // 32 ܂͂...
    {0x3084, 0x307e, 0x304c, 0x306f, 0x306b, 0x0 },
    {0x304b, 0x305c, 0x306e, 0x304b, 0x3051, 0x305f, 0x308b, 0x0 },
    {0x3057, 0x304c, 0x3089, 0x307f, 0x306f, 0x0 },
    {0x306a, 0x304c, 0x308c, 0x3082, 0x3042, 0x3078, 0x306c, 0x0 },
    {0x3082, 0x307f, 0x3062, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 33 Ђ...
    {0x3072, 0x3055, 0x304b, 0x305f, 0x306e, 0x0 },
    {0x3072, 0x304b, 0x308a, 0x306e, 0x3069, 0x3051, 0x304d, 0x0 },
    {0x306f, 0x308b, 0x306e, 0x3072, 0x306b, 0x0 },
    {0x3057, 0x3065, 0x3053, 0x3053, 0x308d, 0x306a, 0x304f, 0x0 },
    {0x306f, 0x306a, 0x306e, 0x3061, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 34 ...
    {0x305f, 0x308c, 0x3092, 0x304b, 0x3082, 0x0 },
    {0x3057, 0x308b, 0x3072, 0x3068, 0x306b, 0x305b, 0x3080, 0x0 },
    {0x305f, 0x304b, 0x3055, 0x3054, 0x306e, 0x0 },
    {0x307e, 0x3064, 0x3082, 0x3080, 0x304b, 0x3057, 0x306e, 0x0 },
    {0x3068, 0x3082, 0x306a, 0x3089, 0x306a, 0x304f, 0x306b, 0x0 },
  },
  { // 35 ЂƂ͂...
    {0x3072, 0x3068, 0x306f, 0x3044, 0x3055, 0x0 },
    {0x3053, 0x3053, 0x308d, 0x3082, 0x3057, 0x3089, 0x305a, 0x0 },
    {0x3075, 0x308b, 0x3055, 0x3068, 0x306f, 0x0 },
    {0x306f, 0x306a, 0x305e, 0x3080, 0x304b, 0x3057, 0x306e, 0x0 },
    {0x304b, 0x306b, 0x306b, 0x307b, 0x3072, 0x3051, 0x308b, 0x0 },
  },
  { // 36 Ȃ̂...
    {0x306a, 0x3064, 0x306e, 0x3088, 0x306f, 0x0 },
    {0x307e, 0x3060, 0x3088, 0x3072, 0x306a, 0x304c, 0x3089, 0x0 },
    {0x3042, 0x3051, 0x306c, 0x308b, 0x3092, 0x0 },
    {0x304f, 0x3082, 0x306e, 0x3044, 0x3065, 0x3053, 0x306b, 0x0 },
    {0x3064, 0x304d, 0x3084, 0x3069, 0x308b, 0x3089, 0x3080, 0x0 },
  },
  { // 37 ...
    {0x3057, 0x3089, 0x3064, 0x3086, 0x306b, 0x0 },
    {0x304b, 0x305c, 0x306e, 0x3075, 0x304d, 0x3057, 0x304f, 0x0 },
    {0x3042, 0x304d, 0x306e, 0x306e, 0x306f, 0x0 },
    {0x3064, 0x3089, 0x306c, 0x304d, 0x3068, 0x3081, 0x306c, 0x0 },
    {0x305f, 0x307e, 0x305e, 0x3061, 0x308a, 0x3051, 0x308b, 0x0 },
  },
  { // 38 킷...
    {0x308f, 0x3059, 0x3089, 0x308b, 0x308b, 0x0 },
    {0x307f, 0x3092, 0x3070, 0x304a, 0x3082, 0x306f, 0x305a, 0x0 },
    {0x3061, 0x304b, 0x3072, 0x3066, 0x3057, 0x0 },
    {0x3072, 0x3068, 0x306e, 0x3044, 0x306e, 0x3061, 0x306e, 0x0 },
    {0x304a, 0x3057, 0x304f, 0x3082, 0x3042, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 39 ӂ...
    {0x3042, 0x3055, 0x3062, 0x3075, 0x306e, 0x0 },
    {0x3092, 0x306e, 0x306e, 0x3057, 0x306e, 0x306f, 0x3089, 0x0 },
    {0x3057, 0x306e, 0x3076, 0x308c, 0x3069, 0x0 },
    {0x3042, 0x307e, 0x308a, 0x3066, 0x306a, 0x3069, 0x304b, 0x0 },
    {0x3072, 0x3068, 0x306e, 0x3053, 0x3072, 0x3057, 0x304d, 0x0 },
  },
  { // 40 ̂Ԃ...
    {0x3057, 0x306e, 0x3076, 0x308c, 0x3069, 0x0 },
    {0x3044, 0x308d, 0x306b, 0x3044, 0x3067, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x308f, 0x304c, 0x3053, 0x3072, 0x306f, 0x0 },
    {0x3082, 0x306e, 0x3084, 0x304a, 0x3082, 0x3075, 0x3068, 0x0 },
    {0x3072, 0x3068, 0x306e, 0x3068, 0x3075, 0x307e, 0x3067, 0x0 },
  },
  { // 41 ЂĂ...
    {0x3053, 0x3072, 0x3059, 0x3066, 0x3075, 0x0 },
    {0x308f, 0x304c, 0x306a, 0x306f, 0x307e, 0x3060, 0x304d, 0x0 },
    {0x305f, 0x3061, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x3072, 0x3068, 0x3057, 0x308c, 0x305a, 0x3053, 0x305d, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x305d, 0x3081, 0x3057, 0x304b, 0x0 },
  },
  { // 42 肫...
    {0x3061, 0x304e, 0x308a, 0x304d, 0x306a, 0x0 },
    {0x304b, 0x305f, 0x307f, 0x306b, 0x305d, 0x3067, 0x3092, 0x0 },
    {0x3057, 0x307c, 0x308a, 0x3064, 0x3064, 0x0 },
    {0x3059, 0x3091, 0x306e, 0x307e, 0x3064, 0x3084, 0x307e, 0x0 },
    {0x306a, 0x307f, 0x3053, 0x3055, 0x3058, 0x3068, 0x306f, 0x0 },
  },
  { // 43 Ђ݂Ă...
    {0x3042, 0x3072, 0x307f, 0x3066, 0x306e, 0x0 },
    {0x306e, 0x3061, 0x306e, 0x3053, 0x3053, 0x308d, 0x306b, 0x0 },
    {0x304f, 0x3089, 0x3076, 0x308c, 0x3070, 0x0 },
    {0x3080, 0x304b, 0x3057, 0x306f, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x304a, 0x3082, 0x306f, 0x3056, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 44 ӂƂ...
    {0x3042, 0x3075, 0x3053, 0x3068, 0x306e, 0x0 },
    {0x305f, 0x3048, 0x3066, 0x3057, 0x306a, 0x304f, 0x306f, 0x0 },
    {0x306a, 0x304b, 0x306a, 0x304b, 0x306b, 0x0 },
    {0x3072, 0x3068, 0x3092, 0x3082, 0x307f, 0x3092, 0x3082, 0x0 },
    {0x3046, 0x3089, 0x307f, 0x3056, 0x3089, 0x307e, 0x3057, 0x0 },
  },
  { // 45 ͂Ƃ...
    {0x3042, 0x306f, 0x308c, 0x3068, 0x3082, 0x0 },
    {0x3044, 0x3075, 0x3079, 0x304d, 0x3072, 0x3068, 0x306f, 0x0 },
    {0x304a, 0x3082, 0x307b, 0x3048, 0x3067, 0x0 },
    {0x307f, 0x306e, 0x3044, 0x305f, 0x3065, 0x3089, 0x306b, 0x0 },
    {0x306a, 0x308a, 0x306c, 0x3079, 0x304d, 0x304b, 0x306a, 0x0 },
  },
  { // 46 ̂Ƃ...
    {0x3086, 0x3089, 0x306e, 0x3068, 0x3092, 0x0 },
    {0x308f, 0x305f, 0x308b, 0x3075, 0x306a, 0x3073, 0x3068, 0x0 },
    {0x304b, 0x3062, 0x3092, 0x305f, 0x3048, 0x0 },
    {0x3086, 0x304f, 0x3078, 0x3082, 0x3057, 0x3089, 0x306c, 0x0 },
    {0x3053, 0x3072, 0x306e, 0x307f, 0x3061, 0x304b, 0x306a, 0x0 },
  },
  { // 47 ₦ނ...
    {0x3084, 0x3048, 0x3080, 0x3050, 0x3089, 0x0 },
    {0x3057, 0x3052, 0x308c, 0x308b, 0x3084, 0x3069, 0x306e, 0x0 },
    {0x3055, 0x3073, 0x3057, 0x304d, 0x306b, 0x0 },
    {0x3072, 0x3068, 0x3053, 0x305d, 0x307f, 0x3048, 0x306d, 0x0 },
    {0x3042, 0x304d, 0x306f, 0x304d, 0x306b, 0x3051, 0x308a, 0x0 },
  },
  { // 48 ...
    {0x304b, 0x305c, 0x3092, 0x3044, 0x305f, 0x307f, 0x0 },
    {0x3044, 0x308f, 0x3046, 0x3064, 0x306a, 0x307f, 0x306e, 0x0 },
    {0x304a, 0x306e, 0x308c, 0x306e, 0x307f, 0x0 },
    {0x304f, 0x3060, 0x3051, 0x3066, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x304a, 0x3082, 0x3075, 0x3053, 0x308d, 0x304b, 0x306a, 0x0 },
  },
  { // 49 ݂...
    {0x307f, 0x304b, 0x304d, 0x3082, 0x308a, 0x0 },
    {0x3048, 0x3058, 0x306e, 0x305f, 0x304f, 0x3072, 0x306e, 0x0 },
    {0x3088, 0x308b, 0x306f, 0x3082, 0x3048, 0x0 },
    {0x3072, 0x308b, 0x306f, 0x304d, 0x3048, 0x3064, 0x3064, 0x0 },
    {0x3082, 0x306e, 0x3092, 0x3053, 0x305d, 0x304a, 0x3082, 0x3078, 0x0 },
  },
  { // 50 ݂...
    {0x304d, 0x307f, 0x304c, 0x305f, 0x3081, 0x0 },
    {0x304a, 0x3057, 0x304b, 0x3089, 0x3056, 0x308a, 0x3057, 0x0 },
    {0x3044, 0x306e, 0x3061, 0x3055, 0x3078, 0x0 },
    {0x306a, 0x304c, 0x304f, 0x3082, 0x304c, 0x306a, 0x3068, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x3051, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 51 Ƃ...
    {0x304b, 0x304f, 0x3068, 0x3060, 0x306b, 0x0 },
    {0x3048, 0x3084, 0x306f, 0x3044, 0x3076, 0x304d, 0x306e, 0x0 },
    {0x3055, 0x3057, 0x3082, 0x3050, 0x3055, 0x0 },
    {0x3055, 0x3057, 0x3082, 0x3057, 0x3089, 0x3058, 0x306a, 0x0 },
    {0x3082, 0x3086, 0x308b, 0x304a, 0x3082, 0x3072, 0x3092, 0x0 },
  },
  { // 52 ʂ...
    {0x3042, 0x3051, 0x306c, 0x308c, 0x3070, 0x0 },
    {0x304f, 0x308b, 0x308b, 0x3082, 0x306e, 0x3068, 0x306f, 0x0 },
    {0x3057, 0x308a, 0x306a, 0x304c, 0x3089, 0x0 },
    {0x306a, 0x307b, 0x3046, 0x3089, 0x3081, 0x3057, 0x304d, 0x0 },
    {0x3042, 0x3055, 0x307c, 0x3089, 0x3051, 0x304b, 0x306a, 0x0 },
  },
  { // 53 Ȃ...
    {0x306a, 0x3052, 0x304d, 0x3064, 0x3064, 0x0 },
    {0x3072, 0x3068, 0x308a, 0x306c, 0x308b, 0x3088, 0x306e, 0x0 },
    {0x3042, 0x304f, 0x308b, 0x307e, 0x306f, 0x0 },
    {0x3044, 0x304b, 0x306b, 0x3072, 0x3055, 0x3057, 0x304d, 0x0 },
    {0x3082, 0x306e, 0x3068, 0x304b, 0x306f, 0x3057, 0x308b, 0x0 },
  },
  { // 54 킷ꂶ...
    {0x308f, 0x3059, 0x308c, 0x3058, 0x306e, 0x0 },
    {0x3086, 0x304f, 0x3059, 0x3091, 0x307e, 0x3067, 0x306f, 0x0 },
    {0x304b, 0x305f, 0x3051, 0x308c, 0x3070, 0x0 },
    {0x3051, 0x3075, 0x3092, 0x304b, 0x304e, 0x308a, 0x306e, 0x0 },
    {0x3044, 0x306e, 0x3061, 0x3068, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 55 ̂Ƃ...
    {0x305f, 0x304d, 0x306e, 0x304a, 0x3068, 0x306f, 0x0 },
    {0x305f, 0x3048, 0x3066, 0x3072, 0x3055, 0x3057, 0x304f, 0x0 },
    {0x306a, 0x308a, 0x306c, 0x308c, 0x3069, 0x0 },
    {0x306a, 0x3053, 0x305d, 0x306a, 0x304c, 0x308c, 0x3066, 0x0 },
    {0x306a, 0x307b, 0x304d, 0x3053, 0x3048, 0x3051, 0x308c, 0x0 },
  },
  { // 56 炴...
    {0x3042, 0x3089, 0x3056, 0x3089, 0x3080, 0x0 },
    {0x3053, 0x306e, 0x3088, 0x306e, 0x307b, 0x304b, 0x306e, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x3067, 0x306b, 0x0 },
    {0x3044, 0x307e, 0x3072, 0x3068, 0x305f, 0x3073, 0x306e, 0x0 },
    {0x3042, 0x3075, 0x3053, 0x3068, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 57 ߂肠Ђ...
    {0x3081, 0x3050, 0x308a, 0x3042, 0x3072, 0x3066, 0x0 },
    {0x307f, 0x3057, 0x3084, 0x305d, 0x308c, 0x3068, 0x3082, 0x0 },
    {0x308f, 0x304b, 0x306c, 0x307e, 0x306b, 0x0 },
    {0x304f, 0x3082, 0x304c, 0x304f, 0x308c, 0x306b, 0x3057, 0x0 },
    {0x3088, 0x306f, 0x306e, 0x3064, 0x304d, 0x304b, 0x306a, 0x0 },
  },
  { // 58 ܂...
    {0x3042, 0x308a, 0x307e, 0x3084, 0x307e, 0x0 },
    {0x3090, 0x306a, 0x306e, 0x3055, 0x3055, 0x306f, 0x3089, 0x0 },
    {0x304b, 0x305c, 0x3075, 0x3051, 0x3070, 0x0 },
    {0x3044, 0x3067, 0x305d, 0x3088, 0x3072, 0x3068, 0x3092, 0x0 },
    {0x308f, 0x3059, 0x308c, 0x3084, 0x306f, 0x3059, 0x308b, 0x0 },
  },
  { // 59 ₷͂...
    {0x3084, 0x3059, 0x3089, 0x306f, 0x3067, 0x0 },
    {0x306d, 0x306a, 0x307e, 0x3057, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x3055, 0x3088, 0x3075, 0x3051, 0x3066, 0x0 },
    {0x304b, 0x305f, 0x3076, 0x304f, 0x307e, 0x3067, 0x306e, 0x0 },
    {0x3064, 0x304d, 0x3092, 0x307f, 0x3057, 0x304b, 0x306a, 0x0 },
  },
  { // 60 ...
    {0x304a, 0x304a, 0x3048, 0x3084, 0x307e, 0x0 },
    {0x3044, 0x304f, 0x306e, 0x306e, 0x307f, 0x3061, 0x306e, 0x0 },
    {0x3068, 0x307b, 0x3051, 0x308c, 0x3070, 0x0 },
    {0x307e, 0x3060, 0x3075, 0x307f, 0x3082, 0x307f, 0x305a, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x306f, 0x3057, 0x3060, 0x3066, 0x0 },
  },
  { // 61 ɂւ...
    {0x3044, 0x306b, 0x3057, 0x3078, 0x306e, 0x0 },
    {0x306a, 0x3089, 0x306e, 0x307f, 0x3084, 0x3053, 0x306e, 0x0 },
    {0x3084, 0x3048, 0x3056, 0x304f, 0x3089, 0x0 },
    {0x3051, 0x3075, 0x3053, 0x3053, 0x306e, 0x3078, 0x306b, 0x0 },
    {0x306b, 0x307b, 0x3072, 0x306c, 0x308b, 0x304b, 0x306a, 0x0 },
  },
  { // 62 ߂...
    {0x3088, 0x3092, 0x3053, 0x3081, 0x3066, 0x0 },
    {0x3068, 0x308a, 0x306e, 0x305d, 0x3089, 0x306d, 0x306f, 0x0 },
    {0x306f, 0x304b, 0x308b, 0x3068, 0x3082, 0x0 },
    {0x3088, 0x306b, 0x3042, 0x3075, 0x3055, 0x304b, 0x306e, 0x0 },
    {0x305b, 0x304d, 0x306f, 0x3086, 0x308b, 0x3055, 0x3058, 0x0 },
  },
  { // 63 ܂͂...
    {0x3044, 0x307e, 0x306f, 0x305f, 0x3060, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x305f, 0x3048, 0x306a, 0x3080, 0x0 },
    {0x3068, 0x3070, 0x304b, 0x308a, 0x3092, 0x0 },
    {0x3072, 0x3068, 0x3065, 0x3066, 0x306a, 0x3089, 0x3067, 0x0 },
    {0x3044, 0x3075, 0x3088, 0x3057, 0x3082, 0x304c, 0x306a, 0x0 },
  },
  { // 64 ڂ炯...
    {0x3042, 0x3055, 0x307c, 0x3089, 0x3051, 0x0 },
    {0x3046, 0x3058, 0x306e, 0x304b, 0x306f, 0x304e, 0x308a, 0x0 },
    {0x305f, 0x3048, 0x3060, 0x3048, 0x306b, 0x0 },
    {0x3042, 0x3089, 0x306f, 0x308c, 0x308f, 0x305f, 0x308b, 0x0 },
    {0x305b, 0x305c, 0x306e, 0x3042, 0x3058, 0x308d, 0x304e, 0x0 },
  },
  { // 65 ݂...
    {0x3046, 0x3089, 0x307f, 0x308f, 0x3073, 0x0 },
    {0x307b, 0x3055, 0x306c, 0x305d, 0x3067, 0x3060, 0x306b, 0x0 },
    {0x3042, 0x308b, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x3053, 0x3072, 0x306b, 0x304f, 0x3061, 0x306a, 0x3080, 0x0 },
    {0x306a, 0x3053, 0x305d, 0x3092, 0x3057, 0x3051, 0x308c, 0x0 },
  },
  { // 66 Ƃ...
    {0x3082, 0x308d, 0x3068, 0x3082, 0x306b, 0x0 },
    {0x3042, 0x306f, 0x308c, 0x3068, 0x304a, 0x3082, 0x3078, 0x0 },
    {0x3084, 0x307e, 0x3056, 0x304f, 0x3089, 0x0 },
    {0x306f, 0x306a, 0x3088, 0x308a, 0x307b, 0x304b, 0x306b, 0x0 },
    {0x3057, 0x308b, 0x3072, 0x3068, 0x3082, 0x306a, 0x3057, 0x0 },
  },
  { // 67 ͂̂...
    {0x306f, 0x308b, 0x306e, 0x3088, 0x306e, 0x0 },
    {0x3086, 0x3081, 0x3070, 0x304b, 0x308a, 0x306a, 0x308b, 0x0 },
    {0x305f, 0x307e, 0x304f, 0x3089, 0x306b, 0x0 },
    {0x304b, 0x3072, 0x306a, 0x304f, 0x305f, 0x305f, 0x3080, 0x0 },
    {0x306a, 0x3053, 0x305d, 0x304a, 0x3057, 0x3051, 0x308c, 0x0 },
  },
  { // 68 ɂ...
    {0x3053, 0x3053, 0x308d, 0x306b, 0x3082, 0x0 },
    {0x3042, 0x3089, 0x3067, 0x3046, 0x304d, 0x3088, 0x306b, 0x0 },
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x3053, 0x3072, 0x3057, 0x304b, 0x308b, 0x3079, 0x304d, 0x0 },
    {0x3088, 0x306f, 0x306e, 0x3064, 0x304d, 0x304b, 0x306a, 0x0 },
  },
  { // 69 炵ӂ...
    {0x3042, 0x3089, 0x3057, 0x3075, 0x304f, 0x0 },
    {0x307f, 0x3080, 0x308d, 0x306e, 0x3084, 0x307e, 0x306e, 0x0 },
    {0x3082, 0x307f, 0x3062, 0x3070, 0x306f, 0x0 },
    {0x305f, 0x3064, 0x305f, 0x306e, 0x304b, 0x306f, 0x306e, 0x0 },
    {0x306b, 0x3057, 0x304d, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 70 т...
    {0x3055, 0x3073, 0x3057, 0x3055, 0x306b, 0x0 },
    {0x3084, 0x3069, 0x3092, 0x305f, 0x3061, 0x3044, 0x3067, 0x3066, 0x0 },
    {0x306a, 0x304c, 0x3080, 0x308c, 0x3070, 0x0 },
    {0x3044, 0x3065, 0x3053, 0x3082, 0x304a, 0x306a, 0x3058, 0x0 },
    {0x3042, 0x304d, 0x306e, 0x3086, 0x3075, 0x3050, 0x308c, 0x0 },
  },
  { // 71 䂤...
    {0x3086, 0x3046, 0x3055, 0x308c, 0x3070, 0x0 },
    {0x304b, 0x3069, 0x305f, 0x306e, 0x3044, 0x306a, 0x3070, 0x0 },
    {0x304a, 0x3068, 0x3065, 0x308c, 0x3066, 0x0 },
    {0x3042, 0x3057, 0x306e, 0x307e, 0x308d, 0x3084, 0x306b, 0x0 },
    {0x3042, 0x304d, 0x304b, 0x305c, 0x305e, 0x3075, 0x304f, 0x0 },
  },
  { // 72 Ƃɂ...
    {0x304a, 0x3068, 0x306b, 0x304d, 0x304f, 0x0 },
    {0x305f, 0x304b, 0x3057, 0x306e, 0x306f, 0x307e, 0x306e, 0x0 },
    {0x3042, 0x3060, 0x306a, 0x307f, 0x306f, 0x0 },
    {0x304b, 0x3051, 0x3058, 0x3084, 0x305d, 0x3067, 0x306e, 0x0 },
    {0x306c, 0x308c, 0x3082, 0x3053, 0x305d, 0x3059, 0x308c, 0x0 },
  },
  { // 73 ...
    {0x305f, 0x304b, 0x3055, 0x3054, 0x306e, 0x0 },
    {0x304a, 0x306e, 0x3078, 0x306e, 0x3055, 0x304f, 0x3089, 0x0 },
    {0x3055, 0x304d, 0x306b, 0x3051, 0x308a, 0x0 },
    {0x3068, 0x3084, 0x307e, 0x306e, 0x304b, 0x3059, 0x307f, 0x0 },
    {0x305f, 0x305f, 0x305a, 0x3082, 0x3042, 0x3089, 0x306a, 0x3080, 0x0 },
  },
  { // 74 肯...
    {0x3046, 0x304b, 0x308a, 0x3051, 0x308b, 0x0 },
    {0x3072, 0x3068, 0x3092, 0x306f, 0x3064, 0x305b, 0x306e, 0x0 },
    {0x3084, 0x307e, 0x304a, 0x308d, 0x3057, 0x3088, 0x0 },
    {0x306f, 0x3052, 0x3057, 0x304b, 0x308c, 0x3068, 0x306f, 0x0 },
    {0x3044, 0x306e, 0x3089, 0x306c, 0x3082, 0x306e, 0x3092, 0x0 },
  },
  { // 75 肨...
    {0x3061, 0x304e, 0x308a, 0x304a, 0x304d, 0x3057, 0x0 },
    {0x3055, 0x305b, 0x3082, 0x304c, 0x3064, 0x3086, 0x3092, 0x0 },
    {0x3044, 0x306e, 0x3061, 0x306b, 0x3066, 0x0 },
    {0x3042, 0x306f, 0x308c, 0x3053, 0x3068, 0x3057, 0x306e, 0x0 },
    {0x3042, 0x304d, 0x3082, 0x3044, 0x306c, 0x3081, 0x308a, 0x0 },
  },
  { // 76 킽̂͂...
    {0x308f, 0x305f, 0x306e, 0x306f, 0x3089, 0x0 },
    {0x3053, 0x304e, 0x3044, 0x3067, 0x3066, 0x307f, 0x308c, 0x3070, 0x0 },
    {0x3072, 0x3055, 0x304b, 0x305f, 0x306e, 0x0 },
    {0x304f, 0x3082, 0x3090, 0x306b, 0x307e, 0x304c, 0x3075, 0x0 },
    {0x304a, 0x304d, 0x3064, 0x3057, 0x3089, 0x306a, 0x307f, 0x0 },
  },
  { // 77 ͂...
    {0x305b, 0x3092, 0x306f, 0x3084, 0x307f, 0x0 },
    {0x3044, 0x308f, 0x306b, 0x305b, 0x304b, 0x308b, 0x308b, 0x0 },
    {0x305f, 0x304d, 0x304c, 0x306f, 0x306e, 0x0 },
    {0x308f, 0x308c, 0x3066, 0x3082, 0x3059, 0x3091, 0x306b, 0x0 },
    {0x3042, 0x306f, 0x3080, 0x3068, 0x305e, 0x304a, 0x3082, 0x3075, 0x0 },
  },
  { // 78 ͂...
    {0x3042, 0x306f, 0x3062, 0x3057, 0x307e, 0x0 },
    {0x304b, 0x3088, 0x3075, 0x3061, 0x3069, 0x308a, 0x306e, 0x0 },
    {0x306a, 0x304f, 0x3053, 0x3048, 0x306b, 0x0 },
    {0x3044, 0x304f, 0x3088, 0x306d, 0x3056, 0x3081, 0x306c, 0x0 },
    {0x3059, 0x307e, 0x306e, 0x305b, 0x304d, 0x3082, 0x308a, 0x0 },
  },
  { // 79 ...
    {0x3042, 0x304d, 0x304b, 0x305c, 0x306b, 0x0 },
    {0x305f, 0x306a, 0x3073, 0x304f, 0x304f, 0x3082, 0x306e, 0x0 },
    {0x305f, 0x3048, 0x307e, 0x3088, 0x308a, 0x0 },
    {0x3082, 0x308c, 0x3044, 0x3065, 0x308b, 0x3064, 0x304d, 0x306e, 0x0 },
    {0x304b, 0x3052, 0x306e, 0x3055, 0x3084, 0x3051, 0x3055, 0x0 },
  },
  { // 80 Ȃ...
    {0x306a, 0x304c, 0x304b, 0x3089, 0x3080, 0x0 },
    {0x3053, 0x3053, 0x308d, 0x3082, 0x3057, 0x3089, 0x305a, 0x0 },
    {0x304f, 0x308d, 0x304b, 0x307f, 0x306e, 0x0 },
    {0x307f, 0x3060, 0x308c, 0x3066, 0x3051, 0x3055, 0x306f, 0x0 },
    {0x3082, 0x306e, 0x3092, 0x3053, 0x305d, 0x304a, 0x3082, 0x3078, 0x0 },
  },
  { // 81 قƂƂ...
    {0x307b, 0x3068, 0x3068, 0x304e, 0x3059, 0x0 },
    {0x306a, 0x304d, 0x3064, 0x308b, 0x304b, 0x305f, 0x3092, 0x0 },
    {0x306a, 0x304c, 0x3080, 0x308c, 0x3070, 0x0 },
    {0x305f, 0x3060, 0x3042, 0x308a, 0x3042, 0x3051, 0x306e, 0x0 },
    {0x3064, 0x304d, 0x305e, 0x306e, 0x3053, 0x308c, 0x308b, 0x0 },
  },
  { // 82 Ђ...
    {0x304a, 0x3082, 0x3072, 0x308f, 0x3073, 0x0 },
    {0x3055, 0x3066, 0x3082, 0x3044, 0x306e, 0x3061, 0x306f, 0x0 },
    {0x3042, 0x308b, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x3046, 0x304d, 0x306b, 0x305f, 0x3078, 0x306c, 0x306f, 0x0 },
    {0x306a, 0x307f, 0x3060, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 83 ̂Ȃ...
    {0x3088, 0x306e, 0x306a, 0x304b, 0x3088, 0x0 },
    {0x307f, 0x3061, 0x3053, 0x305d, 0x306a, 0x3051, 0x308c, 0x0 },
    {0x304a, 0x3082, 0x3072, 0x3044, 0x308b, 0x0 },
    {0x3084, 0x307e, 0x306e, 0x304a, 0x304f, 0x306b, 0x3082, 0x0 },
    {0x3057, 0x304b, 0x305e, 0x306a, 0x304f, 0x306a, 0x308b, 0x0 },
  },
  { // 84 Ȃւ...
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x307e, 0x305f, 0x3053, 0x306e, 0x3053, 0x308d, 0x3084, 0x0 },
    {0x3057, 0x306e, 0x3070, 0x308c, 0x3080, 0x0 },
    {0x3046, 0x3057, 0x3068, 0x307f, 0x3057, 0x3088, 0x305e, 0x0 },
    {0x3044, 0x307e, 0x306f, 0x3053, 0x3072, 0x3057, 0x304d, 0x0 },
  },
  { // 85 ...
    {0x3088, 0x3082, 0x3059, 0x304c, 0x3089, 0x0 },
    {0x3082, 0x306e, 0x304a, 0x3082, 0x3075, 0x3053, 0x308d, 0x306f, 0x0 },
    {0x3042, 0x3051, 0x3084, 0x3089, 0x306c, 0x0 },
    {0x306d, 0x3084, 0x306e, 0x3072, 0x307e, 0x3055, 0x3078, 0x0 },
    {0x3064, 0x308c, 0x306a, 0x304b, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 86 ȂƂ...
    {0x306a, 0x3052, 0x3051, 0x3068, 0x3066, 0x0 },
    {0x3064, 0x304d, 0x3084, 0x306f, 0x3082, 0x306e, 0x3092, 0x0 },
    {0x304a, 0x3082, 0x306f, 0x3059, 0x308b, 0x0 },
    {0x304b, 0x3053, 0x3061, 0x304c, 0x307b, 0x306a, 0x308b, 0x0 },
    {0x308f, 0x304c, 0x306a, 0x307f, 0x3060, 0x304b, 0x306a, 0x0 },
  },
  { // 87 ނ炳߂...
    {0x3080, 0x3089, 0x3055, 0x3081, 0x306e, 0x0 },
    {0x3064, 0x3086, 0x3082, 0x307e, 0x3060, 0x3072, 0x306c, 0x0 },
    {0x307e, 0x304d, 0x306e, 0x306f, 0x306b, 0x0 },
    {0x304d, 0x308a, 0x305f, 0x3061, 0x306e, 0x307c, 0x308b, 0x0 },
    {0x3042, 0x304d, 0x306e, 0x3086, 0x3075, 0x3050, 0x308c, 0x0 },
  },
  { // 88 Ȃɂ͂...
    {0x306a, 0x306b, 0x306f, 0x3048, 0x306e, 0x0 },
    {0x3042, 0x3057, 0x306e, 0x304b, 0x308a, 0x306d, 0x306e, 0x0 },
    {0x3072, 0x3068, 0x3088, 0x3086, 0x3091, 0x0 },
    {0x307f, 0x3092, 0x3064, 0x304f, 0x3057, 0x3066, 0x3084, 0x0 },
    {0x3053, 0x3072, 0x308f, 0x305f, 0x308b, 0x3079, 0x304d, 0x0 },
  },
  { // 89 ܂̂...
    {0x305f, 0x307e, 0x306e, 0x304a, 0x3088, 0x0 },
    {0x305f, 0x3048, 0x306a, 0x3070, 0x305f, 0x3048, 0x306d, 0x0 },
    {0x306a, 0x304c, 0x3089, 0x3078, 0x3070, 0x0 },
    {0x3057, 0x306e, 0x3076, 0x308b, 0x3053, 0x3068, 0x306e, 0x0 },
    {0x3088, 0x306f, 0x308a, 0x3082, 0x305e, 0x3059, 0x308b, 0x0 },
  },
  { // 90 ݂΂...
    {0x307f, 0x305b, 0x3070, 0x3084, 0x306a, 0x0 },
    {0x3092, 0x3058, 0x307e, 0x306e, 0x3042, 0x307e, 0x306e, 0x0 },
    {0x305d, 0x3067, 0x3060, 0x306b, 0x3082, 0x0 },
    {0x306c, 0x308c, 0x306b, 0x305e, 0x306c, 0x308c, 0x3057, 0x0 },
    {0x3044, 0x308d, 0x306f, 0x304b, 0x306f, 0x3089, 0x305a, 0x0 },
  },
  { // 91 肬肷...
    {0x304d, 0x308a, 0x304e, 0x308a, 0x3059, 0x0 },
    {0x306a, 0x304f, 0x3084, 0x3057, 0x3082, 0x3088, 0x306e, 0x0 },
    {0x3055, 0x3080, 0x3057, 0x308d, 0x306b, 0x0 },
    {0x3053, 0x308d, 0x3082, 0x304b, 0x305f, 0x3057, 0x304d, 0x0 },
    {0x3072, 0x3068, 0x308a, 0x304b, 0x3082, 0x306d, 0x3080, 0x0 },
  },
  { // 92 킪ł...
    {0x308f, 0x304c, 0x305d, 0x3067, 0x306f, 0x0 },
    {0x3057, 0x307b, 0x3072, 0x306b, 0x307f, 0x3048, 0x306c, 0x0 },
    {0x304a, 0x304d, 0x306e, 0x3044, 0x3057, 0x306e, 0x0 },
    {0x3072, 0x3068, 0x3053, 0x305d, 0x3057, 0x3089, 0x306d, 0x0 },
    {0x304b, 0x308f, 0x304f, 0x307e, 0x3082, 0x306a, 0x3057, 0x0 },
  },
  { // 93 ̂Ȃ...
    {0x3088, 0x306e, 0x306a, 0x304b, 0x306f, 0x0 },
    {0x3064, 0x306d, 0x306b, 0x3082, 0x304c, 0x3082, 0x306a, 0x0 },
    {0x306a, 0x304e, 0x3055, 0x3053, 0x3050, 0x0 },
    {0x3042, 0x307e, 0x306e, 0x3092, 0x3076, 0x306d, 0x306e, 0x0 },
    {0x3064, 0x306a, 0x3067, 0x304b, 0x306a, 0x3057, 0x3082, 0x0 },
  },
  { // 94 ݂悵̂...
    {0x307f, 0x3088, 0x3057, 0x306e, 0x306e, 0x0 },
    {0x3084, 0x307e, 0x306e, 0x3042, 0x304d, 0x304b, 0x305c, 0x0 },
    {0x3055, 0x3088, 0x3075, 0x3051, 0x3066, 0x0 },
    {0x3075, 0x308b, 0x3055, 0x3068, 0x3055, 0x3080, 0x304f, 0x0 },
    {0x3053, 0x308d, 0x3082, 0x3046, 0x3064, 0x306a, 0x308a, 0x0 },
  },
  { // 95 قȂ...
    {0x304a, 0x307b, 0x3051, 0x306a, 0x304f, 0x0 },
    {0x3046, 0x304d, 0x3088, 0x306e, 0x305f, 0x307f, 0x306b, 0x0 },
    {0x304a, 0x307b, 0x3075, 0x304b, 0x306a, 0x0 },
    {0x308f, 0x304c, 0x305f, 0x3064, 0x305d, 0x307e, 0x306b, 0x0 },
    {0x3059, 0x307f, 0x305e, 0x3081, 0x306e, 0x305d, 0x3067, 0x0 },
  },
  { // 96 ͂Ȃ...
    {0x306f, 0x306a, 0x3055, 0x305d, 0x3075, 0x0 },
    {0x3042, 0x3089, 0x3057, 0x306e, 0x306b, 0x306f, 0x306e, 0x0 },
    {0x3086, 0x304d, 0x306a, 0x3089, 0x3067, 0x0 },
    {0x3075, 0x308a, 0x3086, 0x304f, 0x3082, 0x306e, 0x306f, 0x0 },
    {0x308f, 0x304c, 0x307f, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
  { // 97 ʂЂƂ...
    {0x3053, 0x306c, 0x3072, 0x3068, 0x3092, 0x0 },
    {0x307e, 0x3064, 0x307b, 0x306e, 0x3046, 0x3089, 0x306e, 0x0 },
    {0x3086, 0x3046, 0x306a, 0x304e, 0x306b, 0x0 },
    {0x3084, 0x304f, 0x3084, 0x3082, 0x3057, 0x307b, 0x306e, 0x0 },
    {0x307f, 0x3082, 0x3053, 0x304c, 0x308c, 0x3064, 0x3064, 0x0 },
  },
  { // 98 悮...
    {0x304b, 0x305c, 0x305d, 0x3088, 0x3050, 0x0 },
    {0x306a, 0x3089, 0x306e, 0x3092, 0x304c, 0x306f, 0x306e, 0x0 },
    {0x3086, 0x3075, 0x3050, 0x308c, 0x306f, 0x0 },
    {0x307f, 0x305d, 0x304e, 0x305e, 0x306a, 0x3064, 0x306e, 0x0 },
    {0x3057, 0x308b, 0x3057, 0x306a, 0x308a, 0x3051, 0x308b, 0x0 },
  },
  { // 99 ЂƂ...
    {0x3072, 0x3068, 0x3082, 0x3092, 0x3057, 0x0 },
    {0x3072, 0x3068, 0x3082, 0x3046, 0x3089, 0x3081, 0x3057, 0x0 },
    {0x3042, 0x3062, 0x304d, 0x306a, 0x304f, 0x0 },
    {0x3088, 0x3092, 0x304a, 0x3082, 0x3075, 0x3086, 0x3091, 0x306b, 0x0 },
    {0x3082, 0x306e, 0x304a, 0x3082, 0x3075, 0x307f, 0x306f, 0x0 },
  },
  { // 100 ...
    {0x3082, 0x3082, 0x3057, 0x304d, 0x3084, 0x0 },
    {0x3075, 0x308b, 0x304d, 0x306e, 0x304d, 0x3070, 0x306e, 0x0 },
    {0x3057, 0x306e, 0x3076, 0x306b, 0x3082, 0x0 },
    {0x306a, 0x307b, 0x3042, 0x307e, 0x308a, 0x3042, 0x308b, 0x0 },
    {0x3080, 0x304b, 0x3057, 0x306a, 0x308a, 0x3051, 0x308a, 0x0 },
  },
};

#endif /* !WAKA_DATA_H */
