/*!
  \file
  \brief ^CsOK̃j[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "PracticeMenu.h"
#include "PracticeMenu_uni.h"
#include "PracticeNum_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ShimonokuPractice.h"
#include "KimarijiPractice.h"
#include "CommonResources.h"
#include "AccessSettings.h"
#include "ResourceDefinition.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "ComboBoxComponent.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct PracticeMenu::pImpl {
  CommonResources* common;
  TtfResource* font;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;
  boost::shared_ptr<ComboBoxComponent> num_combobox_;

  pImpl(void)
    : common(CommonResources::getObject()),
      font(common->font),
      title_property(font, PracticeMenu_title, TitleSize,
                     Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent),
      num_combobox_(new ComboBoxComponent)
  {

    SDL_Rect position;
    // !!! 640, 480 ܂̒萔͒u
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      PracticeMenu_shimonoku, PracticeMenu_kimariji, PracticeMenu_back,
    };

    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);
    menu->setIconComponent(common->menu_icon, IconOffset, 0, Middle | Left);

    // R{{bNX̍쐬
    num_combobox_->setFrameColor(Pink);
    num_combobox_->setDecidedBackgroundColor(Pink);
    num_combobox_->setSelectedBackgroundColor(Pink);
    num_combobox_->setRightOffset(TextOffset);

    Uint16 dummy[] = { 0x0 };
    TextProperty normal(common->font, dummy, NormalSize, Fore, Pink, false);
    TextProperty selected(common->font, dummy, NormalSize, Blue, Pink, false);

    const Uint16* num_text[] = {
      PracticeNum_5, PracticeNum_10, PracticeNum_50, PracticeNum_100,
    };
    for (size_t i = 0; i < sizeof(num_text)/sizeof(num_text[0]); ++i) {
      normal.utext = num_text[i];
      selected.utext = num_text[i];
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      num_combobox_->addItem(new_button);
    }
    num_combobox_->setSelected(common->getPracticeNumIndex());

    // R|[lg̔zu
    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);

    // ʒuݒ
    set_SdlRect(&position,
                rightPosition(num_combobox_, 640) - TextOffset,
                TextOffset + NormalSize + TextOffset);
    num_combobox_->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
    common->front_layer->push_front(common->user_label);
    common->front_layer->push_front(num_combobox_);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
    common->front_layer->remove(common->user_label);
    common->front_layer->remove(num_combobox_);
  }

  // y̒~
  void stopMusic(void) {
    common->stopMusic(StopFadeOut);
  }

  void playMusic(void) {
    common->setNextMusic(BackMusic_1);
  }
};


PracticeMenu::PracticeMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


PracticeMenu::~PracticeMenu(void) {
  pimpl->removeComponents();
}


void PracticeMenu::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    // R{{bNXɂK̕ύX
    if (pimpl->num_combobox_->isSelectChanged()) {
      pimpl->common->setPracticeNumIndex(pimpl->num_combobox_->getSelected());
      pimpl->common->settings->save();
    }

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {

      // 艹炷
      pimpl->common->playEffect(Decide);

      pimpl->removeComponents();
      if (selected == 0) {
        // ̋^CsO
        pimpl->stopMusic();
        ShimonokuPractice shimonoku_practice;
        shimonoku_practice.run();
        pimpl->playMusic();

      } else if (selected == 1) {
        // ܂莚^CsO
        pimpl->stopMusic();

        KimarijiPractice kimariji_practice;
        kimariji_practice.run();
        pimpl->playMusic();

      } else if (selected == 2) {
        // ߂
        quit |= true;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    gui->update();
    quit |= input.isReleased(SDLK_ESCAPE);
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    delay(1);
  }
}
