/*!
  \file
  \brief HTTP ANZX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "HttpAccess.h"
#include "NetInit.h"
#include "TcpipCtrl.h"
#include <string>

using namespace beego;


struct HttpAccess::pImpl : private NetInit {
  std::string error_message_;
  TcpipCtrl con_;
  std::string server_;

  pImpl(const char* server, long port)
    : error_message_("no error."), server_(server) {

    if (! con_.connect(server, 80)) {
      // !!! G[ LogManager oׂ͂
      //fprintf(stderr, "HttpAccess::pImpl::connect: %s\n", con_.what());

      error_message_ = con_.what();

      // !!! ́AłΗO𓊂ׂ
      // !!! ȃIuWFNg̐ׂł͂Ȃ
      return;
    }
  }

  bool isLF(char ch) {
    return ((ch == '\n') || (ch == '\r')) ? true : false;
  }
};


HttpAccess::HttpAccess(const char* server, long port)
  : pimpl(new pImpl(server, port)) {
}


HttpAccess::~HttpAccess(void) {
}


const char* HttpAccess::what(void) {
  return pimpl->error_message_.c_str();
}


bool HttpAccess::get(std::vector<char>& page, const char* address) {
  if (! pimpl->con_.isConnected()) {
    return false;
  }

  // !!! CR, LF 𕶎R[hŎw肷ׂ
  // !!! \n ̉߂AOS ɂĈقȂ邽
  std::string request =
    "GET " + std::string(address) + " HTTP/1.0\r\n"
    "Host: " + pimpl->server_ + "\r\n"
    "\r\n";

  //fprintf(stderr, "request: %s\n", request.c_str());
  pimpl->con_.send(request.c_str(), static_cast<int>(request.size()));

  // !!! ƁAˁH
  // !!! [v炵āAЂǂH
  int lf_count = 0;
  char ch;
  int n;
  bool now_header = true;
  do {
    n = pimpl->con_.recv(&ch, 1, 1000);
    if (n > 0) {

      if (! now_header) {
        page.push_back(ch);
      }

      if (pimpl->isLF(ch)) {
        ++lf_count;
        if (lf_count >= 4) {
          now_header = false;
        }
      } else {
        lf_count = 0;
      }
    }
  } while (n > 0);

  return true;
}
