/*!
  \file
  \brief â̕`

  \author Satofumi KAMIMURA

  $Id$
*/

#include "WakaDrawer.h"
#include "WakaData.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "CommonResources.h"
#include "bs_bmp.h"
#include "return_bmp.h"
#include "CreateSurfaceFromArray.h"
#include "GuiManager.h"
#include "Layer.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "TextFadeSurface.h"
#include "TextRubiSurface.h"
#include "SdlSurface.h"
#include "LabelComponent.h"
#include "SdlUtils.h"
#include "GetTicks.h"
#include <string>

using namespace beego;


struct WakaDrawer::pImpl {
  enum {
    Base_Y = 40,
    Offset_Y = 30,
  };
  TypingMode typing_mode;
  CommonResources* common;
  size_t index;
  std::vector<boost::shared_ptr<TextFadeSurface> > ku_surface;
  std::vector<boost::shared_ptr<LabelComponent> > ku_label;
  std::vector<boost::shared_ptr<TextRubiSurface> > rubi_surface;
  std::vector<boost::shared_ptr<LabelComponent> > rubi_label;
  boost::shared_ptr<TextSurface> roman_surface;
  Component roman_label;
  std::vector<boost::shared_ptr<TextSurface> > kana_surface;
  std::vector<boost::shared_ptr<LabelComponent> > kana_label;
  std::vector<boost::shared_ptr<TextSurface> > kimariji_kana_surface;
  std::vector<boost::shared_ptr<LabelComponent> > kimariji_kana_label;
  boost::shared_ptr<TextFadeSurface> yomibito_surface;
  boost::shared_ptr<TextRubiSurface> yomibito_rubi_surface;
  Component yomibito_label;
  Component yomibito_rubi_label;
  Surface bs_surface;
  Component bs_label;
  Surface return_surface;
  Component return_label;
  bool draw_bs;
  size_t first_msec;
  bool input_sample_draw[2];
  size_t ku_index;
  bool sample_placed;

  pImpl(TypingMode mode)
    : typing_mode(mode), common(CommonResources::getObject()),
      index(0), bs_surface(new SdlSurface(createSurface(bs_bmp, bs_bmp_width,
                                                        bs_bmp_height), true)),
      bs_label(new LabelComponent(bs_surface)),
      return_surface(new SdlSurface(createSurface(return_bmp, return_bmp_width,
                                                  return_bmp_height), true)),
      return_label(new LabelComponent(return_surface)), draw_bs(false),
      ku_index(0), sample_placed(false) {

    ku_surface.resize(5);
    ku_label.resize(5);
    rubi_surface.resize(5);
    rubi_label.resize(5);
    kana_surface.resize(2);
    kana_label.resize(2);
    kimariji_kana_surface.resize(2);
    kimariji_kana_label.resize(2);
  }

  void createWakaResource(size_t ku_index) {

    // ãT[tFX̐
    TextProperty waka_property(common->font, KanjiWaka[index][ku_index],
                               WakaDrawSize, Fore, Back, true);
    boost::shared_ptr<TextFadeSurface>
      new_ku_surface(new TextFadeSurface(waka_property));
    std::swap(ku_surface[ku_index], new_ku_surface);
    ku_surface[ku_index]->setFadePercent(0);

    boost::shared_ptr<LabelComponent>
      new_ku_label(new LabelComponent(ku_surface[ku_index]));
    std::swap(ku_label[ku_index], new_ku_label);

    // rT[tFX̐
    TextProperty rubi_property(common->font, KanjiWaka[index][ku_index],
                               WakaDrawSize, Fore, Back, true);
    boost::shared_ptr<TextRubiSurface>
      new_rubi_surface(new TextRubiSurface(KanaWaka[index][ku_index],
                                           RubiDrawSize, rubi_property));
    std::swap(rubi_surface[ku_index], new_rubi_surface);
    rubi_surface[ku_index]->setFadePercent(0);

    boost::shared_ptr<LabelComponent>
      new_rubi_label(new LabelComponent(rubi_surface[ku_index]));
    std::swap(rubi_label[ku_index], new_rubi_label);
  }

  void createKanaResource(const std::vector<std::vector<Uint16> >& text) {
    for (int i = 0; i < 2; ++i) {
      TextProperty kana_property(common->font, &text[i + 3][0],
                                 WakaDrawSize, Fore, Back, true);
      boost::shared_ptr<TextSurface>
        new_kana_surface(new TextSurface(kana_property));
      std::swap(kana_surface[i], new_kana_surface);
      kana_surface[i]->setAlpha(0);

      boost::shared_ptr<LabelComponent>
        new_kana_label(new LabelComponent(kana_surface[i]));
      std::swap(kana_label[i], new_kana_label);

      SDL_Rect position;
      set_SdlRect(&position, (640 - InputWidth)/2 + TextOffset,
                  (480 - InputSize - BottomOffset - SampleOffset));
      kana_label[i]->setPosition(&position);

      if (typing_mode == KimarijiTyping) {
        // ܂莚pɍŏ̂Qʂ̐Fō
        std::vector<Uint16> color_text = text[i + 3];
        color_text[2] = 0x0;

        TextProperty kimariji_property(common->font, &color_text[0],
                                       WakaDrawSize, Selected, Back, true);
        boost::shared_ptr<TextSurface>
          new_kimariji_surface(new TextSurface(kimariji_property));
        std::swap(kimariji_kana_surface[i], new_kimariji_surface);
        kimariji_kana_surface[i]->setAlpha(0);

        boost::shared_ptr<LabelComponent>
          new_kimariji_label(new LabelComponent(kimariji_kana_surface[i]));
        std::swap(kimariji_kana_label[i], new_kimariji_label);
        kimariji_kana_label[i]->setPosition(&position);
      }
    }
  }

  void createRomanResource(const std::string& text) {

    TextProperty roman_property(common->font, text.c_str(),
                                RomanSize, Fore, Back, true);
    boost::shared_ptr<TextSurface>
      new_roman_surface(new TextSurface(roman_property));
    std::swap(roman_surface, new_roman_surface);
    if (! input_sample_draw[ku_index]) {
      roman_surface->setAlpha(0);
    }

    Component new_roman_label(new LabelComponent(roman_surface));
    std::swap(roman_label, new_roman_label);
  }

  void createYomibitoResource(void) {

    // rݐl()
    TextProperty yomibito_property(common->font,
                                   YomibitoName[index][0],
                                   YomibitoDrawSize, Fore, Back, true);
    boost::shared_ptr<TextFadeSurface>
      new_surface(new TextFadeSurface(yomibito_property));
    std::swap(yomibito_surface, new_surface);
    yomibito_surface->setFadePercent(0);

    Component new_label(new LabelComponent(yomibito_surface));
    std::swap(yomibito_label, new_label);

    // rݐl()
    boost::shared_ptr<TextRubiSurface>
      new_rubi_surface(new TextRubiSurface(YomibitoName[index][1],
                                           YomibitoRubiDrawSize,
                                           yomibito_property));
    std::swap(yomibito_rubi_surface, new_rubi_surface);
    yomibito_rubi_surface->setFadePercent(0);

    Component new_rubi_label(new LabelComponent(yomibito_rubi_surface));
    std::swap(yomibito_rubi_label, new_rubi_label);
  }

  void placeInputSampleComponents(void) {
    if (sample_placed != false) {
      return;
    }
    sample_placed = true;

    placeRomanResource();
    common->front_layer->push_front(kana_label[ku_index]);
    if (typing_mode == KimarijiTyping) {
      common->front_layer->push_front(kimariji_kana_label[ku_index]);
    }
  }

  void removeInputSampleComponents(void) {
    if (sample_placed == false) {
      return;
    }
    sample_placed = false;

    for (size_t i = 0; i < 2; ++i) {
      common->front_layer->remove(kana_label[i]);
      if (typing_mode == KimarijiTyping) {
        common->front_layer->remove(kimariji_kana_label[i]);
      }
    }
    common->front_layer->remove(roman_label);
    common->front_layer->remove(bs_label);
    common->front_layer->remove(return_label);
    SDL_Rect position;
    return_label->getPosition(&position);
  }

  void updateWakaPosition(void) {
    enum {
      SpaceSize = WakaDrawSize * 4/5,
    };
    int length_1st = SpaceSize +
      static_cast<int>(ku_label[0]->getWidth() + ku_label[1]->getWidth());
    int length_3rd = WakaDrawSize + SpaceSize +
      static_cast<int>(ku_label[3]->getWidth() + ku_label[4]->getWidth());
    int length_max = (length_1st > length_3rd) ? length_1st : length_3rd;

    // ő̍s̒ base_x, base_y vZ
    int base_x = (640 - length_max) / 2;
    SDL_Rect position[5];
    set_SdlRect(&position[0], base_x, Base_Y);
    set_SdlRect(&position[1], base_x +
                static_cast<int>(ku_label[0]->getWidth()) + SpaceSize, Base_Y);
    set_SdlRect(&position[2],
                base_x + WakaDrawSize + SpaceSize,
                Base_Y + WakaDrawSize + Offset_Y);
    set_SdlRect(&position[3],
                base_x + WakaDrawSize, Base_Y + (WakaDrawSize + Offset_Y) * 2);
    set_SdlRect(&position[4],
                base_x + WakaDrawSize + SpaceSize +
                static_cast<int>(ku_label[3]->getWidth()),
                Base_Y + (WakaDrawSize + Offset_Y) * 2);

    for (size_t i = 0; i < 5; ++i) {
      ku_label[i]->setPosition(&position[i]);

      SDL_Rect rubi_position = position[i];
      rubi_position.y -= RubiDrawSize;
      rubi_position.x += rubi_surface[i]->getDrawOffset();
      rubi_label[i]->setPosition(&rubi_position);
    }
    SDL_Rect yomibito_position;
    set_SdlRect(&yomibito_position, 640 -
                static_cast<int>(yomibito_label->getWidth()) - WakaDrawSize,
                Base_Y + (WakaDrawSize + Offset_Y) * 3);
    yomibito_label->setPosition(&yomibito_position);

    yomibito_position.y -= RubiDrawSize;
    yomibito_position.x += yomibito_rubi_surface->getDrawOffset();
    yomibito_rubi_label->setPosition(&yomibito_position);
  }

  void placeRomanResource(void) {

    SDL_Rect position;
    set_SdlRect(&position, centerPosition(roman_label, 640/2),
                480 - InputSize * 2 - BottomOffset - TextOffset - RomanOffset);
    roman_label->setPosition(&position);
    if (roman_label->getWidth() > 0) {
      common->front_layer->push_front(roman_label);
    }

    position.y += TextOffset;
    if (draw_bs) {
      position.x =
        640/2 - static_cast<int>(roman_label->getWidth()/2) - RomanSize/2 - 4;
      bs_label->setPosition(&position);
      common->front_layer->push_front(bs_label);
    }

    position.x = 640/2 + static_cast<int>(roman_label->getWidth()/2) + 4;
    return_label->setPosition(&position);
    common->front_layer->push_front(return_label);
    return_label->getPosition(&position);
  }

  void updateWakaAlpha(size_t kaminoku_percent, size_t shimonoku_percent,
                       size_t yomibito_percent) {

    // â̕\
    size_t ku[5];
    ku[0] = kaminoku_percent * 3;
    ku[1] = (kaminoku_percent > 33) ? (kaminoku_percent - 33) * 3 : 0;
    ku[2] = (kaminoku_percent > 66) ? (kaminoku_percent - 66) * 3 : 0;
    ku[3] = shimonoku_percent * 2;
    ku[4] = (shimonoku_percent > 50) ? (shimonoku_percent - 50) * 2 : 0;

    for (int i = 0; i < 5; ++i) {
      ku_surface[i]->setFadePercent(ku[i]);
      rubi_surface[i]->setFadePercent(ku[i]);
    }

    // rݐl̕\
    yomibito_surface->setFadePercent(yomibito_percent);
    yomibito_rubi_surface->setFadePercent(yomibito_percent);
  }
};


WakaDrawer::WakaDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


WakaDrawer::~WakaDrawer(void) {
}


void WakaDrawer::setWakaIndex(size_t index) {

  removeComponents();

  pimpl->index = index;

  for (size_t i = 0; i < 5; ++i) {
    pimpl->createWakaResource(i);
  }
  pimpl->createYomibitoResource();

  // tȌ
  for (size_t i = 0; i < 2; ++i) {
    pimpl->input_sample_draw[i] = false;
  }

  // T[tFX̔zu
  pimpl->updateWakaPosition();
  placeComponents();
}


void WakaDrawer::setInputSample(const std::vector<std::vector<Uint16> >&
                                text, const std::string& roman_sample) {

  // T[tFX̍쐬
  pimpl->createRomanResource(roman_sample);
  pimpl->createKanaResource(text);

  // o^
  //pimpl->placeRomanResource();

  pimpl->first_msec = GetTicks();
}


void WakaDrawer::updateInputSample(const std::vector<std::vector<Uint16> >&
                                   text, size_t ku_index,
                                   const std::string& roman_sample,
                                   bool need_bs) {
  pimpl->draw_bs = need_bs;

  // o^̍폜Ɠo^sƂŁAR|[lg̍ĕ`s

  // o^폜
  pimpl->removeInputSampleComponents();

  // T[tFX̍XV
  pimpl->ku_index = ku_index;
  pimpl->createRomanResource(roman_sample);

  // ēo^
  pimpl->placeInputSampleComponents();
}


void WakaDrawer::draw(void) {

  // `ς݂̃T[tFXɑ΂A\XV
  size_t spent_msec = GetTicks() - pimpl->first_msec;

  // â̕`
  size_t kaminoku_percent = 0;
  size_t shimonoku_percent = 0;
  size_t yomibito_percent = 0;
  if (spent_msec < KaminokuPlaying) {
    // ̋̕`搔lXV
    kaminoku_percent = 100 * spent_msec / KaminokuPlaying;

  } else if (spent_msec < TotalPlaying) {
    // ̋̕`搔lXV
    kaminoku_percent = 100;
    shimonoku_percent =
      100 * (spent_msec - KaminokuPlaying) / ShimonokuPlaying;
  } else {
    kaminoku_percent = 100;
    shimonoku_percent = 100;
    yomibito_percent = 100 * (spent_msec - TotalPlaying) / YomibitoPlaying;
  }
  pimpl->updateWakaAlpha(kaminoku_percent,
                         shimonoku_percent, yomibito_percent);

  if (spent_msec < KaminokuPlaying/3) {
    // !!! ǂݏグ̏(PԖڂ̋)
    // !!!

  } else if (spent_msec < KaminokuPlaying/3*2) {
    // !!! ǂݏグ̏(QԖڂ̋)

  } else if (spent_msec < KaminokuPlaying) {
    // !!! ǂݏグ̏(RԖڂ̋)

  } else if (spent_msec < KaminokuPlaying + ShimonokuPlaying/2) {

    // !!! ǂݏグ̏(SԖڂ̋)

    // !!! ȍ~́AȂƂ֐ׂ
    if (pimpl->ku_index == 0) {
      // ͌̕\(̋APԖ)
      if (! pimpl->input_sample_draw[0]) {
        pimpl->roman_surface->setAlpha(100);
        pimpl->kana_surface[0]->setAlpha(100);
        if (pimpl->typing_mode == KimarijiTyping) {
          pimpl->kimariji_kana_surface[0]->setAlpha(100);
        }
        pimpl->input_sample_draw[0] = true;
      }
    } else {
      pimpl->roman_surface->setAlpha(0);
    }
  } else {
    // !!! ǂݏグ̏(TԖڂ̋)

    if (pimpl->ku_index == 1) {
      // ͌̕\(̋AQԖ)
      if (! pimpl->input_sample_draw[1]) {
        pimpl->roman_surface->setAlpha(100);
        pimpl->kana_surface[1]->setAlpha(100);
        if (pimpl->typing_mode == KimarijiTyping) {
          pimpl->kimariji_kana_surface[1]->setAlpha(100);
        }
        pimpl->input_sample_draw[1] = true;
      }
    }
  }
}


void WakaDrawer::placeComponents(void) {

  for (int i = 0; i < 5; ++i) {
    pimpl->common->front_layer->push_front(pimpl->ku_label[i]);
    if (pimpl->rubi_label[i]->getWidth() > 0) {
      // !!! тȂꍇAo^ƋȂ̂ɑΏ
      // !!! {́ATextRubiSurface ŏCׂA܂AƂ肠
      // !!! C邱
      pimpl->common->front_layer->push_front(pimpl->rubi_label[i]);
    }
  }
  pimpl->common->front_layer->push_front(pimpl->yomibito_label);
  pimpl->common->front_layer->push_front(pimpl->yomibito_rubi_label);
}


void WakaDrawer::removeComponents(void) {

  removeInputComponents();

  for (size_t i = 0; i < 5; ++i) {
    pimpl->common->front_layer->remove(pimpl->ku_label[i]);
    pimpl->common->front_layer->remove(pimpl->rubi_label[i]);
  }
  pimpl->common->front_layer->remove(pimpl->yomibito_label);
  pimpl->common->front_layer->remove(pimpl->yomibito_rubi_label);
}


void WakaDrawer::removeInputComponents(void) {
  pimpl->removeInputSampleComponents();
}
