/*!
  \brief ʃXC_[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "VolumeSliderComponent.h"
#include "Component.h"
#include "ColorSurface.h"
#include "DrawPanelSurface.h"
#include "EvaluateArea.h"
#include "InputEvent.h"
#include "GuiColors.h"
#include "SdlUtils.h"

using namespace beego;


struct VolumeSliderComponent::pImpl {

  enum {
    SliderSurface = 0,
    BackSurface,
    LastIndex,
  };

  size_t width_;
  size_t height_;

  SDL_Rect position_;
  bool position_changed_;

  bool input_enable_;
  size_t value_max_;
  size_t value_;

  Surface slider_;
  boost::shared_ptr<DrawPanelSurface> back_;
  DrawSurface draw_surfaces_[LastIndex];

  pImpl(size_t width, size_t height)
    : width_(width), height_(height), position_changed_(false),
      input_enable_(true), value_max_(100), value_(0),
      slider_(new ColorSurface(12, height_, White)),
      back_(new DrawPanelSurface(width_, height_)) {

    // !!! Ƃ肠ADFœhԂĂ݂
    back_->setBackgroundColor(Gray8);

    set_SdlRect(&position_, 0, 0, width_, height_);
  }

  void addSurfaceList(SurfaceList& surfaces, const SDL_Rect* area,
                      size_t ticks) {

    // XC_[̕`
    size_t x = width_ * value_ / value_max_;
    SDL_Rect draw_rect;
    set_SdlRect(&draw_rect,
                position_.x + x, position_.y,
                slider_->getWidth(), slider_->getHeight());
    updateDrawSurface(draw_surfaces_[SliderSurface],
                      slider_, area, ticks,
                      draw_rect, position_changed_);
    surfaces.push_back(&draw_surfaces_[SliderSurface]);

    // o[̕`
    updateDrawSurface(draw_surfaces_[BackSurface],
                      back_, area, ticks,
                      position_, position_changed_);
    surfaces.push_back(&draw_surfaces_[BackSurface]);

    position_changed_ = false;
  }

  void applyInput(const InputEvent& event,
                  std::vector<SDL_Rect>& applied_rects) {

    if (! input_enable_) {
      return;
    }

    // !!! ύXAposition_changed_  true ɂ

    // ẼJ[\͂őIړ
    // !!! Ɉړ悤ɕύX
    for (std::vector<SDLKey>::const_iterator it = event.key_released.begin();
         it != event.key_released.end(); ++it) {

      if ((value_ > 0) && (*it == SDLK_LEFT)) {
        // 
        --value_;
        position_changed_ = true;

      } else if (value_ < value_max_) {
        // E
        ++value_;
        position_changed_ = true;
      }
    }

    if (event.left_released) {

      SDL_Rect surface_area;
      set_SdlRect(&surface_area, position_.x, position_.y, width_, height_);
      bool cursor_inside = isPointInside(event.mx, event.my, surface_area);
      if (cursor_inside) {
        value_ = value_max_ * (event.mx - position_.x) / width_;
        position_changed_ = true;
      }
    }
  }
};


VolumeSliderComponent::VolumeSliderComponent(size_t width, size_t height)
  : pimpl(new pImpl(width, height)) {
}


VolumeSliderComponent::~VolumeSliderComponent(void) {
}


void VolumeSliderComponent::addSurfaceList(SurfaceList& surfaces,
                                           const SDL_Rect* area,
                                           size_t ticks) {

  pimpl->addSurfaceList(surfaces, area, ticks);
}


void VolumeSliderComponent::setPosition(const SDL_Rect* position) {

  set_SdlRect(&pimpl->position_, position->x, position->y,
              pimpl->position_.w, pimpl->position_.h);
  pimpl->position_changed_ = true;
}


void VolumeSliderComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position_;
}


size_t VolumeSliderComponent::getWidth(void) {
  return pimpl->width_;
}


size_t VolumeSliderComponent::getHeight(void) {
  return pimpl->height_;
}


void VolumeSliderComponent::applyInput(const InputEvent& event,
                                       std::vector<SDL_Rect>& applied_rects) {

  pimpl->applyInput(event, applied_rects);
}


void VolumeSliderComponent::registerLayer(Layer* layer) {
  // !!!
}
