/*!
  \file
  \brief ẩrݏグ

  \author Satofumi KAMIMURA

  $Id$

  \todo ~[gŵƂɁAȂ悤ɂBŎ邩͖
  \todo CD-ROM ̔FA̎|bZ[Wŏoׂ͂
  \todo G[o͂ɂ́Acommon->debug ALogManager g܂傤
*/

#include "VoicePlayer.h"
#include "ResourceDefinition.h"
#include "CdromPlayer.h"
#include "FindFiles.h"
#include <boost/lexical_cast.hpp>
#include <boost/tokenizer.hpp>
#include <boost/xpressive/xpressive.hpp>
#include <string>
#include <fstream>

using namespace beego;
using namespace boost;
using namespace boost::xpressive;


struct VoicePlayer::pImpl {

  enum {
    InvalidTrack = -1,
  };

  /*!
    \brief Đ̊i[p
  */
  typedef struct {
    int track_id;               //!< gbNԍ
    size_t start_frame;         //!< ĐJnt[ʒu
    size_t play_interval;       //!< Đt[Ԋu
  } waka_play_t;

  std::string dir_path_;
  CdromPlayer cdrom_;
  waka_play_t waka_play_[100];

  pImpl(const char* directory) : dir_path_(directory) {
  }

  bool readWakaInfo(const char* waka_file) {

    std::string path = std::string(dir_path_) + waka_file;
    //fprintf(stderr, "%s\n", path.c_str());

    // ȁ̏
    for (size_t i = 0; i < 100; ++i) {
      waka_play_[i].track_id = InvalidTrack;
    }

    // ea̖ɁAȉ̓eǂݏo
    // - gbN
    // - Jnt[ʒu
    // - Đt[Ԋu
    std::ifstream fin(path.c_str());
    std::string line;
    escaped_list_separator<char> esc;
    size_t waka_no = 0;
    while (getline(fin, line)) {

      waka_play_t& play_info = waka_play_[waka_no];
      ++waka_no;

      int index = 0;
      tokenizer<escaped_list_separator<char> > tokens(line, esc);
      for (tokenizer<escaped_list_separator<char> >::iterator it =
             tokens.begin(); it != tokens.end(); ++it, ++index) {
        //fprintf(stderr, "%s, ", it->c_str());
        if (index == 0) {
          play_info.track_id = lexical_cast<int>(*it);
        } else if (index == 1) {
          play_info.start_frame = lexical_cast<int>(*it);
        } else if (index == 2) {
          play_info.play_interval = lexical_cast<int>(*it);
        }
      }
      if (index != 3) {
        return false;
      }
    }
    if (waka_no != 100) {
      return false;
    }

    return true;
  }

  void fileTracInfo(std::vector<int>& file_trac_info,
                    const char* fname) {

    std::ifstream fin(fname);
    std::string line;
    while (getline(fin, line)) {

      // !!! Ƃ肠AID ͏ԂɂȂłƉ肵Ă܂
      file_trac_info.push_back(atoi(line.c_str()));
    }
  }
};


VoicePlayer::VoicePlayer(const char* directory)
  : pimpl(new pImpl(directory)) {
}


VoicePlayer::~VoicePlayer(void) {
}


bool VoicePlayer::checkCd(void) {

  // cd_XXXX.txt t@C̒T
  std::vector<std::string> cd_files;
  size_t n = findFiles(cd_files, pimpl->dir_path_.c_str(),
                       sregex::compile("cd_[a-zA-Z0-9]+.txt"));
  if (n == 0) {
    return false;
  }

  // CD-ROM ̓ǂݏo
  std::vector<CdromPlayer::track_t> trac_info;
  bool exist_cd = pimpl->cdrom_.getTrackList(trac_info);
  if (exist_cd == false) {
    return false;
  }

  // ݂t@Cɑ΂āACD-ROM f[^Ƃ̃`FbNs
  for (std::vector<std::string>::iterator it = cd_files.begin();
       it != cd_files.end(); ++it) {
    //fprintf(stderr, "check: %s\n", it->c_str());

    // v waka_XXXX.txt t@C̓ǂݏo
    std::vector<int> file_trac_info;
    pimpl->fileTracInfo(file_trac_info, it->c_str());
    if (file_trac_info.size() != trac_info.size()) {
      // R[hvȂ
      //fprintf(stderr, "record mismatch.\n");
      continue;
    }

    size_t index = 0;
    for (std::vector<CdromPlayer::track_t>::iterator fit = trac_info.begin();
         fit != trac_info.end(); ++fit, ++index) {

      // t[ }1 ̍ĂAƂ݂Ȃ
      // Windows, Linux ŁAŌ̃gbN̒ 1 قȂ邽߁Bڍוs
      if (abs(fit->frame_length - file_trac_info[index]) > 1) {
        //fprintf(stderr, "mismatch %d: %d, %d\n", index, fit->frame_length, file_trac_info[index]);
        break;
      }
    }
    if (index == trac_info.size()) {

      const char* path = it->c_str();
      const char* last_slash = strrchr(path, '/') + 1;
      std::string file_name = it->substr(last_slash - path, std::string::npos);
      std::string tag = file_name.substr(3);
      return pimpl->readWakaInfo(("waka_" + tag).c_str());
    }
    //fprintf(stderr, "index, track = %d, %d\n", index, trac_info.size());
  }

  // v CD-ROM 񂪌Ȃ
  //fprintf(stderr, "no CD-ROM in list.\n");
  return false;
}


void VoicePlayer::play(size_t id) {

  // w肳ꂽãf[^̍Đ
  pImpl::waka_play_t& waka = pimpl->waka_play_[id];
  //fprintf(stderr, "%d, %d, %d\n", waka.track_id, waka.start_frame, waka.play_interval);
  pimpl->cdrom_.play(waka.track_id - 1, waka.start_frame, waka.play_interval);
}


void VoicePlayer::stop(void) {

  // Đ~
  pimpl->cdrom_.stop();
}
