/*!
  \file
  \brief [U폜

  \author Satofumi KAMIMURA

  $Id$

  \todo uIvACRƋɍ폜bZ[W\AƂH
*/

#include "RemoveUser.h"
#include "RemoveUser_uni.h"
#include "CommonResources.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "AccessSettings.h"
#include "arrow_bmp.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "SdlSurface.h"
#include "SwitchSurface.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "ColorSurface.h"
#include "LabelComponent.h"
#include "SwitchLabelComponent.h"
#include "ButtonComponent.h"
#include "MenuComponent.h"
#include "SelectComponent.h"
#include "CreateSurfaceFromArray.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "SdlUtils.h"
#include "Delay.h"
#include "UtfString.h"

using namespace beego;


struct RemoveUser::pImpl {

  enum { MessageY = 285 };

  class Schedule : public BaseEntity {
    StateMachine<Schedule>* state_machine;
    bool is_terminated;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      type->changeState(SelectUserState::getObject(common));
    }

    void exit(Schedule* type) {
    }
  };

  class SelectUserState : public State<Schedule> {
    enum {
      RectWidth = MenuSize * 18/2,
    };
    CommonResources* common;
    boost::shared_ptr<MenuComponent> menu_;
    Surface back_surface_;
    Component back_label_;
    Surface arrow_surface_;
    Component arrow_label_;
    boost::shared_ptr<SwitchSurface> message_;
    Component message_label_;

    SelectUserState(CommonResources* common_obj)
      : common(common_obj), menu_(new MenuComponent),
        back_surface_(new ColorSurface(RectWidth,
                                       MenuSize * (UserMax + 1), Black)),
        back_label_(new LabelComponent(back_surface_)),
        arrow_surface_(new SdlSurface(createSurface(arrow_bmp,
                                                    arrow_bmp_width,
                                                    arrow_bmp_height), true)),
        arrow_label_(new LabelComponent(arrow_surface_)) {
    }

  public:
    static SelectUserState* getObject(CommonResources* common) {
      static SelectUserState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // [Uꗗj[̍쐬
      int user_num = 0;
      size_t max_width = 0;
      menu_->clearItems();
      for (std::vector<std::string>::iterator it =
             common->settings->user_names_.begin();
           it != common->settings->user_names_.end(); ++it) {

        const char* user_name = it->c_str();
        if (strlen(user_name) <= 0) {
          continue;
        }
        ++user_num;

        // [Uڂ̒ǉ
        boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
        TextProperty normal(common->font, user_name, MenuSize,
                            White, Gray3, true);
        TextProperty selected(common->font, user_name, MenuSize,
                              White, Gray3, true);
        ButtonComponent::createButton(new_button, normal, selected, selected);
        if (new_button->getWidth() > max_width) {
          max_width = new_button->getWidth();
        }
        menu_->addItem(new_button);
      }
      menu_->setItemsOffset(0, MenuSize);
      menu_->setItemSelectWidth(max_width);
      menu_->setIconComponent(arrow_label_, -24, 3, Middle | Left);
      menu_->releaseDecided();

      // \bZ[W̍쐬
      boost::shared_ptr<SwitchSurface> new_message(new SwitchSurface);
      std::swap(message_, new_message);
      int index = 0;
      for (std::vector<std::string>::iterator it =
             common->settings->user_names_.begin();
           it != common->settings->user_names_.end(); ++it, ++index) {

        const char* user_name = it->c_str();
        if (strlen(user_name) <= 0) {
          continue;
        }

        if (index == 0) {
          // uftHg[U͍폜ł܂v
          TextProperty no_remove(common->font, RemoveUser_no_remove,
                                 NormalSize, Fore, Back, true);
          Surface no_remove_surface(new TextSurface(no_remove));
          message_->registerSurface(no_remove_surface, 0, 0, index);

        } else {
          // u"[U" 폜܂v
          std::vector<Uint16> text;
          ustrcat(text, user_name);
          ustrcat(text, RemoveUser_remove);
          TextProperty text_property(common->font, &text[0],
                                     NormalSize, Fore, Back, true);
          Surface surface(new TextSurface(text_property));
          message_->registerSurface(surface, 0, 0, index);
        }
      }
      // j[̏ݒ̍XV
      if (user_num > 1) {
        menu_->setSelected(1);
        message_->switchSurface(1);
      } else {
        // ftHg[UAȂƂ
        menu_->setSelected(0);
        message_->switchSurface(0);
      }

      int mode = SwitchLabelComponent::Center;
      Component new_message_label(new SwitchLabelComponent(message_, mode));
      std::swap(message_label_, new_message_label);

      // ʒu̎w
      SDL_Rect position;
      set_SdlRect(&position, centerPosition(menu_, 640/2), 480/5);
      menu_->setPosition(&position);

      set_SdlRect(&position, centerPosition(back_label_, 640/2), 480/5);
      back_label_->setPosition(&position);

      set_SdlRect(&position, centerPosition(message_label_, 640/2),
                  MessageY);
      message_label_->setPosition(&position);

      placeComponents();
    }

    void execute(Schedule* type) {
      // bZ[W̕\؂ւ
      message_->switchSurface(menu_->getSelected());

      int decided = menu_->getDecided();
      if (decided == 0) {
        // ftHg[UB폜Ȃ
        menu_->releaseDecided();
      } else if (decided > 0) {
        // 폜mF
        type->changeState(YesNoState::getObject(common));
      }
    }

    void exit(Schedule* type) {
    }

    void placeComponents(void) {

      common->front_layer->push_front(back_label_);
      common->front_layer->push_front(menu_);
      common->front_layer->push_front(message_label_);
    }

    void removeComponents(void) {

      common->front_layer->remove(back_label_);
      common->front_layer->remove(menu_);
      common->front_layer->remove(message_label_);
    }

    int getRemoveUserIndex(void) {
      return menu_->getDecided();
    }
  };

  class YesNoState : public State<Schedule> {
    CommonResources* common;
    TextProperty yes_no_property;
    Surface yes_no_surface;
    Component yes_no_label;
    TextProperty selector_property;
    boost::shared_ptr<SelectComponent> selector;

    YesNoState(CommonResources* common_obj)
      : common(common_obj),
        yes_no_property(common->font, RemoveUser_yes_no,
                        NormalSize, Fore, Back, true),
        yes_no_surface(new TextSurface(yes_no_property)),
        yes_no_label(new LabelComponent(yes_no_surface)),
        selector_property(common->font, "", NormalSize, Fore, Back, true),
        selector(new SelectComponent(selector_property, White,
                                     SelectComponent::UnderBar)) {

      selector->addItem("Yes");
      selector->addItem("No");
      selector->setItemsOffset(16);
      selector->enableInput();
    }

  public:
    static YesNoState* getObject(CommonResources* common) {
      static YesNoState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // u{ɂ낵łHv̔zu
      SDL_Rect position;
      set_SdlRect(&position, centerPosition(yes_no_label, 640/2),
                  MessageY + NormalSize + TextOffset);
      yes_no_label->setPosition(&position);

      // uYes / Nov̔zu
      set_SdlRect(&position, centerPosition(selector, 640/2),
                  position.y + NormalSize + TextOffset);
      selector->setPosition(&position);
      selector->releaseDecided();
      selector->setSelected(1);

      placeComponents();
    }

    void execute(Schedule* type) {

      int decided = selector->getDecided();
      if (decided >= 0) {
        if (decided == 0) {
          // Yes
          int remove_index =
            SelectUserState::getObject(common)->getRemoveUserIndex();
          common->deleteUser(remove_index);
        }
        type->changeState(SelectUserState::getObject(common));
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {
      common->front_layer->push_front(yes_no_label);
      common->front_layer->push_front(selector);
    }

    void removeComponents(void) {
      SelectUserState::getObject(common)->removeComponents();
      common->front_layer->remove(yes_no_label);
      common->front_layer->remove(selector);
    }
  };

  CommonResources* common;
  Schedule scheduler;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  TextProperty back_property;
  Surface back_surface;
  Component back_label;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(0, common),
      title_property(common->font, RemoveUser_title,
                     MenuSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)),
      back_property(common->font, RemoveUser_back_message,
                    NormalSize, Fore, Back, true),
      back_surface(new TextSurface(back_property)),
      back_label(new LabelComponent(back_surface)) {

    // ^Cgʒu
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                topPosition(title_label, 0) + TextOffset * 3);
    title_label->setPosition(&position);

    // ߂邽߂̃bZ[Wʒu
    set_SdlRect(&position, rightPosition(back_label, 640) - TextOffset,
                bottomPosition(back_label, 480) - TextOffset);
    back_label->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(back_label);
  }

  void removeComponents(void) {
    YesNoState::getObject(common)->removeComponents();
    common->front_layer->remove(title_label);
    common->front_layer->remove(back_label);
  }
};


RemoveUser::RemoveUser(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


RemoveUser::~RemoveUser(void) {
  pimpl->removeComponents();
}


void RemoveUser::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  bool escape_pressed = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    quit |= pimpl->scheduler.isTerminated();
    gui->update();
    input.update_all();
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    escape_pressed |= input.isPressed(SDLK_ESCAPE);
    if (escape_pressed && input.isReleased(SDLK_ESCAPE)) {
      quit |= true;
    }
    delay(1);
  }
}
