/*!
  \file
  \brief ^CsOK̃j[

  \author Satofumi KAMIMURA

  $Id$

  \todo â̗KR{{bNXőI\ɂ
*/

#include "PracticeMenu.h"
#include "PracticeMenu_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ShimonokuPractice.h"
#include "KimarijiPractice.h"
#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct PracticeMenu::pImpl {
  CommonResources* common;
  TtfResource* font;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;

  pImpl(void)
    : common(CommonResources::getObject()),
      font(common->font),
      title_property(font, PracticeMenu_title, TitleSize,
                     Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent) {

    SDL_Rect position;
    // !!! 640, 480 ܂̒萔͒u
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      PracticeMenu_shimonoku, PracticeMenu_kimariji, PracticeMenu_back,
    };

    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);
    menu->setIconComponent(common->menu_icon, IconOffset, 0, Middle | Left);

    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);
    //fprintf(stderr, "practice_menu: %d, %d\n", position.x, position.y);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
    common->front_layer->push_front(common->user_label);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
    common->front_layer->remove(common->user_label);
  }

  // y̒~
  void stopMusic(void) {
    if (common->music) {
      common->music->stop(StopFadeOut);
    }
  }

  void playMusic(void) {
    if (common->music) {
      common->music->setNextMusic(BackMusic_1);
    }
  }
};


PracticeMenu::PracticeMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


PracticeMenu::~PracticeMenu(void) {
  pimpl->removeComponents();
}


void PracticeMenu::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {

      // !!! Ƃ肠AŌ艹炷
      // !!! Is\ȍڂ肵ƂɉςȂAύX
      if (pimpl->common->music) {
        pimpl->common->sound_effect->play(Decide);
      }

      pimpl->removeComponents();
      if (selected == 0) {
        // ̋^CsO
        pimpl->stopMusic();
        ShimonokuPractice shimonoku_practice;
        shimonoku_practice.run();
        pimpl->playMusic();

      } else if (selected == 1) {
        // ܂莚^CsO
        pimpl->stopMusic();

        KimarijiPractice kimariji_practice;
        kimariji_practice.run();
        pimpl->playMusic();

      } else if (selected == 2) {
        // ߂
        quit |= true;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    gui->update();
    quit |= input.isReleased(SDLK_ESCAPE);
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    delay(1);
  }
}
