/*!
  \file
  \brief IvVj[

  \author Satofumi KAMIMURA

  $Id$

  \todo ڂ̐̓|bvAbvōs
  \todo "guest" [ÛƂ́AT[oւ̃f[^M disable ɂ
  \todo ʉ̉ʊmFp{^Azu
  \todo `FbN{bNX̑ÎC
  \todo `FbN{bNX̐Fݒ𒲐
  \todo VolumeSliderComponent iD悭
*/

#include "OptionMenu.h"
#include "OptionMenu_uni.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "GuiManager.h"
#include "Layer.h"
#include "OptionMenuComponent.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "SelectComponent.h"
#include "CheckBoxComponent.h"
#include "VolumeSliderComponent.h"
#include "ComboBoxComponent.h"
#include "ButtonComponent.h"
#include "InputHandler.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct OptionMenu::pImpl {

  enum {
    OptionSize = NormalSize - 1, //!< IvṼTCY
    PlaceOffset = 170,           //!< R|[lg̔zuItZbg
    ItemsOffset = 19,            //!< Iڂ̔zuԊu
    TitleX = 50,                 //!< ڃ^Cg̈ʒu
    VLength = 250,               //!< {[XC_[
  };

  CommonResources* common_;
  boost::shared_ptr<OptionMenuComponent> option_;
  TextProperty base_property_;
  TextProperty title_property_;
  Surface title_surface_;
  Component title_label_;
  TextProperty escape_property_;
  Surface escape_surface_;
  Component escape_label_;
  TextProperty typing_property_;
  Surface typing_surface_;
  Component typing_label_;
  TextProperty sound_property_;
  Surface sound_surface_;
  Component sound_label_;
  TextProperty system_property_;
  Surface system_surface_;
  Component system_label_;
  boost::shared_ptr<SelectComponent> practice_num_selector_;
  boost::shared_ptr<SelectComponent> practice_input_selector_;
  boost::shared_ptr<CheckBoxComponent> practice_eachtime_cbox_;
  boost::shared_ptr<VolumeSliderComponent> sound_music_vslider_;
  boost::shared_ptr<VolumeSliderComponent> sound_effect_vslider_;
  boost::shared_ptr<ComboBoxComponent> sound_voice_combox_;
  boost::shared_ptr<CheckBoxComponent> system_full_cbox_;
  boost::shared_ptr<CheckBoxComponent> system_send_cbox_;

  pImpl(void)
    : common_(CommonResources::getObject()),
      option_(new OptionMenuComponent),
      base_property_(common_->font, "", OptionSize, Fore, Back, true),
      title_property_(common_->font, OptionMenu_title,
                      MenuSize, Fore, Back, true),
      title_surface_(new TextSurface(title_property_)),
      title_label_(new LabelComponent(title_surface_)),
      escape_property_(common_->font, OptionMenu_escape,
                       NormalSize, Fore, Back, true),
      escape_surface_(new TextSurface(escape_property_)),
      escape_label_(new LabelComponent(escape_surface_)),
      typing_property_(common_->font, OptionMenu_typing,
                       NormalSize, Fore, Back, true),
      typing_surface_(new TextSurface(typing_property_)),
      typing_label_(new LabelComponent(typing_surface_)),
      sound_property_(common_->font, OptionMenu_sound,
                      NormalSize, Fore, Back, true),
      sound_surface_(new TextSurface(sound_property_)),
      sound_label_(new LabelComponent(sound_surface_)),
      system_property_(common_->font, OptionMenu_system,
                      NormalSize, Fore, Back, true),
      system_surface_(new TextSurface(system_property_)),
      system_label_(new LabelComponent(system_surface_)),
      practice_num_selector_(new SelectComponent(base_property_, White)),
      practice_input_selector_(new SelectComponent(base_property_, White)),
      practice_eachtime_cbox_(new CheckBoxComponent),
      sound_music_vslider_(new VolumeSliderComponent(VLength, OptionSize)),
      sound_effect_vslider_(new VolumeSliderComponent(VLength, OptionSize)),
      sound_voice_combox_(new ComboBoxComponent),
      system_full_cbox_(new CheckBoxComponent),
      system_send_cbox_(new CheckBoxComponent) {

    SDL_Rect position;

    // uIvVv
    set_SdlRect(&position, centerPosition(title_label_, 640/2), TextOffset);
    title_label_->setPosition(&position);

    // ^CsOݒ
    set_SdlRect(&position, TitleX, position.y);
    position.y += MenuSize + TextOffset;
    typing_label_->setPosition(&position);

    // - K
    TextProperty practice_num(common_->font, OptionMenu_typing_num,
                              OptionSize, Fore, Back, true);
    practice_num_selector_->addItem("5");
    practice_num_selector_->addItem("10");
    practice_num_selector_->addItem("50");
    practice_num_selector_->addItem("100");
    practice_num_selector_->setItemsOffset(ItemsOffset);
    practice_num_selector_->setSelected(0);    // !!! ύX邱
    option_->addItem(practice_num, practice_num_selector_, PlaceOffset, Middle);

    // - ̓[h
    TextProperty practice_input(common_->font, OptionMenu_input,
                                OptionSize, Fore, Back, true);
    practice_input_selector_->addItem(OptionMenu_Roman);
    practice_input_selector_->addItem(OptionMenu_Kana);
    practice_input_selector_->setItemsOffset(ItemsOffset);
    practice_input_selector_->setSelected(0);    // !!! ύX邱
    option_->addItem(practice_input,
                     practice_input_selector_, PlaceOffset, Middle);

    // - 񓯂o肷
    TextProperty practice_mode(common_->font, OptionMenu_eachtime_title,
                               OptionSize, Fore, Back, true);
    TextProperty practice_eachtime(common_->font, OptionMenu_eachtime,
                                   OptionSize, Fore, Back, true);
    Surface practice_eachtime_surface(new TextSurface(practice_eachtime));
    practice_eachtime_cbox_->setSurface(practice_eachtime_surface, 24, 0);
    practice_eachtime_cbox_->setCheck(true);
    option_->addItem(practice_mode,
                     practice_eachtime_cbox_, PlaceOffset, Middle);

    // yAʉArݏグ
    position.y += (OptionSize + TextOffset) * 4 + TextOffset;
    sound_label_->setPosition(&position);

    option_->addItemOffset(0, OptionSize + TextOffset + TextOffset);

    // - wi
    TextProperty sound_music(common_->font, OptionMenu_music,
                             OptionSize, Fore, Back, true);
    option_->addItem(sound_music, sound_music_vslider_, PlaceOffset, Middle);

    // - ʉ
    TextProperty sound_effect(common_->font, OptionMenu_effect,
                             OptionSize, Fore, Back, true);
    option_->addItem(sound_effect, sound_effect_vslider_, PlaceOffset, Middle);
    // !!! Đ{^

    // - rݏグ
    TextProperty sound_voice(common_->font, OptionMenu_voice,
                             OptionSize, Fore, Back, true);
    TextProperty normal_property(common_->font, OptionMenu_cdrom,
                                 OptionSize - 4, Fore, Back, true);
    TextProperty selected_property(common_->font, OptionMenu_cdrom,
                                   OptionSize - 4, Selected, Back, true);
    boost::shared_ptr<ButtonComponent> cdrom_button(new ButtonComponent);
    ButtonComponent::createButton(cdrom_button, normal_property,
                                  selected_property, selected_property);
    // !!! f[^\[X̍ڂǉ
    sound_voice_combox_->setRightOffset(TextOffset);
    sound_voice_combox_->addItem(cdrom_button);
    option_->addItem(sound_voice, sound_voice_combox_, PlaceOffset, Middle);

    // VXe
    position.y += (OptionSize + TextOffset) * 4 + TextOffset;
    system_label_->setPosition(&position);

    option_->addItemOffset(0, OptionSize + TextOffset + TextOffset);

    // - ʃ[h
    TextProperty system_full_title(common_->font, OptionMenu_full_title,
                               OptionSize, Fore, Back, true);
    TextProperty system_full(common_->font, OptionMenu_full,
                                     OptionSize, Fore, Back, true);
    Surface system_full_surface(new TextSurface(system_full));
    system_full_cbox_->setSurface(system_full_surface, 24, 0);
    system_full_cbox_->setCheck(false);
    option_->addItem(system_full_title, system_full_cbox_, PlaceOffset, Middle);

    // - ^CsOf[^T[oɑM
    TextProperty system_send_title(common_->font, OptionMenu_send_title,
                               OptionSize, Fore, Back, true);
    TextProperty system_send(common_->font, OptionMenu_send,
                                     OptionSize, Fore, Back, true);
    Surface system_send_surface(new TextSurface(system_send));
    system_send_cbox_->setSurface(system_send_surface, 24, 0);
    system_send_cbox_->setCheck(true);
    option_->addItem(system_send_title, system_send_cbox_, PlaceOffset, Middle);

    // IvV̔zu
    option_->setItemsOffset(0, OptionSize + TextOffset);
    set_SdlRect(&position, centerPosition(option_, 640/2),
                (MenuSize * 2) + (TextOffset * 2));
    option_->setPosition(&position);

    // uESC Ŗ߂܂v
    set_SdlRect(&position, rightPosition(escape_label_, 640) - TextOffset,
                bottomPosition(escape_label_, 480) - TextOffset);
    escape_label_->setPosition(&position);
  }

  void placeComponents(void) {
    common_->front_layer->push_front(title_label_);
    common_->front_layer->push_front(sound_label_);
    common_->front_layer->push_front(system_label_);
    common_->front_layer->push_front(escape_label_);
    common_->front_layer->push_front(typing_label_);
    common_->front_layer->push_front(option_);
  }

  void removeComponents(void) {
    common_->front_layer->remove(title_label_);
    common_->front_layer->remove(sound_label_);
    common_->front_layer->remove(system_label_);
    common_->front_layer->remove(escape_label_);
    common_->front_layer->remove(typing_label_);
    common_->front_layer->remove(option_);
  }

  // ύX̔f
  void updateInput(void) {

    // !!!
  }
};


OptionMenu::OptionMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


OptionMenu::~OptionMenu(void) {
  pimpl->removeComponents();
}


void OptionMenu::run(void) {

  GuiManager* gui = pimpl->common_->gui;
  InputHandler& input = *pimpl->common_->input;
  bool quit = false;
  while (quit == false) {

    // ύX̊ĎAf
    pimpl->updateInput();

    input.update_all();
    gui->update();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }
}
