/*!
  \file
  \brief Ot̕`

  \author Satofumi KAMIMURA

  $Id$

  \todo Pڂ̃f[^͂AOt(_)\悤ɂ
  \todo [̓_A͂ݏoĂ̂Ƃ
*/

#include "GraphDrawer.h"
#include "GraphDrawer_uni.h"
#include "CommonResources.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "AccessSettings.h"
#include "AccessRecordPC.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputReceiveComponent.h"
#include "InputEvent.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "GraphComponent.h"
#include "SdlUtils.h"

using namespace beego;


struct GraphDrawer::pImpl {
  TypingMode typing_mode;
  CommonResources* common;
  bool is_decided;
  InputEvent input_event;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<GraphComponent> graph_;

  pImpl(TypingMode mode)
    : typing_mode(mode), common(CommonResources::getObject()),
      is_decided(false),
      title_property(common->font, GraphDrawer_title,
                     MenuSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)),
      graph_(new GraphComponent) {

    // R|[lg̐
    // !!!
    graph_->setBackgroundColor(White);

    // R|[lg̈ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2), TextOffset);
    title_label->setPosition(&position);
  }

  void placeComponents(void) {

    // Otp̃R|[lgzu
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(graph_);

    is_decided = false;
    common->input_receiver->clear();
    common->front_layer->push_front(common->user_label);
  }

  void removeComponents(void) {

    // OtpR|[lg̍폜
    common->front_layer->remove(title_label);
    common->front_layer->remove(graph_);

    common->input_receiver->clear();
    common->front_layer->remove(common->user_label);
  }
};


GraphDrawer::GraphDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


GraphDrawer::~GraphDrawer(void) {
}


bool GraphDrawer::drawGraph(void) {

  // L^̓ǂݏo
  AccessRecordPC pc_record(pimpl->typing_mode);
  time_t now = time(NULL);
  std::vector<TypingRecorder::GameSettings> data;
  bool ret = pc_record.load(data, pimpl->common->getUserName(),
                            0, now, GraphHistoryMax);
  if (ret == false) {
    return false;
  }

  enum {
    DelayLine = 0,
    MissLine,
    ElapsedLine,
  };
  int index = 0;
  std::vector<Grid<double> > draw_lines[3];
  for (std::vector<TypingRecorder::GameSettings>::iterator it = data.begin();
       it != data.end(); ++it, ++index) {
    Grid<double> point(index, it->score.miss_types);
    draw_lines[MissLine].push_back(point);

    point.y = it->score.delay_msec / 1000.0;
    draw_lines[DelayLine].push_back(point);

    point.y = it->score.elapse_msec / 1000.0;
    draw_lines[ElapsedLine].push_back(point);
  }

  pimpl->graph_->registerLine(draw_lines[MissLine], Red);
  pimpl->graph_->registerLine(draw_lines[DelayLine], Green);
  if (pimpl->typing_mode == ShimonokuTyping) {
    pimpl->graph_->registerLine(draw_lines[ElapsedLine], Blue);
  }

  pimpl->graph_->create(GraphWidth, GraphHeight, pimpl->common->font);

  SDL_Rect position;
  set_SdlRect(&position, centerPosition(pimpl->graph_, 640/2),
              middlePosition(pimpl->graph_, (MenuSize + 480) / 2));
  pimpl->graph_->setPosition(&position);

  return true;
}


void GraphDrawer::placeComponents(void) {
  pimpl->placeComponents();
}


void GraphDrawer::removeComponents(void) {
  pimpl->removeComponents();
}


bool GraphDrawer::keyPressed(void) {

  pimpl->common->input_receiver->updateInputEvent(pimpl->input_event);
  pimpl->is_decided |= InputEvent::isReleased(pimpl->input_event, SDLK_RETURN);

  return pimpl->is_decided;
}
