/*!
  \file
  \brief Ot`

  \author Satofumi KAMIMURA

  $Id$

  \todo ^Cg\ł悤ɂ
  \todo [̃C悤ɂB(́A`悳ĂȂ)
*/

#include "GraphComponent.h"
#include "Component.h"
#include "GuiColors.h"
#include "ColorSurface.h"
#include "DrawPanelSurface.h"
#include "SdlUtils.h"

using namespace beego;


struct GraphComponent::pImpl {

  typedef struct {
    std::vector<Grid<double> > points; //!< 
    Uint32 color;                      //!< F
  } line_t;

  size_t width_;
  size_t height_;
  SDL_Rect position_;
  bool position_changed_;

  DrawSurface draw_surfaces_;
  boost::shared_ptr<DrawPanelSurface> graph_surface_;
  bool have_background_;
  Uint32 background_color_;
  bool created_;

  std::vector<line_t*> draw_lines_;
  double x_min_;
  double x_max_;
  double y_min_;
  double y_max_;

  pImpl(void)
    : width_(0), height_(0), position_changed_(false),
      have_background_(false), background_color_(Black),
      created_(false),
      x_min_(0.0), x_max_(0.0), y_min_(0.0), y_max_(0.0) {

    set_SdlRect(&position_, 0, 0, width_, height_);
  }

  void addSurfaceList(SurfaceList& surfaces,
                      const SDL_Rect* area, size_t ticks) {
    if (created_) {
      // Ot
      SDL_Rect draw_area;
      set_SdlRect(&draw_area, position_.x, position_.y,
                  width_, height_);
      updateDrawSurface(draw_surfaces_,
                        graph_surface_, area, ticks,
                        draw_area, position_changed_);
      surfaces.push_back(&draw_surfaces_);
    }
  }

  void create(size_t width, size_t height, TtfResource* font) {

    Grid<int> graph_size(width, height);
    width_ = width;
    height_ = height;

    if (font) {
      // o^ꂽƂ̂݁A̐lƎ̖O𐶐

      // ̐lAю̖Ǒ̕vZ
      // !!!
      // !!! graph_size 𒲐
    }

    // Ot̍쐬
    boost::shared_ptr<DrawPanelSurface>
      new_graph_surface(new DrawPanelSurface(graph_size.x, graph_size.y));
    new_graph_surface->setFontResource(font);

    // Otwi̓hԂ
    if (have_background_) {
      new_graph_surface->setBackgroundColor(background_color_);
    }

    double x_magnify = graph_size.x / ((x_max_ - x_min_) * 1.05);
    double y_magnify = graph_size.y / ((y_max_ - y_min_) * 1.05);

    // Ot̕`
    for (std::vector<pImpl::line_t*>::iterator it = draw_lines_.begin();
         it != draw_lines_.end(); ++it) {
      Uint32 color = (*it)->color;

      std::vector<Grid<int> > points;
      for (std::vector<Grid<double> >::iterator pit = (*it)->points.begin();
           pit != (*it)->points.end(); ++pit) {

        // !!!
        int x = static_cast<int>(pit->x * x_magnify);
        int y = graph_size.y - static_cast<int>(pit->y * y_magnify) -1;
        Grid<int> point(x, y);
        points.push_back(point);
        //new_graph_surface->drawPoint(point, color);
      }
      new_graph_surface->drawLines(points, color);
    }

    if (font) {
      // ̐l̐
      // !!!

      // ̐̐
      // !!!
      // !!! ̐FŐ`
      // !!! ɑ΂ăxt
      // !!! L܂ޔwiT[tFX쐬
      // !!! MultiSurface `ׂH
    }
    std::swap(graph_surface_, new_graph_surface);
    created_ = true;
  }

  void registerLine(std::vector<Grid<double> >& points, Uint32 color) {

    // `͈͂̊g
    // !!! ʓrw肪ꍇ́AD悷
    // !!! lȂ΁AŃOt`悷ׂ
    for (std::vector<Grid<double> >::iterator it = points.begin();
         it != points.end(); ++it) {
      double x = it->x;
      double y = it->y;

      if (x < x_min_) {
        x_min_ = x;
      }
      if (x > x_max_) {
        x_max_ = x;
      }
      if (y < y_min_) {
        y_min_ = y;
      }
      if (y > y_max_) {
        y_max_ = y;
      }
    }
    line_t* line = new line_t;
    line->points = points;
    line->color = color;
    draw_lines_.push_back(line);
    //fprintf(stderr, "%f, %f, %f, %f\n", x_min_, x_max_, y_min_, y_max_);
  }
};


GraphComponent::GraphComponent(void) : pimpl(new pImpl) {
}


GraphComponent::~GraphComponent(void) {
}


void GraphComponent::addSurfaceList(SurfaceList& surfaces,
                                    const SDL_Rect* area, size_t ticks) {
  pimpl->addSurfaceList(surfaces, area, ticks);
}


void GraphComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position_, position->x, position->y,
              pimpl->position_.w, pimpl->position_.h);
  pimpl->position_changed_ = true;
}


void GraphComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position_;
}


size_t GraphComponent::getWidth(void) {
  return pimpl->width_;
}


size_t GraphComponent::getHeight(void) {
  return pimpl->height_;
}


void GraphComponent::applyInput(const InputEvent& event,
                                std::vector<SDL_Rect>& applied_rects) {

  // !!! ̐Ã`FbN{bNX̑ƂH
}


void GraphComponent::registerLayer(Layer* layer) {
  // !!!
}


void GraphComponent::setBackgroundColor(Uint32 color) {

  pimpl->have_background_ = true;
  pimpl->background_color_ = color;
}


void GraphComponent::registerLine(std::vector<Grid<double> >& points,
                                  Uint32 color) {
  pimpl->registerLine(points, color);
}


void GraphComponent::create(size_t width, size_t height, TtfResource* font) {
  pimpl->create(width, height, font);
}


void GraphComponent::clear(void) {

  for (std::vector<pImpl::line_t*>::iterator it = pimpl->draw_lines_.begin();
       it != pimpl->draw_lines_.end(); ++it) {
    delete *it;
  }
  pimpl->draw_lines_.clear();
}
