/*!
  \file
  \brief [U쐬

  \author Satofumi KAMIMURA

  $Id$

  \todo PC ̃[UƏdȂAʂ
*/

#include "CreateUser.h"
#include "CreateUser_uni.h"
#include "CommonResources.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "ResourceDefinition.h"
#include "AccessSettings.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputEvent.h"
#include "InputHandler.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "ImageSurface.h"
#include "LabelComponent.h"
#include "TextInputComponent.h"
#include "InputReceiveComponent.h"
#include "SelectComponent.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "GetAccountName.h"
#include "RemoveFile.h"
#include "ThreadCreator.h"
#include "SdlUtils.h"
#include "Delay.h"
#include "GetTicks.h"
#include "UtfString.h"
#include "HttpAccess.h"
#include <fstream>

using namespace beego;


struct CreateUser::pImpl {
  enum {
    MessageY = 480 - (NormalSize * 4) - (TextOffset * 2),
    WarnY = MessageY - NormalSize * 4,

    HttpX = 20,
    HttpY = 100,
    HttpWidth = 510,

    NameWidth = 160,
    NameX = 20,
    NameY = 150,

    PasswordWidth = 100,
    PasswordX = 20,
    PasswordY = 200,

    GetAntiSpamImage,
    CommitPassword,
    None,

    AddressError = -1,
    UserExist = -2,
    PasswordMismatch = -3,
    UnknownError = -4,
  };

  class ThreadArgs {
    ThreadArgs(void);

  public:
    int type_;
    SDL_sem* result_;

    ThreadArgs(int type) : type_(type), result_(SDL_CreateSemaphore(0)) {
    }

    ~ThreadArgs(void) {
      SDL_DestroySemaphore(result_);
    }
  };

  class ProgressChanger {
    CommonResources* common;
    TextProperty message_property;
    Surface message_surface;
    Component message_label;
    boost::shared_ptr<SelectComponent> selector;
    size_t now_progress;
    Surface server_surface;
    Component server_label;
    Surface name_surface;
    Component name_label;

    ProgressChanger(CommonResources* common_)
      : common(common_),
        message_property(common->font, "Step:",
                         NormalSize, Fore, Back, true),
        message_surface(new TextSurface(message_property)),
        message_label(new LabelComponent(message_surface)),
        selector(new SelectComponent(message_property, White)),
        now_progress(0) {

      // ZN^[̏
      selector->addItem("1");
      selector->addItem("2");
      selector->addItem("3");
      selector->addItem("4");
      selector->setItemsOffset(NormalSize/2);
      selector->disableInput();

      SDL_Rect position;
      set_SdlRect(&position, TextOffset,
                  bottomPosition(selector, MessageY) - TextOffset);
      message_label->setPosition(&position);

      set_SdlRect(&position, position.x +
                  static_cast<int>(message_label->getWidth()) + TextOffset,
                  bottomPosition(selector, MessageY) - TextOffset);
      selector->setPosition(&position);
    }

    void updateSurfaces(void) {

      removeComponents();

      // ZN^ʒu̒
      selector->setSelected(static_cast<int>(now_progress));

      SDL_Rect position;
      if (now_progress > 0) {
        // T[oAhX̐
        std::string http_text = "http://" +
          std::string(HttpInputState::getObject(common)->getServerAddress());
        message_property.text = http_text.c_str();
        Surface new_server_surface(new TextSurface(message_property));
        std::swap(server_surface, new_server_surface);

        Component new_server_label(new LabelComponent(server_surface));
        std::swap(server_label, new_server_label);

        set_SdlRect(&position, HttpX, HttpY);
        server_label->setPosition(&position);
      }
      if (now_progress > 1) {
        // OC̐
        std::string name_text = "name: "
          + std::string(NameInputState::getObject(common)->getLoginName());
        message_property.text = name_text.c_str();
        Surface new_name_surface(new TextSurface(message_property));
        std::swap(name_surface, new_name_surface);

        Component new_name_label(new LabelComponent(name_surface));
        std::swap(name_label, new_name_label);

        set_SdlRect(&position, NameX, NameY);
        name_label->setPosition(&position);
      }

      placeComponents();
    }

  public:
    static ProgressChanger* getObject(CommonResources* common) {
      static ProgressChanger obj(common);
      return &obj;
    }

    void changeProgress(int progress) {
      now_progress = progress;
      updateSurfaces();
    }

    void placeComponents(void) {
      common->front_layer->push_front(message_label);
      common->front_layer->push_front(selector);

      if (now_progress > 0) {
        common->front_layer->push_front(server_label);
      }
      if (now_progress > 1) {
        common->front_layer->push_front(name_label);
      }
    }

    void removeComponents(void) {
      common->front_layer->remove(message_label);
      common->front_layer->remove(selector);

      if (now_progress > 0) {
        common->front_layer->remove(server_label);
      }
      if (now_progress > 1) {
        common->front_layer->remove(name_label);
      }
    }
  };

  class Schedule : public BaseEntity {
    StateMachine<Schedule>* state_machine;
    bool is_terminated;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  // ŏ̏
  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      type->changeState(HttpInputState::getObject(common));
    }

    void exit(Schedule* type) {
    }
  };

  // T[õAhX
  class HttpInputState : public State<Schedule> {
    CommonResources* common;
    TextProperty text_property;
    Surface http_surface;
    Component http_label;
    TextProperty message_property;
    Surface http_message_surface;
    Component http_message_label;
    TextProperty input_property;
    boost::shared_ptr<TextInputComponent> text_input;
    std::vector<Uint16> default_address;

    HttpInputState(CommonResources* common_obj)
      : common(common_obj),
        text_property(common->font, "http://", NormalSize, Fore, Back, true),
        http_surface(new TextSurface(text_property)),
        http_label(new LabelComponent(http_surface)),
        message_property(common->font, CreateUser_http_message,
                         NormalSize, Fore, Back, true),
        http_message_surface(new TextSurface(message_property)),
        http_message_label(new LabelComponent(http_message_surface)),
        input_property(common->font, "", NormalSize-3, White, Black, false),
        text_input(new TextInputComponent(HttpWidth, NormalSize + TextOffset/4,
                                          input_property, TextOffset/2)) {

      // R|[lg̈ʒuݒ
      SDL_Rect position;
      set_SdlRect(&position, HttpX, HttpY);
      http_label->setPosition(&position);

      set_SdlRect(&position,
                  static_cast<int>(HttpX + http_label->getWidth()), HttpY);
      text_input->setPosition(&position);

      set_SdlRect(&position,
                  centerPosition(http_message_label, 640/2), MessageY);
      http_message_label->setPosition(&position);

      // !!! ܁AƂ肠ftHg͌ŒɂĂ܂
      // !!! ]͂΁A[UŌɓ͂LȃAhXێAƂ
      // !!! Õ[ÛƓɂƂ
      for (int i = 0; DefaultServerAddress[i] != 0x0; ++i) {
        default_address.push_back(DefaultServerAddress[i]);
      }
    }

  public:
    static HttpInputState* getObject(CommonResources* common) {
      static HttpInputState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // R|[lg̏
      text_input->releaseDecided();
      text_input->setBuffer(default_address);

      ProgressChanger::getObject(common)->changeProgress(0);

      placeComponents();
    }

    void execute(Schedule* type) {

      if (text_input->isDecided()) {

        // ̓AhXLmFALłȂ΃bZ[W\
        // !!! mF@Al

        // [U̓͂֕
        type->changeState(NameInputState::getObject(common));
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {

      common->front_layer->push_front(http_label);
      common->front_layer->push_front(text_input);
      common->front_layer->push_front(http_message_label);
    }

    void removeComponents(void) {
      common->front_layer->remove(http_label);
      common->front_layer->remove(text_input);
      common->front_layer->remove(http_message_label);
    }

    const char* getServerAddress(void) {

      static std::string address_str;
      std::vector<Uint16> input_buffer;

      // pĂȂ͂Ȃ̂ŁALock Ȃ
      text_input->getBuffer(input_buffer);

      std::vector<Uint16> address;
      ustrcat(address, &input_buffer[0]);
      address.pop_back();

      address_str.clear();
      for (std::vector<Uint16>::iterator it = address.begin();
           it != address.end(); ++it) {
        char ch = *it & 0xff;
        if (isprint(ch)) {
          address_str.push_back(ch);
        }
      }
      return address_str.c_str();
    }
  };

  // [U
  class NameInputState : public State<Schedule> {
    CommonResources* common;
    ThreadArgs thread_args;
    ThreadCreator thread;

    TextProperty text_property;
    Surface login_surface;
    Component login_label;
    TextProperty message_property;
    Surface message_surface;
    Component message_label;
    TextProperty input_property;
    boost::shared_ptr<TextInputComponent> text_input;
    InputEvent input_event;
    bool web_accessed;
    bool aborted;
    bool is_pressed_;
    size_t first_ticks;

    TextProperty now_request_property;
    Surface now_request_surface;
    Component now_request_label;
    TextProperty no_reply_property;
    Surface no_reply_surface;
    Component no_reply_label;
    TextProperty user_exist_property;
    Surface user_exist_surface;
    Component user_exist_label;
    TextProperty address_error_property;
    Surface address_error_surface;
    Component address_error_label;

    NameInputState(CommonResources* common_)
      : common(common_),
        thread_args(GetAntiSpamImage),
        thread(webAccess_thread, &thread_args),
        text_property(common->font, "name:", NormalSize, Fore, Back, true),
        login_surface(new TextSurface(text_property)),
        login_label(new LabelComponent(login_surface)),
        message_property(common->font, CreateUser_name_message,
                         NormalSize, Fore, Back, true),
        message_surface(new TextSurface(message_property)),
        message_label(new LabelComponent(message_surface)),
        input_property(common->font, "", NormalSize, White, Black, false),
        text_input(new TextInputComponent(NameWidth, NormalSize + TextOffset/4,
                                          input_property, TextOffset/2)),
        web_accessed(false), aborted(false), is_pressed_(false),
        now_request_property(common->font, CreateUser_now_request,
                             NormalSize, Fore, Back, true),
        now_request_surface(new TextSurface(now_request_property)),
        now_request_label(new LabelComponent(now_request_surface)),
        no_reply_property(common->font, CreateUser_no_reply,
                          NormalSize, Fore, Back, true),
        no_reply_surface(new TextSurface(no_reply_property)),
        no_reply_label(new LabelComponent(no_reply_surface)),
        user_exist_property(common->font, CreateUser_user_exist,
                            NormalSize, Fore, Back, true),
        user_exist_surface(new TextSurface(user_exist_property)),
        user_exist_label(new LabelComponent(user_exist_surface)),
        address_error_property(common->font, CreateUser_address_error,
                               NormalSize, Fore, Back, true),
        address_error_surface(new TextSurface(address_error_property)),
        address_error_label(new LabelComponent(address_error_surface)) {

      // R|[lg̈ʒuݒ
      SDL_Rect position;
      set_SdlRect(&position, NameX, NameY);
      login_label->setPosition(&position);

      set_SdlRect(&position, NameX + static_cast<int>(login_label->getWidth())
                  + TextOffset, NameY);
      text_input->setPosition(&position);

      set_SdlRect(&position,
                  centerPosition(message_label, 640/2), MessageY);
      message_label->setPosition(&position);

      // fbZ[Ẅʒuݒ
      set_SdlRect(&position, centerPosition(now_request_label, 640/2), WarnY);
      now_request_label->setPosition(&position);

      set_SdlRect(&position, centerPosition(no_reply_label, 640/2), WarnY);
      no_reply_label->setPosition(&position);

      set_SdlRect(&position, centerPosition(user_exist_label, 640/2), WarnY);
      user_exist_label->setPosition(&position);

      set_SdlRect(&position, centerPosition(address_error_label, 640/2), WarnY);
      address_error_label->setPosition(&position);
    }

  public:
    static NameInputState* getObject(CommonResources* common) {
      static NameInputState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      text_input->releaseDecided();

      // ftHgi[Ă܂
      // !!! Windows ȂǂŁA}`oCg̏ꍇ́As
      // !!! AL̏ꍇ GetUserName() ԂAs
      std::vector<Uint16> default_name;
      ustrcat(default_name, GetAccountName().c_str());

      // GetUserName t閖 '\0' 菜
      default_name.pop_back();
      text_input->setBuffer(default_name);

      ProgressChanger::getObject(common)->changeProgress(1);

      placeComponents();

      // Web ANZXԂ̏
      web_accessed = false;
      aborted = false;
      SDL_DestroySemaphore(thread_args.result_);
      thread_args.result_ = SDL_CreateSemaphore(0);
      is_pressed_ = false;
    }

    void execute(Schedule* type) {

      if (text_input->isDecided()) {
        if (aborted) {
          // G[̂ߏ𒆎~BsAESC Ŕ̂҂
          common->input_receiver->updateInputEvent(input_event);
          if (! is_pressed_) {
            if (InputEvent::isPressed(input_event, SDLK_RETURN)) {
              is_pressed_ = true;
            }
          } else {
            if (InputEvent::isReleased(input_event, SDLK_RETURN)) {
              type->changeState(FirstState::getObject(common));
            }
          }
          return;
        }

        // mF̃bZ[W\A[U쐬y[WփANZX
        if (! web_accessed) {
          web_accessed = true;
          thread.run(1);
          first_ticks = GetTicks();

          // uT[oɖ₢킹łvbZ[W̔zu
          common->front_layer->push_front(now_request_label);
        }

        if (! thread.isRunning()) {
          int ret = 0;
          thread.wait(&ret);
          if (SDL_SemValue(thread_args.result_) > 0) {
            // 摜擾łĂA[Uo^B̏
            type->changeState(PasswordInputState::getObject(common));

          } else {
            // 摜擾łȂAbZ[W\ďI
            // ݂̕\bZ[W̍폜
            // !!! removeComponents() ł悢
            common->front_layer->remove(now_request_label);
            if (ret == AddressError) {
              // uo^y[W̃AhXقȂ܂v
              common->front_layer->push_front(address_error_label);

            } else if (ret == UserExist) {
              // ũ[ÚAɎgĂ܂v
              common->front_layer->push_front(user_exist_label);
            }
            common->input_receiver->clear();
            aborted = true;
          }
        } else if ((GetTicks() - first_ticks) > WebAccessTimeout) {
          // ڑ^CAEgBbZ[W\ďI
          common->front_layer->remove(now_request_label);

          // uT[o܂łBI܂v
          common->front_layer->push_front(no_reply_label);
          common->input_receiver->clear();
          aborted = true;
        }
      }
    }

    void exit(Schedule* type) {
      thread.stop();
      removeComponents();
    }

    void placeComponents(void) {
      common->front_layer->push_front(login_label);
      common->front_layer->push_front(text_input);
      common->front_layer->push_front(message_label);
      common->front_layer->push_front(common->input_receiver);
    }

    void removeComponents(void) {
      common->front_layer->remove(login_label);
      common->front_layer->remove(text_input);
      common->front_layer->remove(message_label);
      common->front_layer->remove(common->input_receiver);
      common->front_layer->remove(now_request_label);
      common->front_layer->remove(no_reply_label);
      common->front_layer->remove(user_exist_label);
      common->front_layer->remove(address_error_label);

      thread.stop();
    }

    const char* getLoginName(void) {

      static std::vector<char> user_name;

      std::vector<Uint16> utext;
      user_name.clear();
      text_input->getBuffer(utext);
      uni2char(user_name, utext);

      return &user_name[0];
    }

    int saveAntispamImage(void) {

      // T[o̎擾
      std::string server_address =
        HttpInputState::getObject(common)->getServerAddress();

      // [U̎擾
      const char* user_name = getLoginName();

      // HTTP v̐
      size_t first_slash = server_address.find('/');
      std::string server;
      std::string address;
      if (first_slash != std::string::npos) {
        server = server_address.substr(0, first_slash);
        address = server_address.substr(first_slash, std::string::npos)
          + "registerUser.php?name=" + std::string(&user_name[0]);
      } else {
        server = server_address;
        // !!! dȂƂ
        address = "/registerUser.php?name=" + std::string(&user_name[0]);
      }

      // HTTP ANZXsAF؉摜擾
      HttpAccess http_access(server.c_str());
      std::vector<char> image_data;
      http_access.get(image_data, address.c_str());
      if (image_data.empty()) {
        // [Uɑ݂
        return UserExist;
      } else if (image_data[0] == '<') {
        // AhXԈႢ
        return AddressError;
      }
      std::string save_path = common->savedir_ + "antispam.jpg";
      std::ofstream image_file(save_path.c_str());
      image_file.write(&image_data[0], static_cast<int>(image_data.size()));

      return 0;
    }
  };

  // !!! ɁAdCĂB̃^C~OŊ֐
  // Fؗp̕
  class PasswordInputState : public State<Schedule> {
    CommonResources* common;

    class ThreadArgs {
      ThreadArgs(void);

    public:
      int type_;
      SDL_sem* result_;

      ThreadArgs(int type) : type_(type), result_(SDL_CreateSemaphore(0)) {
      }

      ~ThreadArgs(void) {
        SDL_DestroySemaphore(result_);
      }
    };
    ThreadArgs thread_args;
    ThreadCreator thread;
    InputEvent input_event;
    bool web_accessed;
    bool aborted;
    bool is_pressed_;
    size_t first_ticks;

    Surface image_surface;
    Component image_label;
    TextProperty message_property;
    Surface message_surface;
    Component message_label;
    TextProperty input_property;
    boost::shared_ptr<TextInputComponent> text_input;
    TextProperty invalid_password_property;
    Surface invalid_password_surface;
    Component invalid_password_label;
    // !!! ȉ́Apɂׂ
    TextProperty now_request_property;
    Surface now_request_surface;
    Component now_request_label;
    TextProperty no_reply_property;
    Surface no_reply_surface;
    Component no_reply_label;
    TextProperty address_error_property;
    Surface address_error_surface;
    Component address_error_label;

    PasswordInputState(CommonResources* common_)
      : common(common_),
        thread_args(CommitPassword),
        thread(webAccess_thread, &thread_args),
        web_accessed(false), aborted(false), is_pressed_(false),
        // !!! t@C ResourceDefinition ɓo^
        // !!! ܂Aۂɂ Web 擾󂾂...
        message_property(common->font, CreateUser_password_message,
                         NormalSize, Fore, Back, true),
        message_surface(new TextSurface(message_property)),
        message_label(new LabelComponent(message_surface)),
        input_property(common->font, "", NormalSize, White, Black, false),
        text_input(new TextInputComponent(PasswordWidth,
                                          NormalSize + TextOffset/4,
                                          input_property, TextOffset/2)),
        invalid_password_property(common->font, CreateUser_invalid_password,
                                  NormalSize, Fore, Back, true),
        invalid_password_surface(new TextSurface(invalid_password_property)),
        invalid_password_label(new LabelComponent(invalid_password_surface)),
        now_request_property(common->font, CreateUser_now_request,
                             NormalSize, Fore, Back, true),
        now_request_surface(new TextSurface(now_request_property)),
        now_request_label(new LabelComponent(now_request_surface)),
        no_reply_property(common->font, CreateUser_no_reply,
                          NormalSize, Fore, Back, true),
        no_reply_surface(new TextSurface(no_reply_property)),
        no_reply_label(new LabelComponent(no_reply_surface)),
        address_error_property(common->font, CreateUser_address_error,
                               NormalSize, Fore, Back, true),
        address_error_surface(new TextSurface(address_error_property)),
        address_error_label(new LabelComponent(address_error_surface)) {
    }

  public:
    static PasswordInputState* getObject(CommonResources* common) {
      static PasswordInputState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // 摜̍XV
      std::string save_path = common->savedir_ + "antispam.jpg";
      Surface new_image_surface(new ImageSurface(save_path.c_str()));
      std::swap(image_surface, new_image_surface);
      Component new_image_label(new LabelComponent(image_surface));
      std::swap(image_label, new_image_label);
      removeFile(save_path.c_str());

      SDL_Rect position;
      set_SdlRect(&position, PasswordX, PasswordY);
      image_label->setPosition(&position);

      // R|[lg̈ʒuݒ
      set_SdlRect(&position, PasswordX +
                  static_cast<int>(image_label->getWidth()) + TextOffset,
                  middlePosition(text_input, PasswordY +
                                 static_cast<int>(image_label->getHeight()/2)));
      text_input->setPosition(&position);

      set_SdlRect(&position,
                  centerPosition(message_label, 640/2), MessageY);
      message_label->setPosition(&position);

      // fbZ[Ẅʒuݒ
      set_SdlRect(&position, centerPosition(now_request_label, 640/2), WarnY);
      now_request_label->setPosition(&position);

      set_SdlRect(&position, centerPosition(no_reply_label, 640/2), WarnY);
      no_reply_label->setPosition(&position);

      set_SdlRect(&position,
                  centerPosition(invalid_password_label, 640/2), WarnY);
      invalid_password_label->setPosition(&position);

      set_SdlRect(&position, centerPosition(address_error_label, 640/2), WarnY);
      address_error_label->setPosition(&position);

      // R|[lg̔zu
      text_input->releaseDecided();
      std::vector<Uint16> null_string;
      text_input->setBuffer(null_string);

      ProgressChanger::getObject(common)->changeProgress(2);

      placeComponents();

      // Web ANZXԂ̏
      SDL_DestroySemaphore(thread_args.result_);
      thread_args.result_ = SDL_CreateSemaphore(0);
      web_accessed = false;
      aborted = false;
      is_pressed_ = false;
    }

    void execute(Schedule* type) {

      if (text_input->isDecided()) {
        if (aborted) {
          // G[̂ߏ𒆎~BsAESC Ŕ̂҂
          common->input_receiver->updateInputEvent(input_event);
          if (! is_pressed_) {
            if (InputEvent::isPressed(input_event, SDLK_RETURN)) {
              is_pressed_ = true;
            }
          } else {
            if (InputEvent::isReleased(input_event, SDLK_RETURN)) {
              type->changeState(FirstState::getObject(common));
            }
          }
          return;
        }

        // mF̃bZ[W\ApX[ho^y[WփANZX
        if (! web_accessed) {
          web_accessed = true;
          thread.run(1);
          first_ticks = GetTicks();

          // uT[oɖ₢킹łvbZ[W̔zu
          common->front_layer->push_front(now_request_label);
        }

        if (! thread.isRunning()) {
          int ret = 0;
          thread.wait(&ret);
          if (SDL_SemValue(thread_args.result_) > 0) {
            // 擾 "O.K." I

            // [U̒ǉ
            const char* user_name =
              NameInputState::getObject(common)->getLoginName();
            if (strlen(user_name) > 0) {
              const char* password = getPassword();
              common->addUser(user_name, password);
              common->settings->save();
            }
            type->changeState(CompleteState::getObject(common));

          } else {
            // ݂̓o^bZ[W폜
            common->front_layer->remove(now_request_label);
            if (ret == AddressError) {
              // uo^y[W̃AhXقȂ܂v
              common->front_layer->push_front(address_error_label);

            } else if (ret == PasswordMismatch) {
              // upX[hႢ܂v
              common->front_layer->push_front(invalid_password_label);
            }
            common->input_receiver->clear();
            aborted = true;
          }
        } else if ((GetTicks() - first_ticks) > WebAccessTimeout) {
          // ڑ^CAEgBbZ[W\ďI
          common->front_layer->remove(now_request_label);

          // uT[o܂łBI܂v
          common->front_layer->push_front(no_reply_label);
          common->input_receiver->clear();
          aborted = true;
        }
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {
      common->front_layer->push_front(text_input);
      common->front_layer->push_front(image_label);
      common->front_layer->push_front(message_label);
    }

    void removeComponents(void) {
      common->front_layer->remove(text_input);
      common->front_layer->remove(image_label);
      common->front_layer->remove(message_label);
      common->front_layer->remove(now_request_label);
      common->front_layer->remove(no_reply_label);
      common->front_layer->remove(invalid_password_label);
      common->front_layer->remove(address_error_label);
    }

    const char* getPassword(void) {
      static std::vector<char> password;

      std::vector<Uint16> utext;
      text_input->getBuffer(utext);
      password.clear();
      uni2char(password, utext);

      return &password[0];
    }

    int commitPassword(void) {

      // !!! AsaveAntispamImage() ƓB

      // T[o̎擾
      std::string server_address =
        HttpInputState::getObject(common)->getServerAddress();

      // [U̎擾
      const char* user_name =
        NameInputState::getObject(common)->getLoginName();

      // ͂ꂽpX[h̎擾
      const char* inputed_password = getPassword();

      // HTTP v̐
      size_t first_slash = server_address.find('/');
      std::string server;
      std::string address;
      if (first_slash != std::string::npos) {
        server = server_address.substr(0, first_slash);
        address = server_address.substr(first_slash, std::string::npos)
          + "commitPassword.php?name=" + std::string(&user_name[0])
          + "&password=" + std::string(inputed_password);
      } else {
        server = server_address;
        // !!! dȂƂ
        address = "/commitPassword.php?name=" + std::string(&user_name[0])
          + "&password=" + std::string(inputed_password);
      }

      // HTTP ANZXsAF؉摜擾
      HttpAccess http_access(server.c_str());
      std::vector<char> http_reply;
      http_access.get(http_reply, address.c_str());
      if (http_reply.empty()) {
        // Ƀ[U݂ (̓ꃆ[U̍쐬vŋN肤)
        return UserExist;

      } else if (http_reply[0] == '<') {
        // AhXԈႢ
        return AddressError;

      } else if ((http_reply.size() != 4) ||
                 (strncmp(&http_reply[0], "O.K.", 4))) {
        return PasswordMismatch;
      }

      // !!! PC ւ̃[U̓o^
      return 0;
    }
  };

  // IbZ[W̕\
  class CompleteState : public State<Schedule> {
    CommonResources* common;
    TextProperty message_property;
    Surface message_surface;
    Component message_label;
    InputEvent input_event;
    bool is_pressed;

    CompleteState(CommonResources* common_)
      : common(common_),
        message_property(common->font, CreateUser_complete_message,
                         NormalSize, Fore, Back, true),
        message_surface(new TextSurface(message_property)),
        message_label(new LabelComponent(message_surface)),
        is_pressed(false) {

      // R|[lg̈ʒuݒ
      SDL_Rect position;
      //set_SdlRect(&position, rightPosition(name_label, NameX), NameY);
      //name_label->setPosition(&position);

      set_SdlRect(&position,
                  centerPosition(message_label, 640/2), MessageY);
      message_label->setPosition(&position);
    }

  public:
    static CompleteState* getObject(CommonResources* common) {
      static CompleteState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      is_pressed = false;

      common->input_receiver->clear();
      ProgressChanger::getObject(common)->changeProgress(3);

      placeComponents();
    }

    void execute(Schedule* type) {

      // sꂽA
      // !!! ꂽAɂĂ݂
      common->input_receiver->updateInputEvent(input_event);
      if (! is_pressed) {
        if (InputEvent::isPressed(input_event, SDLK_RETURN)) {
          is_pressed = true;
        }
      } else {
        if (InputEvent::isReleased(input_event, SDLK_RETURN)) {
          type->changeState(FirstState::getObject(common));
        }
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {
      common->front_layer->push_front(common->input_receiver);
      common->front_layer->push_front(message_label);
    }

    void removeComponents(void) {
      common->front_layer->remove(common->input_receiver);
      common->front_layer->remove(message_label);
    }
  };

  CommonResources* common;
  Schedule scheduler;

  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  TextProperty back_property;
  Surface back_surface;
  Component back_label;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(0, common),
      title_property(common->font, CreateUser_title,
                     MenuSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)),
      back_property(common->font, CreateUser_back_message,
                    NormalSize, Fore, Back, true),
      back_surface(new TextSurface(back_property)),
      back_label(new LabelComponent(back_surface)) {

    // ^Cgʒu
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                topPosition(title_label, 0) + TextOffset * 3);
    title_label->setPosition(&position);

    // ߂邽߂̃bZ[Wʒu
    set_SdlRect(&position, rightPosition(back_label, 640) - TextOffset,
                bottomPosition(back_label, 480) - TextOffset);
    back_label->setPosition(&position);
  }

  void placeComponents(void) {

    // ŔzuR|[lg̍sĂ
    ProgressChanger::getObject(common)->changeProgress(0);

    common->front_layer->push_front(title_label);
    common->front_layer->push_front(back_label);
  }

  void removeComponents(void) {
    ProgressChanger::getObject(common)->removeComponents();
    HttpInputState::getObject(common)->removeComponents();
    NameInputState::getObject(common)->removeComponents();
    PasswordInputState::getObject(common)->removeComponents();
    CompleteState::getObject(common)->removeComponents();

    common->front_layer->remove(title_label);
    common->front_layer->remove(back_label);
  }

  static int webAccess_thread(void* args) {
    ThreadArgs* obj = static_cast<ThreadArgs*>(args);

    int ret = false;
    CommonResources* common = CommonResources::getObject();
    if (obj->type_ == GetAntiSpamImage) {
      // A`Xp摜̎擾
      ret = NameInputState::getObject(common)->saveAntispamImage();
      if (ret == 0) {
        SDL_SemPost(obj->result_);
      }
    } else if (obj->type_ == CommitPassword) {
      // pX[h̓o^
      ret = PasswordInputState::getObject(common)->commitPassword();
      if (ret == 0) {
        SDL_SemPost(obj->result_);
      }
    }
    return ret;
  }
};


CreateUser::CreateUser(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


CreateUser::~CreateUser(void) {
  pimpl->removeComponents();
}


void CreateUser::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  bool escape_pressed = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    quit |= pimpl->scheduler.isTerminated();
    input.update_all();
    gui->update();
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    escape_pressed |= input.isPressed(SDLK_ESCAPE);
    if (escape_pressed && input.isReleased(SDLK_ESCAPE)) {
      quit |= true;
    }
    delay(1);
  }
}
