/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo ĨXN[[hA[UɋL^ĊǗ
*/

#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "AccessSettings.h"
#include "TypingRecorder.h"
#include "VoicePlayer.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "NullSurface.h"
#include "TextSurface.h"
#include "FillSurface.h"
#include "SdlSurface.h"
#include "AnimationSurface.h"
#include "TtfResource.h"
#include "TextProperty.h"
#include "ConsolePanelComponent.h"
#include "InputReceiveComponent.h"
#include "LabelComponent.h"
#include "SearchFilePath.h"
#include "back_bmp.h"
#include "selector_00_bmp.h"
#include "selector_01_bmp.h"
#include "selector_02_bmp.h"
#include "selector_03_bmp.h"
#include "CreateSurfaceFromArray.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "ExistFile.h"
#include "SdlUtils.h"

using namespace beego;


struct CommonResources::pImpl {
  SDL_Surface* scr;
  Layer debug_layer;
  Surface back_bmp_surface;     // !!! ێKv񂾂H ̂̎
  Surface back_surface;
  boost::shared_ptr<AnimationSurface> icon_surface;
  bool music_initialized;

  pImpl(void) : scr(SDL_GetVideoSurface()), music_initialized(false) {
  }
};


CommonResources::CommonResources(const char* savedir)
  : pimpl(new pImpl),
    gui(new GuiManager), front_layer(new Layer), back_layer(new Layer),
    music(NULL), sound_effect(NULL), recorder(new TypingRecorder),
    practice_num(DefaultPracticeNum),
    //practice_num(1),
    voice_(new VoicePlayer(VoiceDir)),
    convert_type(TypingTextConverter::Roman), savedir_(savedir),
    settings(new AccessSettings(savedir)) {

  gui->push_back(back_layer);
  gui->push_front(front_layer);
  gui->push_front(&pimpl->debug_layer);
}


CommonResources::~CommonResources(void) {

  // !!! ܂AĂ΂邱Ƃ͑z肵ĂȂ񂾂...
  // !!! ̂AK؂ȃ\bhɈړ
  delete music;
  delete sound_effect;
  delete input;
  delete font;
  delete back_layer;
  delete front_layer;
  delete gui;
}


CommonResources* CommonResources::getObject(const char* savedir) {
  static CommonResources obj(savedir);
  return &obj;
}


void CommonResources::initializeGui(void) {

  if (! pimpl->scr) {
    pimpl->scr = SDL_GetVideoSurface();
  }

  // wi摜̏
  Surface new_back_bmp_surface(new SdlSurface(createSurface(back_bmp,
                                                            back_bmp_width,
                                                            back_bmp_height)));
  std::swap(pimpl->back_bmp_surface, new_back_bmp_surface);

  Surface new_back_surface(new FillSurface(pimpl->back_bmp_surface,
                                           pimpl->scr->w, pimpl->scr->h));
  std::swap(pimpl->back_surface, new_back_surface);

  Component new_back_label(new LabelComponent(pimpl->back_surface));
  std::swap(back_label, new_back_label);

  // j[ACȐ
  boost::shared_ptr<AnimationSurface> new_icon_surface(new AnimationSurface);
  Surface cell_00(new SdlSurface(createSurface(selector_00_bmp,
                                               selector_00_bmp_width,
                                               selector_00_bmp_height), true));
  Surface cell_01(new SdlSurface(createSurface(selector_01_bmp,
                                               selector_01_bmp_width,
                                               selector_01_bmp_height), true));
  Surface cell_02(new SdlSurface(createSurface(selector_02_bmp,
                                               selector_02_bmp_width,
                                               selector_02_bmp_height), true));
  Surface cell_03(new SdlSurface(createSurface(selector_03_bmp,
                                               selector_03_bmp_width,
                                               selector_03_bmp_height), true));
  new_icon_surface->registerSurface(cell_00, 230, 0, 0);
  new_icon_surface->registerSurface(cell_01, 200, 8, 0);
  new_icon_surface->registerSurface(cell_02, 200, 8, 0);
  new_icon_surface->registerSurface(cell_03, 230, 0, 0);
  new_icon_surface->registerSurface(cell_02, 200, 8, 0);
  new_icon_surface->registerSurface(cell_01, 200, 8, 0);
  new_icon_surface->play();
  std::swap(pimpl->icon_surface, new_icon_surface);

  Component new_menu_icon(new LabelComponent(pimpl->icon_surface));
  std::swap(menu_icon, new_menu_icon);

  // ͎̏
  font = new TtfResource(FontPath);
  input = new InputHandler;

  boost::shared_ptr<InputReceiveComponent>
    new_input_receiver(new InputReceiveComponent);
  std::swap(input_receiver, new_input_receiver);

  // fobOpl̏
  TextProperty text_property(font, "", SmallSize, Black, Gray4, true);
  boost::shared_ptr<ConsolePanelComponent>
    panel(new ConsolePanelComponent(640, 480, text_property,
                                    ConsolePanelComponent::FadeOut,
                                    ConsolePanelComponent::Up));
  std::swap(debug, panel);

  // R|[lg̔zu
  pimpl->debug_layer.push_front(debug);
  back_layer->push_back(input_receiver);
}


bool CommonResources::accessFontData(void) {

  //std::string font_path;
  //std::vector<std::string> dir_path;
  //if (! searchFilePath(font_path, FontPath, dir_path)) {
  if (! existFile(FontPath)) {
    printf("\"%s\" is not found.\n", FontPath);
    return false;
  }
  return true;
}


bool CommonResources::accessMusicData(void) {

  //if (existFile(Music1_FilePath) && existFile(Music2_FilePath)) {
  if (existFile(MusicDirectory)) {
    return true;
  } else {
    return false;
  }
}


void CommonResources::initializeMusic(void) {

  if (! pimpl->music_initialized) {

    // IuWFNg̐錾
    music = new MusicManager;
    if (! music->isInitialized()) {
      delete music;
      music = NULL;
      return;
    }
    sound_effect = new SoundEffectManager;

    // Đ
    music->setFadeInEffect(PlayFadeIn);

    // y̏
    music->registerMusic(BackMusic_1, Music1_FilePath);
    music->registerMusic(BackMusic_2, Music2_FilePath);

    sound_effect->registerEffect(SoundEffect_1, Effect1_FilePath);
    sound_effect->registerEffect(SoundEffect_2, Effect2_FilePath);

#if 0
    sound_effect->registerEffect(Decide, Decide_FilePath);
    sound_effect->registerEffect(Type, Type_FilePath);
    sound_effect->registerEffect(Miss, Miss_FilePath);
#else
    // y\[X hyakutypingrc.txt w\ɂ
    std::string dir_path = std::string(MusicDirectory);
    std::string decide_file = dir_path + settings->effect_decide_;
    std::string type_file = dir_path + settings->effect_type_;
    std::string miss_file = dir_path + settings->effect_miss_;

    sound_effect->registerEffect(Decide, decide_file.c_str());
    sound_effect->registerEffect(Type, type_file.c_str());
    sound_effect->registerEffect(Miss, miss_file.c_str());
#endif

    pimpl->music_initialized = true;
  }
}


const char* CommonResources::getUserName(void) const {

  size_t user_index = settings->user_index_;
  return settings->user_names_[user_index].c_str();
}


void CommonResources::addUser(const char* user_name, const char* password) {

  int index = 0;
  for (std::vector<std::string>::iterator it = settings->user_names_.begin();
       it != settings->user_names_.end(); ++it, ++index) {
    if (! it->compare("")) {
      *it = user_name;
      settings->user_password_[index] = password;
      settings->user_index_ = index;

      break;
    }
  }
}


void CommonResources::deleteUser(int user_index) {
  settings->deleteUser(user_index);
}


void CommonResources::updateUserLable(void) {
  int user_index = settings->user_index_;
  const char* user_name = settings->user_names_[user_index].c_str();

  if (strlen(user_name) <= 0) {
    Surface new_user_surface(new NullSurface);
    Component new_user_label(new LabelComponent(new_user_surface));
    std::swap(user_label, new_user_label);
  } else {
    TextProperty user_property(font, user_name,
                               NormalSize, Fore, Back, true);
    Surface new_user_surface(new TextSurface(user_property));
    Component new_user_label(new LabelComponent(new_user_surface));
    std::swap(user_label, new_user_label);
  }

  SDL_Rect position;
  set_SdlRect(&position,
              rightPosition(user_label, 640) - TextOffset,
              TextOffset);
  user_label->setPosition(&position);
}
