/*!
  \file
  \brief R{{bNXER|[lg

  \author Satofumi KAMIMURA

  $Id$

  \todo Op̉摜ւ悤ɂ
  \todo J[\j[ÔƂAIj[ڂIȂ悤ɂ
  \todo Ȃ񂩁AIڂ̓ւ`悪BmF邠肩
*/

#include "ComboBoxComponent.h"
#include "down_triangle.h"
#include "Layer.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "Component.h"
#include "InputEvent.h"
#include "TextProperty.h"
#include "SdlSurface.h"
#include "ColorSurface.h"
#include "CreateSurfaceFromArray.h"
#include "SwitchSurface.h"
#include "EvaluateArea.h"
#include "SdlUtils.h"

using namespace beego;


struct ComboBoxComponent::pImpl {

  enum {
    DrawDecidedBack = 0,        //!< Ŝ̘g
    DrawDecided,                //!< Iڂ̘g
    DrawDecidedItemBack,        //!< Iڂ̔wig
    DrawTriangle,               //!< Op
    DrawMenuBack,               //!< Ij[̔wi
    DrawMenu,                   //!< Ij[
    DrawIndexMax,               //!< Lvf̌

    DrawSelectMenuBack,         //!< Ij[̑Iڂ̔wi
  };

  enum {
    Normal = 0,
    Selected,
  };

  size_t max_width_;
  boost::shared_ptr<SwitchSurface> decided_surface_;
  boost::shared_ptr<MenuComponent> menu_;
  SDL_Rect position_;
  SDL_Rect menu_position_;
  bool position_changed_;
  bool show_;                 //!< Ij[JĂƂ true
  Uint32 frame_color_;
  Uint32 decided_back_color_;
  Uint32 selected_back_color_;
  Surface triangle_surface_;
  Surface decided_back_;
  Surface decided_item_back_;
  Surface menu_back_;
  typedef std::vector<boost::shared_ptr<SwitchSurface> > SwitchSurfaces;
  SwitchSurfaces selected_items_back_;
  DrawSurface draw_surfaces_[DrawIndexMax];
  std::vector<DrawSurface> draw_surfaces_items_back_;
  Layer* layer_;
  bool is_select_changed_;
  size_t min_width_;
  size_t right_offset_;

  pImpl(void)
    : max_width_(0),
      decided_surface_(new SwitchSurface), menu_(new MenuComponent),
      position_changed_(false), show_(false),
      frame_color_(Gray12), decided_back_color_(White),
      selected_back_color_(Blue),
      triangle_surface_(new SdlSurface(createSurface(down_triangle,
                                                     down_triangle_width,
                                                     down_triangle_height),
                                       true)),
      layer_(NULL), is_select_changed_(false),
      min_width_(0), right_offset_(0) {

    set_SdlRect(&position_, 0, 0, 0, 0);
    updateBackSurface();
  }

  void updateBackSurface(void) {

    // IT[tFXṕAŜ̔wi摜쐬
    size_t triangle_width = triangle_surface_->getWidth();
    size_t frame_width = max_width_ + right_offset_ + triangle_width;
    size_t decided_height = decided_surface_->getHeight();
    Surface new_decided_back(new ColorSurface(frame_width, decided_height,
                                              frame_color_));
    std::swap(decided_back_, new_decided_back);

    // IT[tFXṕAڂ̔wi摜쐬
    Surface new_item_back(new ColorSurface(max_width_, decided_height,
                                           decided_back_color_));
    std::swap(decided_item_back_, new_item_back);

    // Ij[́AI̔wiT[tFX̍쐬
    size_t index = 0;

    // !!! selected_items_back_ ̓v[ł鎑B蒼Ă悢
    selected_items_back_.clear();
    for (std::vector<DrawSurface>::iterator it =
           draw_surfaces_items_back_.begin();
         it != draw_surfaces_items_back_.end(); ++it, ++index) {

      boost::shared_ptr<SwitchSurface> items_back(new SwitchSurface());
      SDL_Rect item_offset;
      menu_->getItemPosition(&item_offset, index);
      size_t height = item_offset.h;
      Surface normal_back(new ColorSurface(frame_width, height,
                                           decided_back_color_));
      Surface selected_back(new ColorSurface(frame_width, height,
                                             selected_back_color_));
      items_back->registerSurface(normal_back, 0, 0, pImpl::Normal);
      items_back->registerSurface(selected_back, 0, 0, pImpl::Selected);
      selected_items_back_.push_back(items_back);
    }

    // j[p̔wi摜쐬
    Surface new_menu_back(new ColorSurface(frame_width, menu_->getHeight(),
                                           decided_back_color_));
    std::swap(menu_back_, new_menu_back);
  }

  size_t getWidth(void) {
    return max_width_ + right_offset_ + triangle_surface_->getWidth();
  }

  size_t getHeight(void) {

    // j[JĂ邩ۂō͕ς
    size_t height =
      decided_back_->getHeight() + ((show_) ? menu_->getHeight() : 0);

    return height;
  }

  void addSurfaceList(SurfaceList& surfaces,
                      const SDL_Rect* area, size_t ticks) {

    // !!! ̓o^́Afor ōs悤ɏC
    // !!! Aʒu̓o^Ń[v̂́Aʓ|

    SDL_Rect draw_area;

    // Iڂ̔wi
    size_t decided_item_back_width =
      decided_item_back_->getWidth() + right_offset_;
    size_t decided_item_back_height = decided_item_back_->getHeight();

    // Op
    size_t triangle_width = triangle_surface_->getWidth();
    size_t triangle_height = triangle_surface_->getHeight();
    size_t frame_width = decided_item_back_width + triangle_width;
    set_SdlRect(&draw_area,
                position_.x + frame_width - triangle_width,
                position_.y + (decided_item_back_height - triangle_height)/2,
                triangle_width, triangle_height);
    updateDrawSurface(draw_surfaces_[pImpl::DrawTriangle],
                      triangle_surface_, area, ticks,
                      draw_area, position_changed_);
    surfaces.push_back(&draw_surfaces_[pImpl::DrawTriangle]);

    // IT[tFX
    set_SdlRect(&draw_area, position_.x, position_.y,
                decided_surface_->getWidth(),
                decided_surface_->getHeight());
    updateDrawSurface(draw_surfaces_[pImpl::DrawDecided],
                      decided_surface_, area, ticks,
                      draw_area, position_changed_);
    surfaces.push_back(&draw_surfaces_[pImpl::DrawDecided]);
    //fprintf(stderr, "push %d, %d, %d, %d\n", draw_area.x, draw_area.y, draw_area.w, draw_area.h);
    //fprintf(stderr, "area: %d, %d, %d, %d\n", area->x, area->y, area->w, area->h);

    // Iڂ̔wi
    set_SdlRect(&draw_area, position_.x, position_.y,
                decided_item_back_width, decided_item_back_height);
    updateDrawSurface(draw_surfaces_[pImpl::DrawDecidedItemBack],
                      decided_item_back_, area, ticks,
                      draw_area, position_changed_);
    surfaces.push_back(&draw_surfaces_[pImpl::DrawDecidedItemBack]);

    // IT[tFXwi
    set_SdlRect(&draw_area, position_.x, position_.y,
                decided_back_->getWidth(),
                decided_back_->getHeight());
    updateDrawSurface(draw_surfaces_[pImpl::DrawDecidedBack],
                      decided_back_, area, ticks,
                      draw_area, position_changed_);
    surfaces.push_back(&draw_surfaces_[pImpl::DrawDecidedBack]);

    if (show_) {
      // Ij[ ̕`
      menu_->addSurfaceList(surfaces, area, ticks);

      // Ij[̑I
      size_t index = 0;
      SDL_Rect item_offset;
      size_t now_selected = menu_->getSelected();
      for (SwitchSurfaces::iterator it = selected_items_back_.begin();
           it != selected_items_back_.end(); ++it, ++index) {

        menu_->getItemPosition(&item_offset, index);
        if (index == now_selected) {
          // IT[tFX
          (*it)->switchSurface(Selected);

        } else {
          // ʏT[tFX
          (*it)->switchSurface(Normal);
        }
        set_SdlRect(&draw_area,
                    position_.x + item_offset.x,
                    position_.y + item_offset.y + decided_item_back_height,
                    decided_item_back_width + triangle_width,
                    item_offset.h);
        updateDrawSurface(draw_surfaces_items_back_[index],
                          *it, area, ticks,
                          draw_area, position_changed_);
        surfaces.push_back(&draw_surfaces_items_back_[index]);
      }

      // Ij[wi ̕`
      set_SdlRect(&draw_area, position_.x,
                  position_.y + decided_item_back_height,
                  menu_back_->getWidth(),
                  menu_back_->getHeight());
      updateDrawSurface(draw_surfaces_[pImpl::DrawMenuBack],
                        menu_back_, area, ticks,
                        draw_area, position_changed_);
      surfaces.push_back(&draw_surfaces_[pImpl::DrawMenuBack]);
    }
    position_changed_ = false;
  }
};


ComboBoxComponent::ComboBoxComponent(void) : pimpl(new pImpl) {
}


ComboBoxComponent::~ComboBoxComponent(void) {
}


void ComboBoxComponent::addSurfaceList(SurfaceList& surfaces,
                                       const SDL_Rect* area, size_t ticks) {

  pimpl->addSurfaceList(surfaces, area, ticks);
}


void ComboBoxComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position_, position->x, position->y,
              pimpl->position_.w, pimpl->position_.h);
  pimpl->position_changed_ = true;
}


void ComboBoxComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position_;
}


size_t ComboBoxComponent::getWidth(void) {
  return pimpl->getWidth();
}


size_t ComboBoxComponent::getHeight(void) {
  return pimpl->getHeight();
}


void ComboBoxComponent::applyInput(const InputEvent& event,
                                   std::vector<SDL_Rect>& applied_rects) {

  if (pimpl->show_) {
    // Ij[JĂƂ

    // I
    pimpl->menu_->applyInput(event, applied_rects);

    if (event.left_released) {
      // Ij[̍폜
      SurfaceList remove_surfaces;
      for (std::vector<DrawSurface>::iterator it =
             pimpl->draw_surfaces_items_back_.begin();
           it != pimpl->draw_surfaces_items_back_.end(); ++it) {
        remove_surfaces.push_back(&(*it));
      }

      pimpl->menu_->addSurfaceList(remove_surfaces, &pimpl->menu_position_, 0);
      remove_surfaces.push_back(&pimpl->draw_surfaces_[pImpl::DrawMenuBack]);
      pimpl->layer_->removeSurfaces(remove_surfaces);
      pimpl->show_ = false;

      // Iڂ̍Đݒ
      int decided_index = pimpl->menu_->getDecided();
      if (decided_index >= 0) {
        pimpl->is_select_changed_ = true;
        pimpl->menu_->releaseDecided();
        pimpl->menu_->setDecided(MenuComponent::NoSelect);
        pimpl->decided_surface_->switchSurface(decided_index);
        pimpl->updateBackSurface();
        pimpl->menu_back_->forceSetChanged();
      }
    }

  } else {
    // Ij[JĂȂƂ

    // gNbNꂽA̔
    SDL_Rect component_area;
    size_t decided_item_height = pimpl->decided_item_back_->getHeight();
    set_SdlRect(&component_area, pimpl->position_.x, pimpl->position_.y,
                pimpl->decided_back_->getWidth(),
                pimpl->decided_back_->getHeight());
    bool cursor_inside = isPointInside(event.mx, event.my, component_area);
    if (cursor_inside && event.left_released) {
      // Ij[J

      // zuʒu̍XVBʒuXV邱ƂŁA`悪ۏ؂
      set_SdlRect(&pimpl->menu_position_, pimpl->position_.x,
                  pimpl->position_.y + decided_item_height,
                  pimpl->menu_->getWidth(), pimpl->menu_->getHeight());
      pimpl->menu_->setPosition(&pimpl->menu_position_);
      pimpl->menu_back_->forceSetChanged();
      pimpl->show_ = true;
    }
  }
}


void ComboBoxComponent::registerLayer(Layer* layer) {
  pimpl->layer_ = layer;
}


void ComboBoxComponent::setRightOffset(size_t width) {
  pimpl->right_offset_ = width;
}


void ComboBoxComponent::setMinWidth(size_t width) {
  pimpl->min_width_ = width;
}


void ComboBoxComponent::clearItems(void) {

  // TCY̏
  pimpl->max_width_ = 0;

  // IT[tFX̃NA
  pimpl->decided_surface_->clear();
  pimpl->selected_items_back_.clear();
  pimpl->draw_surfaces_items_back_.clear();

  // j[̃NA
  pimpl->menu_->clearItems();
}


void ComboBoxComponent::addItem(boost::shared_ptr<ButtonComponent> item) {

  // ǂ̃^C~O setMinWidth() Ă΂邩킩Ȃ̂ŁAŏ
  if (pimpl->max_width_ < pimpl->min_width_) {
    pimpl->max_width_ = pimpl->min_width_;
  }

  // TCY̊g
  size_t item_width = item->getWidth();
  if (item_width > pimpl->max_width_) {
    pimpl->max_width_ = item_width;
  }
  pimpl->menu_->setItemSelectWidth(pimpl->max_width_ + pimpl->right_offset_
                                   + pimpl->triangle_surface_->getWidth());
  DrawSurface dummy;
  pimpl->draw_surfaces_items_back_.push_back(dummy);

  // j[ւ̓o^
  pimpl->menu_->addItem(item);
  pimpl->menu_->adjustItemsVerticalOffset();

  // IT[tFXւ̓o^BT[tFX ButtonComponent 甲o
  Surface normal_surface = item->getNormalSurface();

  // ݂̓o^T[tFX̎擾Ɗi[
  size_t decided_size = pimpl->decided_surface_->size();
  pimpl->decided_surface_->registerSurface(normal_surface, 0, 0, decided_size);

  // ŏ̓o^̏ꍇAIڂƂēo^
  if (decided_size == 0) {
    setSelected(0);
  }

  // wi摜̍蒼
  pimpl->updateBackSurface();
}


void ComboBoxComponent::setSelected(int index) {
  pimpl->decided_surface_->switchSurface(index);
  pimpl->updateBackSurface();
}


int ComboBoxComponent::getSelected(void) {
  if (pimpl->decided_surface_->size() == 0) {
    return NoItem;
  }
  return pimpl->decided_surface_->getSurfaceIndex();
}


bool ComboBoxComponent::isSelectChanged(void) {

  bool ret = pimpl->is_select_changed_;
  pimpl->is_select_changed_ = false;
  return ret;
}


void ComboBoxComponent::setFrameColor(Uint32 color) {
  pimpl->frame_color_ = color;
}


void ComboBoxComponent::setDecidedBackgroundColor(Uint32 color) {
  pimpl->decided_back_color_ = color;
}


void ComboBoxComponent::setSelectedBackgroundColor(Uint32 color) {
  pimpl->selected_back_color_ = color;
}


// w蕶񂩂ȂR{{bNX쐬
void ComboBoxComponent::createComboBox(boost::shared_ptr<ComboBoxComponent>&
                                       combobox,
                                       std::vector<std::string>& texts,
                                       const TextProperty& normal_property,
                                       const TextProperty& decided_property,
                                       Uint32 frame_color) {
  // o^eNA
  combobox->clearItems();

  // F̐ݒ
  combobox->setFrameColor(frame_color);
  combobox->setDecidedBackgroundColor(normal_property.back_color);
  combobox->setSelectedBackgroundColor(decided_property.back_color);

  // {^̍쐬Ɠo^
  TextProperty normal = normal_property;
  TextProperty decided = decided_property;
  for (std::vector<std::string>::iterator it = texts.begin();
       it != texts.end(); ++it) {

    normal.text = it->c_str();
    decided.text = it->c_str();

    // ڂ̓o^
    boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
    ButtonComponent::createButton(new_button, normal, decided, decided);
    combobox->addItem(new_button);
  }
}
