/*!
  \file
  \brief CD-ROM ̍Đ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "CdromPlayer.h"
#include "SdlCdromInit.h"
#include <SDL.h>
#include <string>

using namespace beego;


struct CdromPlayer::pImpl : private SdlCdromInit {
  std::string error_message_;
  SDL_CD* cdrom_;
  size_t drives_;

  pImpl(void) : error_message_("no error."), cdrom_(NULL), drives_(0) {
    openDrive();
  }

  ~pImpl(void) {
    if (cdrom_) {
      stop();
      SDL_CDClose(cdrom_);
    }
  }

  static pImpl* getObject(void) {
    static pImpl obj;
    return &obj;
  }

  // !!! hCoԍɗ^悤ɕύX
  bool openDrive(void) {
    drives_ = SDL_CDNumDrives();
    if (drives_ == 0) {
      error_message_ = "not found CD-ROM drive.";
      return false;
    }

    cdrom_ = SDL_CDOpen(0);
    if (! cdrom_) {
      error_message_ = SDL_GetError();
      return false;
    }

    return true;
  }

  bool checkDrive(void) {

    if (! cdrom_) {
      if (! openDrive()) {
        return false;
      }
    }

    CDstatus status = SDL_CDStatus(cdrom_);
    if (! CD_INDRIVE(status)) {
      error_message_ = "not found CD-ROM.";
      return false;
    }

    return true;
  }

  bool getTrackList(std::vector<track_t>& list) {

    if (! checkDrive()) {
      return false;
    }

    for (int i = 0; i < cdrom_->numtracks; ++i) {

      track_t info;
      SDL_CDtrack& track = cdrom_->track[i];
      info.id = track.id;
      info.frame_length = track.length;
      info.type = (track.type == SDL_AUDIO_TRACK) ? AudioTrack : DataTrack;

      int frame;
      FRAMES_TO_MSF(track.length, &info.min, &info.sec, &frame);

      list.push_back(info);
    }
    return true;
  }

  void play(size_t id, size_t start_frame, size_t play_frame) {
    if (! checkDrive()) {
      return;
    }

    int ntrack = (play_frame == 0) ? 1 : 0;
    //fprintf(stderr, "SDL_CDPlayTracks(cdrom_, %d, %d, %d, %d)\n", id, start_frame, ntrack, play_frame);
    SDL_CDPlayTracks(cdrom_, id, start_frame, ntrack, play_frame);
  }

  void stop(void) {
    SDL_CDStop(cdrom_);
  }
};


CdromPlayer::CdromPlayer(void) : pimpl(pImpl::getObject()) {
}


CdromPlayer::~CdromPlayer(void) {
}


const char* CdromPlayer::what(void) {
  return pimpl->error_message_.c_str();
}


bool CdromPlayer::getTrackList(std::vector<track_t>& list) {
  return pimpl->getTrackList(list);
}


void CdromPlayer::play(size_t id, size_t start_frame, size_t play_frame) {
  pimpl->play(id, start_frame, play_frame);
}


void CdromPlayer::stop(void) {
  pimpl->stop();
}
